# Clause Type Taxonomy

## Three-Tier Weighting

| Weight | Clause Types | Scoring Impact |
|--------|--------------|----------------|
| **Critical** | Indemnification, Limitation of Liability, IP/Work Ownership | Drives overall risk assessment |
| **High** | Termination, Insurance, Vendor Displacement, Non-Solicitation | Secondary risk drivers |
| **Standard** | Confidentiality, Payment/Fees, Warranties, Force Majeure, Governing Law | Supporting clauses |

---

## Detection Keywords

### Critical Weight Clauses

**Indemnification**
- Primary: indemnify, indemnification, indemnities
- Secondary: hold harmless, defend, defense costs
- Related: third-party claims, losses, damages

**Limitation of Liability**
- Primary: limitation of liability, liability cap, maximum liability
- Secondary: consequential damages, indirect damages, special damages
- Related: punitive damages, lost profits, exclusions

**IP/Work Ownership**
- Primary: intellectual property, work product, deliverables
- Secondary: ownership, title, license, assignment
- Related: background IP, foreground IP, joint ownership

### High Weight Clauses

**Termination**
- Primary: termination, terminate, cancellation
- Secondary: cure period, breach, material breach
- Related: wind-down, transition, survival

**Insurance**
- Primary: insurance, coverage, policy
- Secondary: certificate, additional insured, endorsement
- Related: general liability, professional liability, cyber liability

**Vendor Displacement**
- Primary: transition, displacement, incumbent
- Secondary: handover, knowledge transfer, cooperation
- Related: successor, replacement, outgoing vendor

**Non-Solicitation**
- Primary: non-solicitation, non-solicit, non-compete
- Secondary: hiring restriction, recruitment, employee
- Related: key personnel, cooling-off period

### Standard Weight Clauses

**Confidentiality**
- Primary: confidential, confidentiality, NDA
- Secondary: proprietary, trade secret, disclose
- Related: permitted disclosure, return of information

**Payment/Fees**
- Primary: payment, fees, compensation
- Secondary: invoice, billing, net terms
- Related: late payment, interest, expenses

**Warranties**
- Primary: warranty, warranties, warrant
- Secondary: represent, representation, guarantee
- Related: disclaimer, as-is, fitness for purpose

**Force Majeure**
- Primary: force majeure, act of god
- Secondary: pandemic, natural disaster, government action
- Related: excused performance, suspension

**Governing Law**
- Primary: governing law, applicable law, choice of law
- Secondary: jurisdiction, venue, forum
- Related: dispute resolution, arbitration

---

## Classification Rules

### Risk Level Assignment

**🔴 CRITICAL**
- Unlimited liability exposure
- One-sided indemnification without caps
- Complete IP transfer without protection
- No cure period for termination
- Missing required insurance

**🟠 HIGH**
- Liability caps below industry standard
- Broad indemnification triggers
- Ambiguous IP ownership
- Short cure periods (<15 days)
- Insurance below recommended limits

**🔵 MODERATE**
- Liability caps at industry standard
- Mutual indemnification with reasonable scope
- Clear IP ownership with license-back
- Standard cure periods (15-30 days)
- Standard insurance requirements

**🟢 LOW**
- Favorable liability caps
- Narrow, well-defined indemnification
- Retained IP with broad license grants
- Extended cure periods (>30 days)
- Comprehensive insurance with our entity as additional insured

---

## Section Number Patterns

Common contract section numbering:

| Clause Type | Typical Sections |
|-------------|------------------|
| Definitions | 1, Article I |
| Scope/Services | 2, Article II |
| Fees/Payment | 3, 4 |
| Confidentiality | 5, 6 |
| IP/Ownership | 7, 10 |
| Indemnification | 8, 11 |
| Limitation of Liability | 9, 12 |
| Insurance | 10, 13 |
| Term/Termination | 11, 12 |
| General Provisions | 13-16 |

Note: Section numbers vary by contract. Always verify by content, not position.
