---
name: citation-validator
description: 验证研究报告中所有声明的引用准确性、来源质量和格式规范性。确保每个事实性声明都有可验证的来源，并提供来源质量评级。当最终确定研究报告、审查他人研究、发布或分享研究之前使用此技能。
---

# Citation Validator

## Overview

Ensure research integrity by verifying every factual claim has accurate, complete, and high-quality citations.

## When to Use

- Before finalizing research reports
- Reviewing research from other agents
- Before publishing or sharing research
- Quality assurance checkpoint

## Core Responsibilities

1. **Verify Citation Presence**: Every factual claim must have citation
2. **Validate Completeness**: Author, date, title, URL/DOI, pages
3. **Assess Source Quality**: A-E rating system
4. **Check Accuracy**: Citations actually support claims
5. **Detect Hallucinations**: Identify unsupported claims
6. **Format Consistency**: Uniform citation style

## Source Quality Ratings

> 📋 **Reference**: See `.claude/shared/constants/source_quality_ratings.md` for full details.

- **A**: Peer-reviewed RCTs, systematic reviews, meta-analyses
- **B**: Cohort studies, clinical guidelines, reputable analysts
- **C**: Expert opinion, case reports, company white papers
- **D**: Preprints, conference abstracts, blogs
- **E**: Anonymous, biased, outdated, broken links

## Safety Limits

- **Max claims to validate**: 200 per session
- **Timeout per URL check**: 5 seconds (reduced from 10s)
- **Max parallel URL checks**: 5
- **Cache validated URLs**: 7 days TTL

## Token Optimization

> 📋 **Reference**: `.claude/shared/constants/token_optimization.md`

**Batch Validation**: Process 20 citations at a time

**URL Checking**: Cache results for 7 days in `data/citation_cache.json`

**Skip Re-validation**: If URL checked within 24 hours

**Context Budget**: 30k tokens max

## Error Handling

> 📋 **Reference**: `.claude/shared/constants/error_codes.md`

**Common Errors**:
- **E102**: URL not accessible (404) → Search for archived version
- **E401**: Hallucination detected → Remove claim or find citation (penalty: -2 points)
- **E402**: Source quality too low → Search for higher-quality sources

**Hallucination Penalty**: -2 points per occurrence (reduced from -5)

## Validation Process

1. **Claim Detection**: Identify all factual claims
2. **Citation Presence**: Check each claim has citation
3. **Completeness Check**: Verify all required elements
4. **Quality Assessment**: Assign A-E rating
5. **Accuracy Verification**: Use WebSearch/WebFetch to verify
6. **Hallucination Detection**: Flag unsupported claims
7. **Chain-of-Verification**: Extra scrutiny for critical claims

## Quality Score

**Target**: ≥ 8/10

- Citation coverage (0-3 pts)
- Completeness (0-2 pts)
- Accuracy (0-3 pts)
- Source quality (0-2 pts)
- Hallucination penalty (-5 pts each)

## Examples

See [examples.md](./examples.md) for validation scenarios.

## Detailed Instructions

See [instructions.md](./instructions.md) for complete validation methodology.
