# Pain Points by Vertical

## E-commerce / Retail

### Order Management
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Manual order entry from marketplaces | 2-4 hrs/day | Multi-channel sync |
| Inventory sync across channels | Overselling, stockouts | Real-time inventory |
| Order status updates | Customer complaints | Auto-notifications |
| Returns processing | 30min per return | Auto-RMA workflow |
| Shipping label generation | 5min per order | Batch automation |

### Customer Experience
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| "Where's my order?" inquiries | Support overload | Proactive tracking |
| Review/feedback collection | Missing social proof | Post-purchase flow |
| Abandoned cart | 70% revenue loss | Recovery emails |
| Customer segmentation | Poor targeting | Auto-tagging |

### Questions to Ask
- "How do you handle orders from Amazon vs Shopify vs direct?"
- "What happens when you sell the last item on multiple channels?"
- "How many support tickets are about order status?"
- "What's your cart abandonment rate?"

---

## Professional Services (Law, Accounting, Consulting)

### Client Management
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Client onboarding | 2-3 hrs per client | Intake automation |
| Document collection | Endless follow-ups | Auto-reminders |
| Meeting scheduling | Back-and-forth emails | Booking links |
| Time tracking | Lost billable hours | Auto-capture |

### Billing & Collections
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Invoice generation | Hours monthly | Auto-invoicing |
| Payment follow-ups | Awkward conversations | Auto-reminders |
| Expense tracking | Missing deductions | Receipt capture |
| Trust account reconciliation | Compliance risk | Auto-reconciliation |

### Questions to Ask
- "How do new clients typically come to you?"
- "Walk me through onboarding a new client."
- "How do you track your time?"
- "What's your process for chasing unpaid invoices?"
- "How many hours per week on admin vs billable?"

---

## Logistics / Shipping / Distribution

### Operations
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Delivery scheduling | Double-bookings | Slot management |
| Route optimization | Wasted fuel/time | Auto-routing |
| Driver dispatch | Radio/phone chaos | Auto-assignment |
| Proof of delivery | Disputes | Photo/signature capture |

### Communication
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| ETA updates | "Where's my delivery?" | Proactive SMS |
| Failed delivery handling | Return trips | Reschedule workflow |
| Customer notifications | Manual calls | Auto-alerts |
| Partner coordination | Miscommunication | Shared dashboards |

### Questions to Ask
- "How do customers know when to expect delivery?"
- "What happens when a delivery fails?"
- "How do drivers report issues?"
- "How do you handle proof of delivery?"

---

## Legal

### Document Management
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Contract drafting | Repetitive templates | Doc automation |
| Version control | Wrong version sent | Auto-versioning |
| Signature collection | Delays | e-Signature workflow |
| Document search | Hours finding files | AI search |

### Case Management
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Deadline tracking | Malpractice risk | Calendar automation |
| Court filing | Manual submissions | e-Filing integration |
| Client updates | "No news" complaints | Status updates |
| Conflict checks | Compliance risk | Auto-screening |

### Questions to Ask
- "How do you ensure you never miss a deadline?"
- "What's your document review process?"
- "How do clients know what's happening with their case?"
- "How long does it take to draft a standard [contract type]?"

---

## Finance / Accounting

### Transaction Processing
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Bank reconciliation | Hours weekly | Auto-matching |
| Invoice data entry | Manual, error-prone | OCR + auto-entry |
| Expense categorization | Month-end crunch | AI categorization |
| Multi-currency | Conversion errors | Auto rates |

### Reporting
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Report generation | Days per report | Auto-reports |
| Data consolidation | Multiple sources | Integration hub |
| Compliance filings | Deadline stress | Auto-filing |
| Audit prep | Weeks of work | Continuous audit |

### Questions to Ask
- "How many hours per month on reconciliation?"
- "How do you consolidate data from different systems?"
- "What's your month-end close process?"
- "How long does it take to pull a [specific report]?"

---

## SaaS / Tech

### Customer Success
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Onboarding new users | Churn at day 1 | Welcome sequences |
| Usage tracking | Silent churn | Engagement alerts |
| Health scoring | Surprise cancellations | Predictive alerts |
| NPS/CSAT collection | No feedback | Auto-surveys |

### Product-Led Growth
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Trial conversion | Low conversion | Nurture sequences |
| Feature adoption | Unused features | In-app nudges |
| Upgrade triggers | Missed expansion | Usage-based offers |
| Churn prevention | Revenue loss | Risk alerts |

### Questions to Ask
- "How do you know when a user is about to churn?"
- "What does your onboarding look like?"
- "How do you identify power users?"
- "What triggers an upgrade conversation?"

---

## Construction / Real Estate

### Project Management
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Daily reports | End of day scramble | Field capture app |
| Change orders | Unbilled work | Auto-documentation |
| Inspection scheduling | Coordination chaos | Auto-booking |
| Photo documentation | Lost evidence | Auto-organization |

### Financial
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Progress billing | Cash flow gaps | Milestone invoicing |
| Subcontractor payments | Lien waivers | Auto-workflow |
| Job costing | Profit leaks | Real-time tracking |
| Material tracking | Waste, theft | Inventory alerts |

### Questions to Ask
- "How do you track daily progress?"
- "What's your change order process?"
- "How do you ensure you bill for all work?"
- "How do you manage subcontractor documentation?"

---

## Healthcare / Medical

### Patient Flow
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Appointment reminders | No-shows | SMS/email automation |
| Intake forms | Manual data entry | Digital forms |
| Insurance verification | Denied claims | Auto-verification |
| Follow-up scheduling | Lost patients | Auto-booking |

### Administrative
| Pain Point | Impact | Automation Opportunity |
|------------|--------|----------------------|
| Prior authorization | Days of waiting | Auto-submission |
| Referral management | Lost referrals | Tracking workflow |
| Documentation | Burnout | Voice-to-text |
| Billing/coding | Revenue leakage | AI coding assist |

### Questions to Ask
- "What's your no-show rate?"
- "How long does prior auth take?"
- "How do you handle after-hours inquiries?"
- "What percentage of claims get denied first time?"

---

## Universal Pain Indicators

### Time Wasters
- "We spend hours on..."
- "Someone has to manually..."
- "We do this every [day/week/month]..."

### Error Sources
- "Sometimes we miss..."
- "Things fall through the cracks..."
- "We've had issues with..."

### Frustration Signals
- "I wish we could..."
- "It's annoying that..."
- "We've always done it this way, but..."

### Risk Concerns
- "We're worried about..."
- "If this goes wrong..."
- "We can't afford to..."
