---
name: coaching-materials-creator
description: This skill should be used when creating coaching guides, peer learning structures, and post-workshop support materials. Use this skill to design coaching conversations using Kolb's cycle, create community of practice frameworks, and enable sustained learning.
---

# Coaching Materials Creator

## Overview

The Coaching Materials Creator skill helps develop coaching guides, peer learning activities, and structures for sustained learning. It uses Kolb's Experiential Learning Cycle to structure coaching conversations and creates frameworks for peer learning and communities of practice.

## When to Use This Skill

- Creating coaching conversation guides
- Designing Kolb's cycle reflection structures
- Building peer learning activities and structures
- Creating community of practice charters
- Developing manager coaching prompts
- Creating feedback and peer review guides
- Planning for sustained learning beyond workshop

## Kolb's Experiential Learning Cycle

**Concrete Experience**: What did you do/try?
**Reflective Observation**: What happened? How did it go?
**Abstract Conceptualization**: Why? What patterns?
**Active Experimentation**: What will you try next?

## Coaching Conversation Framework

Structure coaching using Kolb's cycle:
1. Ask about concrete experience (what they did)
2. Explore reflection (what happened, how felt)
3. Guide conceptualization (patterns, principles)
4. Support experimentation (next steps/commitment)

## Peer Learning Structures

- Pair programming or co-working
- Peer code/work review
- Lunch-and-learns
- Retrospectives
- Study groups

## Communities of Practice

- Purpose and charter
- Meeting cadence
- Discussion frameworks
- Knowledge sharing norms
- Facilitator role

## Resources

Reference templates for:
- Coaching conversation guides
- Kolb cycle reflection prompts
- Peer learning activity designs
- CoP charter template
- Manager coaching prompts
- Feedback and review guides

## Integration with Other Skills

- **training-designer**: Use together to design sessions
- **training-reviewer**: Validate materials
- **training-content-creator**: Generate actual content
- Use these alongside **learning-journey-builder** for complete programs

## Best Practices

✅ **Do**:
- Focus on learner outcomes and business impact
- Use real work examples and scenarios
- Design for application, not knowledge recall
- Measure what matters

❌ **Don't**:
- Train what doesn't drive behavior change
- Use simulated practice over real work
- Over-design solutions for simple problems
- Ignore the business context
