---
name: code-explainer
description: Explains code in simple terms with visual diagrams. Use when the user asks to explain code, understand how something works, or wants a code walkthrough.
---

# Code Explainer Skill

## Purpose
Help users understand code by providing clear explanations with visual ASCII diagrams.

## Instructions

When explaining code:

1. **Start with the big picture** - What does this code do overall?
2. **Break down into components** - Identify key functions/classes
3. **Use ASCII diagrams** - Visualize flow and relationships
4. **Provide examples** - Show input/output scenarios

## Explanation Format

```
## Overview
[Brief summary of what the code does]

## Components
[List key parts]

## Flow Diagram
[ASCII art showing how data/control flows]

## Key Concepts
[Important patterns or techniques used]

## Example
[Concrete usage example]
```

## Example ASCII Diagrams

### Function Flow
```
Input → [Validate] → [Process] → [Format] → Output
```

### Class Hierarchy
```
    BaseClass
       │
   ┌───┴───┐
   │       │
ChildA  ChildB
```

## When to Use
- User asks "explain this code"
- User says "how does X work"
- User wants to understand a function/class
- User asks for a code walkthrough
