---
name: code-review
description: 专业代码审查技能。当用户需要审查代码、检查 PR、评估代码质量、发现潜在问题或提供改进建议时使用此技能。
---

# Code Review

执行专业、全面的代码审查，关注代码质量、安全性、性能和可维护性。

## 审查流程

1. **理解上下文**：了解代码的目的和业务背景
2. **结构审查**：检查整体架构和设计模式
3. **逐行审查**：详细检查代码实现
4. **输出报告**：提供结构化的审查结果

## 审查维度

###🔒 安全性
- SQL 注入、XSS、CSRF 等漏洞
- 敏感信息泄露（密钥、密码硬编码）
- 输入验证和输出编码
- 权限和认证检查

### ⚡ 性能
- 算法复杂度（避免 O(n²) 等低效实现）
- 数据库查询优化（N+1 问题）
- 内存泄漏风险
- 不必要的重复计算

### 🧹 代码质量
- 命名规范（变量、函数、类）
- 函数长度（建议 < 50 行）
- 圈复杂度（建议 < 10）
- DRY 原则（避免重复代码）

### 📖 可维护性
- 注释和文档完整性
- 错误处理覆盖
- 测试覆盖率
- 依赖管理

## 输出格式

```markdown
## 代码审查报告

### 📊 总体评估
- 质量评分：X/10
- 风险等级：低/中/高

### 🚨 必须修复
1. [严重] 问题描述 - 文件:行号
   - 原因：...
   - 建议：...

###⚠️ 建议改进
1. [中等] 问题描述
   - 建议：...

### 💡 优化建议
1. 可选的改进点

### ✅ 亮点
- 代码中做得好的地方
```

## 审查原则

- **具体明确**：指出具体文件和行号
- **提供方案**：不只指出问题，还要给出解决建议
- **区分优先级**：区分必须修复和可选优化
- **保持尊重**：对事不对人，使用建设性语言