---
name: code-review
description: |
  **AUTO-ACTIVATE after code changes** (Write, Edit, NotebookEdit tools used).

  Comprehensive code review using 15-point checklist. Reviews: completeness,
  correctness, testability, reusability, consistency, design, error handling,
  security, documentation, performance, UX, data migration, dependencies.

  Triggers: code written, files modified, implementation complete, "review code"
---

# Code Review Skill

## When to Use

自动激活条件：
- **主动触发**：代码编写完成后自动激活
- 用户明确要求"Review代码"
- 准备提交代码前
- 发现Bug需要检查代码质量时

## Core Patterns

### 1. Review 流程

```
1. 代码完整性检查（是否实现所有功能）
2. 代码准确性检查（逻辑是否正确）
3. 可测试性检查（是否有测试）
4. 可复用性检查（是否有重复代码）
5. 一致性检查（风格是否统一）
6. 设计合理性检查（是否过度设计）
7. 错误处理检查（边界情况）
8. 安全性检查（常见漏洞）
9. 性能检查（瓶颈和优化点）
10. 文档注释检查（可读性）
```

### 2. 完整性检查（15项）

基于 `checklists/code-quality.md`：

#### 1. 功能完整性
- [ ] 所有设计的功能都已实现
- [ ] 所有必要的文件都已修改
- [ ] 没有遗漏的 TODO 注释
- [ ] 没有注释掉的代码（除非有说明）
- [ ] 所有引用的资源都存在（图片/文件/API等）

#### 2. 准确性
- [ ] 代码逻辑符合架构设计
- [ ] 数据模型实现正确
- [ ] UI组件符合设计稿
- [ ] 业务逻辑准确无误
- [ ] 命名规范统一（变量/函数/类）

#### 3. 可测试性
- [ ] 关键逻辑有测试用例
- [ ] 边界条件有测试覆盖
- [ ] 错误情况有测试验证
- [ ] 测试数据准备充分
- [ ] Mock/Stub 使用合理

#### 4. 可复用性
- [ ] 没有重复代码（遵循 DRY 原则）
- [ ] 组件/函数职责单一
- [ ] 可复用的逻辑已提取
- [ ] 配置项与代码分离
- [ ] 魔法数字/字符串已常量化

#### 5. 一致性
- [ ] 代码风格一致（缩进/命名/格式）
- [ ] 与现有代码风格保持一致
- [ ] API 命名风格统一
- [ ] 错误处理方式统一
- [ ] 日志格式统一

#### 6. 设计合理性
- [ ] 没有过度设计
- [ ] 没有性能瓶颈
- [ ] 数据结构设计合理
- [ ] 算法效率可接受
- [ ] 内存使用合理

#### 7. 错误处理
- [ ] 所有可能的异常都已捕获
- [ ] 错误信息清晰明确
- [ ] 错误不会导致崩溃
- [ ] 用户友好的错误提示
- [ ] 记录足够的错误日志

#### 8. 数据安全
- [ ] 没有 SQL 注入风险
- [ ] 没有 XSS 风险
- [ ] 敏感数据已加密
- [ ] 输入数据已验证
- [ ] 权限控制正确

#### 9. 注释与文档
- [ ] 复杂逻辑有注释说明
- [ ] 公共 API 有文档注释
- [ ] 关键算法有说明
- [ ] 特殊处理有原因说明
- [ ] 不使用误导性注释

#### 10. 性能优化
- [ ] 没有不必要的计算
- [ ] 循环优化合理
- [ ] 数据库查询优化
- [ ] 避免内存泄漏
- [ ] 资源正确释放

#### 11. 用户体验
- [ ] 加载状态有提示
- [ ] 操作有反馈
- [ ] 错误有友好提示
- [ ] 关键操作有确认
- [ ] 界面响应及时

#### 12. 数据迁移
- [ ] 考虑了旧数据兼容
- [ ] 有数据迁移方案
- [ ] 迁移脚本已测试
- [ ] 回滚方案已准备
- [ ] 数据完整性验证

#### 13. 依赖管理
- [ ] 新依赖有必要性说明
- [ ] 依赖版本明确
- [ ] 许可证兼容
- [ ] 没有循环依赖
- [ ] 依赖安全性检查

#### 14. Git 提交
- [ ] 提交信息清晰
- [ ] 相关修改在同一提交
- [ ] 没有包含调试代码
- [ ] 没有包含敏感信息
- [ ] 分支命名规范

#### 15. 符合 doc/tel 规范
- [ ] 代码变更文档完整
- [ ] 示例与调用路径清晰
- [ ] 测试策略明确
- [ ] 运维与监控考虑完整
- [ ] 风险与决策记录清晰

### 3. 评分标准

```
优秀（93%+）：14-15 项通过
  → 可以合并，代码质量很高

良好（73%-93%）：11-13 项通过
  → 修复关键问题后可以合并

需改进（53%-73%）：8-10 项通过
  → 需要重构部分代码

不合格（<53%）：<8 项通过
  → 建议重写或大幅修改
```

### 4. Review反馈格式

```markdown
## 代码审查报告

### 通过项（✅ 11/15）
1. ✅ 功能完整实现
2. ✅ 命名规范统一
...

### 需要改进（⚠️ 3项）

#### ⚠️ Critical - 必须修复
1. **缺少错误处理**
   - 位置：`TaskList.tsx:45`
   - 问题：API调用没有 try-catch
   - 建议：
     ```typescript
     try {
       await updatePriority(id, priority);
     } catch (error) {
       console.error(error);
       showError('优先级更新失败');
     }
     ```

#### ⚠️ Warning - 应该修复
1. **重复代码**
   - 位置：`TaskItem.tsx:20-25` 和 `TaskList.tsx:30-35`
   - 问题：相同的颜色映射逻辑
   - 建议：提取到 `utils/priority.ts`

#### 💡 Suggestion - 可以改进
1. **性能优化**
   - 位置：`TaskList.tsx:50`
   - 建议：使用 `useMemo` 缓存过滤后的任务列表

### 总体评价
- 评分：11/15（73%，良好）
- 建议：修复 Critical 问题后可以合并
- 下次改进方向：增强错误处理、减少代码重复
```

## Anti-Patterns

### ❌ 错误做法

1. **只看代码，不看需求**
   ```
   ❌ 只检查代码是否有bug
   ✅ 检查代码是否实现了需求文档中的所有功能
   ```

2. **只提问题，不给方案**
   ```
   ❌ "这里有问题"
   ✅ "这里有问题，建议修改为：[代码示例]"
   ```

3. **过于主观**
   ```
   ❌ "我觉得这样写不好"
   ✅ "违反了单一职责原则，建议拆分成两个函数"
   ```

4. **忽略小问题**
   ```
   ❌ "小问题不重要，不用管"
   ✅ "虽然是小问题，但影响可读性，建议修复"
   ```

5. **批量提出问题**
   ```
   ❌ 一次提出20个问题，让开发者overwhelmed
   ✅ 按优先级分类：Critical > Warning > Suggestion
   ```

## Integration with Other Skills

1. **← requirement-clarification**
   - 对照需求文档检查功能完整性

2. **← architecture-design**
   - 检查实现是否符合架构设计

3. **← ui-design-system**
   - 检查UI是否符合设计规范

4. **← code-implementation**
   - 检查是否遵循代码规范

## Automated Checks

在手动Review前，先运行自动化检查：

```bash
# 1. 代码格式检查
npm run lint

# 2. 类型检查
npm run typecheck

# 3. 单元测试
npm test

# 4. 代码覆盖率
npm run test:coverage

# 5. 构建检查
npm run build
```

**如果自动化检查不通过，不要进行手动Review！**

## Best Practices

1. **先表扬，再批评**
   - 先说做得好的地方
   - 再指出需要改进的地方

2. **提供上下文**
   - 说明为什么这是问题
   - 解释背后的原理

3. **给出具体建议**
   - 不只说"有问题"
   - 给出具体的修改代码

4. **区分优先级**
   - Critical：必须修复
   - Warning：应该修复
   - Suggestion：可以改进

5. **鼓励学习**
   - 推荐相关资料
   - 解释最佳实践

## Review Template

```markdown
## 代码审查报告

**审查时间**：YYYY-MM-DD
**审查人**：Claude
**评分**：X/15（XX%）

### ✅ 做得好的地方
1. ...
2. ...

### ⚠️ Critical - 必须修复
1. ...

### ⚠️ Warning - 应该修复
1. ...

### 💡 Suggestion - 可以改进
1. ...

### 总体评价
- [简短总结]
- [是否可以合并]
- [下次改进建议]
```
