---
name: coding-practices
description: This skill should be used when the user asks about "coding best practices", "code conventions", "code style", "how to write good code", "clean code", or asks for guidance on code quality and patterns. Scaffold skill - expand with your preferred practices.
version: 0.1.0
---

# Coding Practices

Scaffold skill for coding best practices and conventions. Expand this skill with your preferred patterns, style guides, and development workflows.

## Structure

To build out this skill, add content covering:

### Code Quality
- Naming conventions
- Function design
- Error handling patterns
- Testing approaches

### Project Structure
- Directory organization
- Module patterns
- Configuration management

### Workflow
- Git conventions
- Code review guidelines
- Documentation standards

## References

Add detailed guides to `references/`:
- `references/style-guide.md` - Language-specific style guides
- `references/patterns.md` - Common design patterns
- `references/testing.md` - Testing strategies

## Examples

Add working examples to `examples/`:
- `examples/good-function.py` - Well-structured function example
- `examples/error-handling.js` - Error handling patterns

## Customization

Replace this scaffold content with your actual coding practices and preferences. Focus on patterns that:

1. You use repeatedly
2. Are non-obvious to a general LLM
3. Are specific to your tech stack or organization

Keep SKILL.md lean (1,500-2,000 words) and move detailed content to references/.
