---
name: cold-call-scripts
description: Creates personalized cold call scripts using a proven 5-step framework. Use this skill when preparing for prospecting calls, coaching reps on call structure, or creating call templates for campaigns.
---

# Cold Call Scripts

This skill creates personalized, effective cold call scripts using a proven 5-step framework that helps you engage prospects, qualify opportunities, and book meetings.

## Objective

Generate compelling cold call scripts that feel natural, highlight your value proposition, and move prospects toward a next step-while avoiding the common pitfalls that get calls hung up.

## The 5-Step Cold Call Framework

### Step 1: Opening & Introduction
Set the tone and grab attention in the first 10 seconds.

**Structure:**
```
"Hi [Name], this is [Your Name] with [Company]."
[Pattern Interrupt or Permission-Based Opener]
```

**Pattern Interrupt Options:**
- "Did I catch you at a bad time?" (counterintuitive, creates curiosity)
- "I know I'm calling out of the blue..." (acknowledges reality)
- "We've never spoken before, but..." (sets honest context)
- Reference something specific about them or their company

**What to Avoid:**
- "How are you today?" (screams sales call)
- "Is this a good time?" (invites dismissal)
- Apologizing for calling
- Weather talk or generic small talk
- Excessive flattery or sycophantic language

### Step 2: Reason for Call (The Hook)
Explain why you're calling in a way that earns more time.

**Structure:**
```
"The reason I'm calling is..."
[Specific trigger or relevant context]
[Your specialization statement]
```

**Key Elements:**
- **Trigger Reference**: Show you've done research
  - "I noticed [company] just announced..."
  - "I saw that you're hiring for..."
  - "I read your post about..."

- **Specialization Statement**: Position your expertise
  - "We specialize in helping [type of company] with [specific problem]"
  - "We work with [similar companies] to [achieve outcome]"

**Example:**
"The reason I'm calling is I saw you just raised Series B, and we specialize in helping fast-growing sales teams onboard reps 50% faster."

### Step 3: Value Proposition
Articulate the specific value you deliver.

**Structure:**
```
[Problem you solve]
[Result you deliver]
[Proof point if available]
```

**Value Prop Formula:**
"We help [target audience] [achieve outcome] by [how you do it]."

**Make It Specific:**
- Not: "We help companies be more efficient"
- But: "We help sales teams cut new rep ramp time from 6 months to 3"

**Include Proof When Possible:**
- "Companies like [similar company] have seen..."
- "On average, our customers experience..."
- "Just last quarter, we helped [customer] achieve..."

### Step 4: Qualification Questions
Determine if there's a fit through strategic questions.

**Structure:**
```
[Transition phrase]
[2-3 qualifying questions]
```

**Transition Phrases:**
- "I'm curious..."
- "Quick question..."
- "Help me understand..."

**Effective Questions:**
- **Situation Questions**: "How are you currently handling [process]?"
- **Problem Questions**: "What's your biggest challenge with [area]?"
- **Implication Questions**: "What happens if that doesn't get solved?"
- **Need-Payoff Questions**: "If you could [outcome], what would that mean?"

**Rules:**
- Ask no more than 2-3 questions
- Listen more than you talk
- Take notes on their answers
- Don't interrogate-have a conversation

### Step 5: Close / Call to Action
Ask for a specific next step.

**Structure:**
```
[Transition based on conversation]
[Specific ask with time frame]
[Make it easy to say yes]
```

**Closing Options:**
- **Direct Ask**: "Would it make sense to schedule 20 minutes to explore this?"
- **Alternative Close**: "Would Tuesday or Thursday work better?"
- **Value Close**: "I'd love to show you how [specific benefit]. Can we find 15 minutes?"
- **Curiosity Close**: "Even if we're not a fit, I can share some insights we've learned. Worth a quick call?"

**If They're Hesitant:**
- Offer something smaller: "How about a quick 10-minute call?"
- Provide immediate value: "I can send you [resource] that might help"
- Plant a seed: "When would be a better time to revisit this?"

## Script Guidelines

### Sound Human
- Use contractions (don't, can't, we're)
- Avoid corporate buzzwords (synergy, leverage, innovative)
- Speak like you would to a colleague
- Pause for responses-don't monologue

### Be Confident, Not Apologetic
- Never apologize for calling
- Own your reason for reaching out
- Assume you have something valuable to offer
- Project confidence through tone

### Personalize Meaningfully
- Reference specific research about them
- Connect to their situation or challenges
- Use their language and terminology
- Make it clear this isn't a mass dial

### Stay Flexible
- Scripts are guides, not rigid word-for-word reads
- Adapt based on the conversation flow
- Have responses ready for common objections
- Know when to pivot or cut losses

## Common Objection Responses

### "I'm busy right now"
"Totally understand-when would be a better time for a quick 5-minute conversation?"

### "Just send me an email"
"Happy to do that. So I can send something relevant, quick question: [qualification question]?"

### "We already have a solution"
"Got it-most companies I talk to do. Just curious, how's that working for you? Any gaps?"

### "We don't have budget"
"Appreciate the transparency. Many customers come to us when they're planning next quarter. When does your next budget cycle start?"

### "I'm not the right person"
"No problem-who should I be talking to about [specific area]? I'll make sure not to bother you again."

## Output Format

When creating a cold call script, produce:

1. **Opening**: Pattern interrupt and introduction
2. **Hook**: Research-backed reason for calling
3. **Value Prop**: Specific, outcome-focused statement
4. **Questions**: 2-3 qualification questions
5. **Close**: Clear call to action
6. **Objection Handlers**: 3-5 likely objections with responses
7. **Personalization Notes**: What specific research was incorporated

## Cross-References

- Use `prospect-research` to personalize the hook
- Use `company-intelligence` for company-specific value props
- Apply `powerful-framework` in qualification questions
- Follow up with `follow-up-emails` if call doesn't connect
