---
name: cold-email-analyst
description: Rapid due-diligence analyst for cold emails and inbound pitches. Auto-activates for "review this cold email", "due diligence on this pitch", "is this legit?", or "analyze this email". Checks credibility (domain, BBB, funding), gauges strategic fit, weighs ROI, flags red flags, delivers verdict (Engage/Ignore/Park) with reply template in Sid's voice.
---

# Cold Email Analyst

> **"The press shouldn't come with a price tag"**
> **"If they need money from you, they're not journalists—they're salespeople"**

## Core Principle

Cold emails and inbound pitches require rapid yet rigorous due diligence. This skill packages the credibility-check → strategic-fit → ROI-analysis → verdict workflow into an 8-12 minute protocol that prevents:

- **Vendor scams** (Semrush $651 lesson)
- **Wrong opportunities** (CREtech $4-5K lesson)
- **Time waste** (30-min sales calls for fake placements)
- **DEBT position** (paying for validation instead of earning it)

The CREDITOR energy test applies: Does this make you feel RICH (they're pursuing you with value) or POOR (you need to pay for validation)?

## When to Use This Skill

**Auto-activates for:**
- "Review this cold email"
- "Due diligence on this pitch"
- "Is this legit?" (with email pasted)
- "Analyze this email"
- "Vet this sender"

**Use when:**
- Unsolicited inbound claiming you've been "selected/nominated/identified"
- Partnership/collaboration pitches from unknown parties
- Magazine/publication feature opportunities
- Award nominations requiring fees
- Vendor cold outreach
- Any pitch where legitimacy unclear

**Don't use when:**
- Warm intros from known contacts (use judgment, not protocol)
- Existing vendor communications (different protocol)
- Customer support emails (use customer-intelligence skill)
- Internal team communications

## The 4-Phase Protocol (8-12 minutes)

### Phase 0: Triage (1 minute)

**Questions to answer:**
- Domain match? (sender@company.com vs sender@thirdparty.com)
- Sender real? (name + title verifiable)
- Solicited or cold? (did you request this?)
- Specific ask or vague "next steps"?

**Red flags at triage:**
- Third-party domain claiming to represent major brand
- "You've been selected/nominated/identified" language
- Vague "share details" with no specifics
- Urgency pressure ("limited time", "act fast")

**Output:** Initial scam probability (0-100%)

**Example:**
```
Email from: Isabel Garcia <i.garcia@nettyawards.com>
Claims: Architectural Digest feature opportunity
Domain: ❌ NOT @condenast.com or @architecturaldigest.com
Language: ❌ "identified for inclusion" (classic pay-to-play)
Ask: ❌ Vague "share details and next steps"

Triage result: 85% scam probability → Proceed to research
```

### Phase 1: Research (3-5 minutes)

**Use WebSearch tool for:**

**Credibility checks:**
```
1. "[company/domain] scam"
2. "[company] BBB" OR "[company] complaints"
3. "[sender name] [company] LinkedIn"
4. "[claimed partnership/series/award] [year]"
5. "site:reddit.com [company]"
```

**What you're looking for:**
- BBB Scam Tracker listings
- Scam Advisor ratings
- Reddit/forum warnings
- LinkedIn verification of sender
- Actual existence of claimed opportunity
- Similar scam pattern reports

**Evidence to document:**
- Direct scam confirmations (BBB, Scam Advisor)
- First-hand accounts from other businesses
- Broken promises (paid but received nothing)
- Known tactics (blacklisted emails, fake judges, etc.)
- Absence of evidence (claimed series doesn't exist)

**Output:** Evidence summary with sources cited

**Example:**
```
WebSearch results:
- BBB Scam Tracker: "Vanity Award - Phishing Scam" (Sept 2024)
- Scam Advisor: Flagged as medium-risk scam site
- UltimateWB Blog: "Netty Awards: Entrepreneur's Guide to Avoiding Vanity Scams"
- Multiple Reddit posts: "$495 fee, received worthless social media kit"
- Zero results: "Architectural Digest Design Innovation series" (doesn't exist)
- No LinkedIn: Isabel Garcia at nettyawards (person doesn't exist)

Evidence: CONFIRMED SCAM (95-100% probability)
```

### Phase 2: Strategic Fit (2 minutes)

**Load context from:**
- `projects/rai-ceo/NOW.md` - Current priorities
- `projects/rai-ceo/MEMORY.md` - Past vendor/opportunity patterns
- Recent learnings (CREtech, Semrush, etc.)

**Questions to answer:**
- Does this align with current strategic priorities?
- Is the audience/opportunity RIGHT even if method wrong?
- Recent analogous experiences? (learned anything applicable?)
- Would this make Sid feel RICH or POOR? (CREDITOR test)

**Strategic context matters:**
```
Example: Architectural Digest pitch
- Audience = PERFECT (design-forward homeowners)
- Method = WRONG (pay-to-play vs earned editorial)
- Recent learning = CREtech $4-5K (vet opportunities carefully)
- CREDITOR test = Feels POOR (pay for validation)

Strategic fit: Right audience, wrong method = Still wrong
```

**Output:** Strategic assessment (alignment, timing, energy test)

### Phase 3: ROI Analysis (1 minute)

**Calculate costs:**
- Direct cost (fees revealed or estimated from pattern)
- Time investment (emails, calls, deliverable creation)
- Opportunity cost (what else could $X buy?)
- Risk cost (brand damage, credibility hit)

**Estimate value:**
- Actual deliverable (what do you receive?)
- Credibility gain (earned vs paid placement)
- Audience reach (legitimate vs fake metrics)
- Long-term benefit (real relationship vs one-time)

**Compare to alternatives:**
- CREtech: $4-5K → Market intel (learned wrong audience)
- Semrush: $651 → Nothing (cancelled, disputed, recovered)
- This opportunity: $X → ? (compare to known patterns)

**Output:** ROI calculation (cost/value/alternatives)

**Example:**
```
Netty Awards + "Architectural Digest feature":
- Estimated cost: $495-$5,000 (typical scam range)
- Time investment: 2 min (counter-intel) OR 30-60 min (sales call)
- Actual value: $0 (worthless PDF or nothing)
- Alternative: $5K → Google Ads to real homeowners

ROI: Negative infinity (pay for nothing)
```

### Phase 4: Verdict + Reply Template (1 minute)

**Deliver verdict:**
- **ENGAGE** - Legitimate opportunity worth pursuing
- **IGNORE** - Confirmed scam or zero value
- **PARK** - Unclear, needs more info or timing wrong
- **COUNTER-INTEL** - Test with direct questions to expose tactics

**For each verdict, provide:**
1. Clear reasoning (why this verdict)
2. Next action (what to do)
3. Reply template in Sid's voice (ready to send)

**Output:** Complete analysis package

**Verdict format:**
```
⚖️ VERDICT: [IGNORE/ENGAGE/PARK/COUNTER-INTEL]

Reasoning:
- [Evidence-based rationale]
- [Strategic context]
- [ROI reality]

Next action:
- [Specific steps]

📧 Reply Template:
[Ready-to-send email in Sid's voice]
```

## Output Format

**Standard analysis structure:**
```
## Cold Email Analysis: [Sender/Company]

### 📧 Email Summary
- From: [sender + domain]
- Claims: [what they're offering]
- Ask: [what they want]

### 🔍 Credibility (Phase 1)
- Domain/BBB/Funding check results
- Scam reports found (with sources)
- Sender verification results
- Red flags documented

### 🎯 Strategic Fit (Phase 2)
- Alignment with current priorities
- Audience/opportunity assessment
- Recent learnings applicable
- CREDITOR energy test result

### 💰 ROI Analysis (Phase 3)
- Cost estimate (direct + time + opportunity)
- Value estimate (actual deliverable)
- Comparison to alternatives
- ROI calculation

### 🚩 Red Flags
1. [Numbered list of specific red flags]
2. [With evidence for each]

### ⚖️ VERDICT: [Choice]
**Reasoning:** [Why this verdict based on evidence]
**Next action:** [Specific steps to take]

### 📧 Reply Template (if engaging)
[Email draft in Sid's voice, ready to send]
```

## Integration Points

**Context sources:**
- `projects/rai-ceo/MEMORY.md` - Vendor patterns, past scams (Semrush, CREtech)
- `projects/rai-ceo/NOW.md` - Current priorities, strategic focus
- WebSearch tool - Live credibility research
- CREDITOR energy test - From CLAUDE.md protocol thinking

**Skill composition:**
- Uses `business-writing` skill for reply templates (Sid's voice)
- Feeds into customer-intelligence for support vs sales routing
- Informs vendor-vetting for subscription decisions
- Pattern data flows back to MEMORY.md for learning

**Learning loop:**
- Document outcomes in MEMORY.md (was verdict correct?)
- Evolve scam pattern database over time
- Refine research queries based on effectiveness
- Improve reply templates based on responses

## Critical Patterns

### The Scam Patterns to Know

**Pay-to-play magazine features:**
- Unsolicited "you've been selected" emails
- Third-party domain (not publication's official)
- Vague "share details" (hiding price)
- $3K-$10K "feature packages"
- Worthless deliverables (PDF certificates, social media kits)

**Vanity awards:**
- "Nominated" messages with urgency
- $495-$2,000 fees
- Broken website links (fake judges, no verification)
- Winners receive nothing or worthless plaque
- Known scam companies: Netty Awards, similar variants

**Fake partnership opportunities:**
- Claims of "exclusive" access
- Requires upfront payment for "consideration"
- No clear deliverable or timeline
- High-pressure sales tactics
- "Limited time" urgency

### The CREDITOR Energy Test

**Close your eyes and feel:**
- Does this make me feel RICH? (they're pursuing me, offering value)
- Does this make me feel POOR? (I need to pay for validation)

**If POOR = DEBT position = Reject immediately**

Examples that feel POOR:
- Paying for award nominations
- Buying magazine "features"
- Fees for partnership "consideration"
- Charges for "exclusive access"

Examples that feel RICH:
- Real journalists requesting interviews
- VCs pursuing minority investment
- Customers paying premium prices
- Partners offering value first

### The Domain Mismatch Rule

**Immediate disqualifier:**
- Email from `sender@thirdparty.com` claiming to represent Major Brand
- Real partnerships come from official domains
- Example: Architectural Digest = @condenast.com, NOT @nettyawards.com

**Legitimate third-party:**
- PR agency representing you (you hired them)
- Your CPA emailing from their firm
- Your lawyer from their practice
- Known partners using their company domain

**The test:** If they claim affiliation, domain must match.

### Reply Template Patterns

**For counter-intelligence (exposing scam):**
```
[Name],

Thanks for reaching out. Before we discuss:

1. What's the total cost, all-in?
2. Is this paid placement or editorial?
3. Share your partnership documentation with [Brand].
4. Link me to 3 companies you've featured on [Brand's actual site].

We move fast on real opportunities. Paid placements aren't our game.

Sid
```

**For legitimate opportunities:**
```
[Name],

Interesting. Quick questions:

1. What's the story angle? (not "details" - the actual story)
2. What's your deadline?
3. What do you need from us? (interviews, data, assets)

If it's editorial, we're in. If it's paid, we're out.

Sid
```

**For parking (needs more info):**
```
[Name],

Appreciate the outreach. Not the right timing right now.

Circle back in [timeframe] and we'll take another look.

Sid
```

## Success Metrics

**Good analysis:**
- ✅ Completed in 8-12 minutes
- ✅ Clear verdict with evidence
- ✅ Reply template ready to send
- ✅ Strategic context considered
- ✅ Learning documented if outcome known

**Great analysis:**
- ✅ Predicted scam correctly (saved money/time)
- ✅ Identified legitimate opportunity (captured value)
- ✅ Pattern documented for future (improved skill)
- ✅ Reply template effective (got desired response)

**The ultimate test:**
> "Would Sid trust this verdict without doing his own research?"

If yes, skill working. If no, improve protocol.

## When to Escalate

**Skip the skill, ask Sid directly if:**
- High-value opportunity (potential $100K+ impact)
- Complex partnership with multiple stakeholders
- Legal implications unclear
- Brand risk significant
- Time-sensitive decision (< 1 hour)

**For everything else:** Run the protocol, present verdict, Sid approves.

## Examples

See `examples/netty-awards-scam.md` for complete protocol execution showing:
- Triage → 85% scam probability
- Research → 95-100% confirmed scam (BBB listing)
- Strategic fit → Right audience, wrong method
- ROI → Negative infinity ($495-$5K for nothing)
- Verdict → IGNORE (but counter-intel chosen for learning)
- Reply template → Direct questions exposing scam

---

*"Skills = Crystallized expertise that auto-activates"*
*"The CREDITOR energy test never lies"*
