# ICP & Objection Mapping: Role-Play Before You Write

## The Exercise
Before writing ANY cold email campaign, spend 15 minutes role-playing as your skeptical ICP.
**Why:** You'll write defensively, focus on THEIR world, and understand what they ACTUALLY care about.

## Step 1: Put Yourself in Their Shoes
### Questions to Answer
1. **How are they doing this now?** (Current solution, daily routine)
2. **Why would they switch?** (What's broken, what's the "last straw")
3. **What's their switching cost?** (Time, money, political risk)
4. **What objections will they have?** (Budget, "we have X", "too busy")

## Step 2: Map Role → What They Actually Care About
**The Truth**: Unless they're the CEO, they want to:
1. Do their job well enough to avoid criticism.
2. Go home on time.
3. Look smart to their boss.

**Your job**: Connect your offer to THEIR personal wins.

### Mapping Template
```
Role: [e.g., VP Sales]
Responsible for: [KPIs]
Success looks like: [Promotions, praise]
Failure looks like: [Missing targets, burnout]
Current solution: [Manual process, annoying tools]
Our solution offers:
- Business win: [Company ROI]
- Personal win: [They look like a hero, less stress]
Top 3 objections:
1. [Objection] → Preempt by: [Response]
```

## Step 3: Preempt Objections in Your Email
### Technique 1: "Poke the Bear" Questions
Frame opener as a question acknowledging current state.
*Instead of:* "We help companies automate outbound"
*Try:* "Have you figured out how to scale outbound without adding headcount, or is that still manual?"

### Technique 2: Risk Reversal
"You only pay when it's successfully taken down" or "No upfront commitment".

### Technique 3: Situational Social Proof
*Instead of:* "We work with Stripe"
*Try:* "Most fintech teams hit this problem around month 3..."

### Technique 4: Personal Benefit
"Not only a big win for the company, but you'd personally benefit from [specific thing]."

## Step 4: Test Your Email Against the Map
1. Does it acknowledge their current state?
2. Does it address their #1 objection preemptively?
3. Does it offer a personal win?
4. Is the switching cost clear?
5. Would I reply to this if I were them?
