---
name: cold-outreach-generator
description: Generate cold email templates, LinkedIn messages, follow-up sequences, and value propositions tailored to specific industries that actually get responses and book discovery calls.
---

# Cold Outreach Message Generator

Get responses. Book calls. Win clients.

## What This Skill Does

Input: Target industry + your solution
Output: Cold email templates, LinkedIn messages, follow-up sequences

## Cold Email Formula (That Works)

**Subject:** [Specific Pain Point Question]
Example: "Managing 200+ inspections/month in Excel?"

**Body (5 sentences max):**

Sentence 1: Specific observation about their business
"I noticed [Company] handles fire inspections for commercial buildings in [City]."

Sentence 2: Common pain point
"Most inspection companies I work with struggle with [specific problem]."

Sentence 3: Brief solution hint
"I build custom software that [specific benefit]."

Sentence 4: Social proof
"Built similar system for [Company] - saved them 15 hours/week."

Sentence 5: Soft CTA
"Worth a 15-min call to see if this makes sense for you?"

**Signature**
[Your Name]
[Your Title]
[Calendar Link]

## LinkedIn Connection Message

"Hi [Name], I work with [industry] companies to solve [specific problem]. Thought it might be worth connecting."

**Follow-up after connection:**
"Thanks for connecting! I noticed [Company] does [their work]. Quick question - how do you currently handle [their pain point]? Most [industry] businesses I talk to struggle with that."

## Follow-Up Sequence

**Day 0:** Initial outreach
**Day 3:** "Hi [Name], following up on my note from Monday. Curious if [pain point] is something you're dealing with?"
**Day 7:** "Last note from me! If [problem] isn't a priority right now, no worries. But if it is, happy to show you what we built for [Similar Company]."

Stop after 3 touches. Don't be annoying.

## What Gets Responses

✅ **Specific:** "Managing HVAC service calls" not "running your business"
✅ **Relevant:** Mention their actual work
✅ **Brief:** 5 sentences max
✅ **Social proof:** Name similar companies you helped
✅ **Easy CTA:** Calendar link, not "let me know when you're free"

## What Kills Response Rates

❌ Generic: "I help businesses save time and money"
❌ Long: 3+ paragraphs
❌ Salesy: "Limited time offer! Act now!"
❌ Desperate: "Please respond!"
❌ Hard pitch: Pricing and features in first email

## Template Library

**Template #1: The Observation**
Subject: Saw you're hiring [role]

Body:
"Hi [Name], noticed you're hiring a [dispatcher/admin/etc]. 

That's usually a sign you're growing fast and current systems can't keep up.

I build software for [industry] that lets you grow without hiring more admin staff. Built similar system for [Company] - they handle 2x the volume with same team now.

Worth a quick call?"

---

**Template #2: The Problem**
Subject: [Pain point question]

Body:
"Hi [Name],

Quick question: How do you currently [painful process]?

Most [industry] companies waste 10-15 hours/week on this manually.

I build custom software that automates it. [Company] used to spend 15 hours/week, now it's automated.

15-min call to show you how it works?"

---

**Template #3: The Referral**
Subject: [Mutual connection] suggested I reach out

Body:
"Hi [Name],

[Mutual Connection] mentioned you might be interested in [solution to pain point].

I recently built [specific software] for [their competitor]. Saved them 20 hours/week and $80K/year.

Worth exploring if similar solution makes sense for [Their Company]?"

## Volume Strategy

**Outreach Math:**
- 100 cold emails sent
- 5-10% response rate = 5-10 responses
- 50% book calls = 2-5 discovery calls
- 40% convert = 1-2 new clients

**To get 1 client/month:** Send 20-25 outreach emails/week

## Remember

Cold outreach is a numbers game. Most won't respond. That's okay.

Focus on:
1. Specific, relevant messages
2. Volume (20-30/week consistently)
3. Follow-ups (3 touches max)
4. Easy CTA (calendar link)

Do this every week. You'll book calls. Calls turn into clients.
