---
name: commit-guide
description: コミットメッセージとPR作成のガイドライン
---

# コミット & PR 作成ガイド

## コミットメッセージ

### 形式

```
<prefix>: <簡潔な説明>

<詳細な説明（必要な場合）>
```

### プレフィックス一覧

| プレフィックス | 用途 |
|--------------|------|
| `feat` | 新機能の追加 |
| `fix` | バグ修正 |
| `docs` | ドキュメントのみの変更 |
| `style` | コードの意味に影響しない変更（空白、フォーマット等） |
| `refactor` | バグ修正でも機能追加でもないコード変更 |
| `perf` | パフォーマンス改善 |
| `test` | テストの追加・修正 |
| `chore` | ビルドプロセスやツールの変更 |

### 良いコミットメッセージの例

```
feat: 物件検索にフィルター機能を追加

- 家賃範囲でのフィルタリング
- 間取りでのフィルタリング
- 複数条件の AND 検索対応
```

### 悪いコミットメッセージの例

```
修正
update
fix bug
WIP
```

## プルリクエスト

### タイトル

コミットメッセージと同じプレフィックス形式を使用

### 本文テンプレート

```markdown
## 概要

この PR で何を実現するかを簡潔に説明

## 変更内容

- 変更点1
- 変更点2
- 変更点3

## スクリーンショット（UI変更がある場合）

（スクリーンショットを貼る）

## テスト

- [ ] 単体テストの追加/更新
- [ ] 手動での動作確認
- [ ] エッジケースの確認

## 関連 Issue

closes #xxx

## レビュワーへのメモ

特に確認してほしい点があれば記載
```

## 注意事項

- 1つのコミット/PRには1つの目的のみ
- 機密情報は絶対にコミットしない
- テストが通ることを確認してからコミット
