---
name: company-intelligence
description: Generates comprehensive company research reports for sales preparation. Use this skill when preparing for executive meetings, researching target accounts, creating account plans, or understanding competitive landscape.
---

# Company Intelligence

This skill creates comprehensive company intelligence reports that give sales professionals deep understanding of target accounts, enabling strategic conversations and informed deal pursuit.

## Objective

Gather, synthesize, and present actionable company intelligence that helps sales teams understand prospects' businesses, identify opportunities, and position solutions effectively.

## Research Report Structure

### 1. Company Overview
Brief description of the company's business model and offerings.

**What to Include:**
- What they do (core business)
- How they make money (business model)
- Who they serve (target market)
- What makes them different (value proposition)

### 2. Strategic Focus & Growth Initiatives
Key priorities, projects, and expansion areas.

**What to Include:**
- Announced strategic priorities
- Growth initiatives and investments
- New products or services launched
- Geographic or market expansion plans
- Technology or digital transformation projects

**Sources:**
- Earnings calls and investor presentations
- Press releases and announcements
- Leadership interviews
- Job postings indicating investment areas

### 3. Financial Performance
Revenue figures, growth metrics, and financial health (public companies).

**What to Include:**
- Revenue and growth rates
- Profitability metrics
- Key financial ratios
- Recent financial news
- Funding history (private companies)

**Note:** For private companies, focus on available signals like funding rounds, estimated revenue ranges, and growth indicators.

### 4. Digital Transformation & Innovation
Current technology initiatives and investments.

**What to Include:**
- Technology stack and platforms
- Digital transformation projects
- Innovation initiatives
- R&D investments
- Technology partnerships

### 5. Key Executives & Leadership
Profiles of decision-makers and organizational structure.

**What to Include:**
- C-suite and executive team
- Relevant department heads
- Recent leadership changes
- Board composition (if relevant)
- Decision-making structure

### 6. Employee Sentiment & Culture
Insights from review sites and public information.

**What to Include:**
- Glassdoor ratings and trends
- Common themes in reviews
- Company culture indicators
- Employee count and growth
- Notable hiring or layoff patterns

### 7. Partnerships & Ecosystem
Major collaborations and marketplace presence.

**What to Include:**
- Strategic partnerships
- Technology integrations
- Channel partners and resellers
- Supplier relationships
- Industry associations

### 8. Drivers, Objectives & Challenges
External pressures, internal goals, and obstacles.

**What to Include:**
- Market drivers affecting their business
- Stated business objectives
- Known challenges or pain points
- Competitive pressures
- Regulatory or compliance factors

### 9. Value Propositions
How the company creates and delivers value.

**What to Include:**
- Customer value proposition
- Competitive differentiators
- Brand positioning
- Customer success stories

### 10. Competitors
Direct and indirect rivals.

**What to Include:**
- Primary competitors
- Competitive positioning
- Market share context
- Recent competitive moves

### 11. Customers & Verticals
Industry verticals and use cases they serve.

**What to Include:**
- Target customer segments
- Key industry verticals
- Notable customers (if public)
- Use cases they promote

## Research Sources

### Primary Sources (Most Reliable)
- Company website (About, Newsroom, Investor Relations)
- SEC filings (10-K, 10-Q, 8-K for public companies)
- Official press releases
- Leadership quotes and interviews

### Secondary Sources (Verify When Possible)
- Industry publications and analyst reports
- News articles from reputable sources
- Conference presentations
- Podcast appearances

### Intelligence Sources
- Job postings (growth areas, technology stack)
- Glassdoor/LinkedIn (culture, employee sentiment)
- Technology databases (BuiltWith, Wappalyzer)
- Funding databases (Crunchbase, PitchBook)

## Report Quality Standards

### Accuracy Requirements
- Include ONLY factual, verifiable information
- NEVER fabricate names, numbers, or dates
- For private companies, don't claim to know undisclosed revenue
- Cite sources for major data points
- Flag uncertain information with confidence ratings

### Currency Requirements
- Prioritize information from current year
- Note when information may be outdated
- Highlight recent developments
- Update reports regularly for active deals

### Relevance Requirements
- Focus on information relevant to your sales motion
- Highlight alignment with your solution
- Note potential trigger events
- Identify decision-maker priorities

## Output Format

When creating a company intelligence report, produce:

### Executive Summary (1 paragraph)
Quick overview of the company and key insights for sales

### Full Research Report
All 11 sections with relevant findings

### Sales Relevance Section
- **Alignment**: How your solution fits their priorities
- **Trigger Events**: Recent changes creating urgency
- **Entry Points**: Best angles for initial conversations
- **Potential Champions**: Likely internal advocates
- **Risks**: Factors that could block a deal

### Source Appendix
Citations for all major claims and data points

## Available Tools

When enabled, these MCP tools enhance research capabilities:

| Tool | What It Does | How to Use |
|------|-------------|------------|
| **Perplexity** | AI-powered web search with citations | "Use Perplexity to research [company]'s recent news" |
| **Exa** | Semantic search for companies | "Search Exa for [company] leadership changes" |
| **Apify** | Web scraping for structured data | "Use Apify to scrape [company]'s careers page" |

**Note:** Tools must be enabled in `.mcp.json` and API keys configured. See README for setup instructions.

### Tool Usage Examples

```
"Use Perplexity to find recent funding announcements for Acme Corp"
"Search Exa for news about Acme Corp's digital transformation initiatives"
"Use Apify to extract job postings from Acme Corp's careers page"
```

## Cross-References

- Use to inform `account-qualification` tier assignment
- Feed insights into `prospect-research` for stakeholder context
- Guide `cold-call-scripts` value proposition positioning
- Inform `multithread-outreach` messaging strategy
- Update `powerful-framework` with organizational insights
