---
name: content-atomizer
description: "Transform one piece of content into platform-optimized assets across LinkedIn, Twitter/X, Instagram, TikTok, and YouTube. Use when someone has existing content (blog post, newsletter, podcast, video) and wants to maximize distribution. Covers format specs, hook formulas, algorithm signals, and creator-tested patterns for each platform. Triggers on: repurpose this, turn this into social posts, atomize this content, create social content from, LinkedIn post from this, thread from this. Outputs platform-specific content ready to publish."
---

# Content Atomizer Skill

One piece of content should become ten. The best creators don't create more—they distribute better.

This skill transforms any source content into platform-optimized assets. Not generic repurposing. Platform-native content that performs.

**The math:** A single blog post can become 1 LinkedIn carousel + 2 LinkedIn text posts + 1 Twitter thread + 3 single tweets + 2 Instagram carousels + 1 Reel script + 2 TikTok scripts + 1 YouTube Short script = 13 pieces of content from one source.

---

## The Core Job

Transform source content into **platform-native assets** that:
- Match each platform's algorithm signals
- Use format-specific best practices
- Include hooks proven to stop the scroll
- Feel native, not repurposed

---

## Input Types

### What Can Be Atomized

| Source Type | Best Outputs | Atomization Potential |
|-------------|--------------|----------------------|
| **Blog Post** | All platforms | High (lots of material) |
| **Newsletter** | LinkedIn, Twitter, Instagram | High |
| **Podcast Episode** | Short-form video, threads, carousels | Very High |
| **Long-form Video** | Shorts, Reels, TikToks, carousels | Very High |
| **Webinar/Talk** | All platforms | Very High |
| **Case Study** | LinkedIn, Twitter threads | High |
| **Data/Research** | Carousels, threads, single posts | Medium-High |
| **Framework/Process** | Carousels, threads, video scripts | High |

### What to Extract

From any source, identify:

1. **The Core Insight** — The one thing someone should remember
2. **Supporting Points** — 3-7 sub-points that build the argument
3. **Stories/Examples** — Concrete illustrations
4. **Data Points** — Stats, numbers, proof
5. **Contrarian Takes** — Opinions that challenge conventional wisdom
6. **Actionable Steps** — What someone can do with this
7. **Quotable Lines** — Punchy phrases that stand alone

---

## Platform Playbooks

### LinkedIn

**Algorithm Signals (December 2025):**
- **Dwell time** — How long people spend reading (still #1)
- **Topic authority** — Consistent niche posting builds algorithmic trust
- **Golden hour** — First 60 minutes determines reach to 2nd/3rd-degree connections
- **Relevance over recency** — Mid-2025 update shows older posts (2-3 weeks) if highly relevant
- **Authentic engagement** — AI detects engagement pods via comment velocity and patterns
- **Native content** — Posts without links get significantly more reach

**2025 Reality Check:** Organic views down ~50%, engagement down ~25% as LinkedIn prioritizes quality over quantity. Post 2-3x/week max, not daily.

**Optimal Specs:**

| Format | Specs | Notes |
|--------|-------|-------|
| Carousel | 5-10 slides, 1080x1350px | Highest dwell time, save-worthy |
| Text Post | 1,200-1,500 chars, 3-line hook | Depth over frequency |
| Document | PDF, 10-15 pages max | Good for frameworks |
| Video | 30-90 seconds, captions required | Lower reach than text/carousels |

#### LinkedIn Carousel Template

**Slide 1: Hook Slide**
```
[BOLD CLAIM OR QUESTION]

(That challenges what they think they know)

Swipe → to learn [specific outcome]
```

**Slide 2-6: Content Slides**
```
[NUMBER]. [POINT HEADLINE]

[2-3 sentences of explanation]

[Visual element or example if possible]
```

**Slide 7: Summary Slide**
```
Quick recap:

1. [Point 1 - 5 words max]
2. [Point 2 - 5 words max]
3. [Point 3 - 5 words max]
4. [Point 4 - 5 words max]
5. [Point 5 - 5 words max]
```

**Final Slide: CTA Slide**
```
Found this useful?

→ Follow for more [topic]
→ Repost to help others
→ Save for later

[Your name/handle]
```

#### LinkedIn Text Post Template

```
[HOOK - First line must stop the scroll]

[Line break]

[CONTEXT - Why this matters, 2-3 lines]

[Line break]

Here's what I learned:

[Line break]

1. [Point with brief explanation]

2. [Point with brief explanation]

3. [Point with brief explanation]

4. [Point with brief explanation]

5. [Point with brief explanation]

[Line break]

[TAKEAWAY - The "so what"]

[Line break]

[CTA - Question or action]

---

[Hashtags - 3-5 max, at the bottom]
```

#### LinkedIn Hook Formulas

**Pattern 1: Contrarian Statement**
> "Stop [thing everyone does]. It's killing your [result]."

**Pattern 2: Story Hook**
> "Last week, I [did something]. What happened next changed how I think about [topic]."

**Pattern 3: List Preview**
> "[Number] [things] that [outcome]. (Number [X] is the one no one talks about.)"

**Pattern 4: Credibility + Insight**
> "After [impressive stat/experience], here's what I know for sure about [topic]:"

**Pattern 5: Question Hook**
> "Why do [surprising thing happen]? I finally figured it out."

**Pattern 6: Bold Claim**
> "[Counterintuitive claim]. Here's the proof:"

---

### Twitter/X

**Algorithm Signals (December 2025):**
- **Replies** — Highest weight, especially from accounts you engage with
- **Quote tweets** — 2x engagement value vs plain retweet
- **Time spent** — On tweet and clicked links
- **Profile clicks** — Curiosity driven by tweet
- **Media boost** — Images/videos/GIFs increase visibility scores
- **Early engagement** — First hours critical for amplification

**2025 Changes:** Following feed now uses **Grok AI** for ranking (based on past interactions and topics)—no longer purely chronological. Users default to For You feed.

**Optimal Specs:**

| Format | Specs | Performance |
|--------|-------|-------------|
| Single Tweet | <100 characters optimal | Highest engagement rate |
| Thread | 8-15 tweets | Best for depth + followers |
| Quote Tweet | Add value to original | 2x engagement vs retweet |
| Image Tweet | 1200x675px | 35% more engagement |

#### Twitter Thread Template

**Tweet 1: Hook Tweet**
```
[BOLD CLAIM OR PROMISE]

[What they'll learn in one line]

🧵 Thread:
```

**Tweets 2-X: Content Tweets**
```
[NUMBER]. [POINT]

[2-3 sentences of explanation]

[Example or proof if fits]
```

**Final Tweet: Wrap + CTA**
```
TL;DR:

• [Point 1]
• [Point 2]
• [Point 3]
• [Point 4]
• [Point 5]

If this was useful:
1. Follow @[handle] for more
2. RT the first tweet

[Link if relevant]
```

#### Single Tweet Templates

**The Insight Tweet:**
```
[Counterintuitive observation about industry/topic]

Most people think [X].

But [Y] is actually true because [Z].
```

**The List Tweet:**
```
[Number] [things] that [outcome]:

• [Item 1]
• [Item 2]
• [Item 3]
• [Item 4]
• [Item 5]

Which one hits different?
```

**The Hot Take:**
```
Unpopular opinion:

[Contrarian statement]

Here's why: [One-line reasoning]
```

**The Question Tweet:**
```
[Provocative question about industry/topic]?

Genuine question. Reply with your take.
```

**The Proof Tweet:**
```
[Impressive result/stat]

Here's exactly how:

[3-5 bullet points of method]
```

#### Twitter Hook Formulas

**Pattern 1: Bold Opener**
> "[Thing] is dead. Here's what's replacing it:"

**Pattern 2: Numbers + Outcome**
> "I [did X] for [time period]. Here's what happened:"

**Pattern 3: Controversial Take**
> "This will piss off [group], but [claim]."

**Pattern 4: Curiosity Gap**
> "The [industry] secret no one talks about:"

**Pattern 5: Specific Proof**
> "[Specific result] in [timeframe]. No [common excuse]. Here's the playbook:"

---

### Instagram

**Algorithm Signals (December 2025):**
- **DM shares ("sends per reach")** — Now one of the STRONGEST discovery signals
- **Saves** — Still critical for Feed and Explore
- **Watch time & retention** — For Reels, completion rate is king
- **Likes per reach** — Quality signal (not raw likes)
- **Early velocity** — First 30-90 minutes determines push to wider audience
- **Relationship signals** — DMs, profile taps, comment history with account

**2025 Changes:** Photos getting more support in Feed again (Adam Mosseri). Carousels expanded to 20 slides in some regions. Hashtag weighting significantly reduced. New "Your Algorithm" feature lets users see why they're seeing content.

**Optimal Specs:**

| Format | Specs | Performance |
|--------|-------|-------------|
| Carousel | 6-10 slides (up to 20), 1080x1350px | Highest engagement, save-worthy |
| Reel | 7-15 sec (viral), 30-45 sec (tutorials) | Best for discovery/reach |
| Single Image | 1080x1350px | Getting more support in 2025 |
| Story | 1080x1920px, <15 sec | Best for DM engagement |

#### Instagram Carousel Template

**Slide 1: Cover (The Hook)**
```
[BOLD STATEMENT OR QUESTION]

in [large, readable font]

[Minimal design, high contrast]
```

**Slide 2: The Problem/Setup**
```
[Why this matters]

or

[What most people get wrong]
```

**Slides 3-8: The Content**
```
[ONE point per slide]

[Large text, minimal words]

[Visual hierarchy: headline + 1-2 supporting lines]
```

**Slide 9: Summary (Optional)**
```
Quick recap:

✓ [Point 1]
✓ [Point 2]
✓ [Point 3]
✓ [Point 4]
✓ [Point 5]
```

**Slide 10: CTA**
```
Save this for later 📌

Follow @[handle] for more

Share with someone who needs this
```

#### Instagram Caption Template

```
[HOOK - First line must work in preview]

.
.
.

[BODY - The value/story/insight]

[2-4 paragraphs max]

[Each paragraph 2-3 sentences]

---

💾 Save this for later
📤 Share with a friend who needs it
💬 Drop a [emoji] if this resonated

---

#[niche hashtag] #[broader hashtag] #[topic hashtag]
```

#### Instagram Reel Script Template (15-30 seconds)

```
[SECONDS 0-3: HOOK]
"[Pattern interrupt or bold claim that stops scroll]"

[SECONDS 3-20: VALUE]
"Here's [what/why/how]:
Point one: [brief]
Point two: [brief]
Point three: [brief]"

[SECONDS 20-30: CTA]
"Follow for more [topic]"
OR
"Save this for later"
OR
"Send to someone who needs this"
```

#### Instagram Story Sequence Template

**Story 1: Hook**
```
[Poll or question sticker]

"Quick question..."
[Poll: Option A / Option B]
```

**Story 2: Setup**
```
"Here's why I ask..."

[Brief context]
```

**Story 3-5: Value**
```
[One point per story]

[Use text animation or stickers for engagement]
```

**Story 6: CTA**
```
"Want the full breakdown?"

[Link sticker to content]

OR

"DM me [word] for [resource]"
```

---

### TikTok

**Algorithm Signals (December 2025):**
- **Watch time (first seconds)** — Completion rate still #1, but early seconds weighted heavily
- **Rewatch rate** — Multiple views = strong signal
- **Shares** — Especially to DMs
- **Niche community alignment** — 2025 favors specialized audiences over broad virality
- **Contextual categorization** — AI distinguishes humor, education, emotion to match interests
- **Video quality** — Lighting, sound, editing now integrated into ranking

**2025 Changes:** Algorithm now favors **longer content (30-60+ seconds) if retention is high**. Niche communities (#BookTok, etc.) get boosted over generic viral attempts. Deeper AI personalization analyzes watch duration, replays, and cross-platform habits.

**Optimal Specs:**

| Format | Specs | Performance |
|--------|-------|-------------|
| Short-form | 15-30 seconds | Highest completion rate |
| Medium | 30-60 seconds | Now favored if retention is strong |
| Long-form | 1-3 minutes | Good for depth with engaged audiences |
| Vertical | 1080x1920px (9:16) | Required |

#### TikTok Script Template (15-30 seconds)

```
[HOOK - 0-3 seconds]
"[Visual hook + verbal hook simultaneously]"

Options:
- "Stop scrolling if you [identifier]"
- "POV: You just realized [insight]"
- "The [industry] secret no one tells you:"
- "[Controversial statement]—let me explain"
- "I'm about to save you [time/money/pain]"

[BODY - 3-25 seconds]
"Here's the thing:

[Point 1 - delivered fast]

[Point 2 - keep momentum]

[Point 3 - the payoff]"

[CTA - 25-30 seconds]
"Follow for more [topic]"
OR
"Part 2?" [to boost comments]
OR
"Save this" [drives saves]
```

#### TikTok Hook Formulas

**Pattern 1: Pattern Interrupt**
> "[Unexpected visual or statement that breaks scroll pattern]"

**Pattern 2: Identity Call-Out**
> "This is for my [specific group] who [specific situation]"

**Pattern 3: Proof First**
> "[Show the result immediately, then explain how]"

**Pattern 4: Controversy Spark**
> "I'm going to get hate for this but [take]"

**Pattern 5: Curiosity Gap**
> "I can't believe [industry/brand] doesn't want you to know this"

**Pattern 6: Tutorial Promise**
> "In 30 seconds I'll show you how to [specific outcome]"

#### TikTok Content Patterns That Work

1. **Before/After** — Show transformation immediately
2. **Green Screen** — You + content behind you (tweets, articles, data)
3. **Stitch/Duet** — React to trending content in your niche
4. **Day in the Life** — Niche-specific (day in the life of a marketer, etc.)
5. **POV** — "POV: You're [scenario]" with relatable insight
6. **Listicle** — "3 things [outcome]" with fast delivery
7. **Myth Busting** — "Stop believing [common misconception]"

---

### YouTube

**Algorithm Signals (December 2025):**
- **Click-through rate (CTR)** — How often people click when shown your video
- **Average view duration & % watched** — Raw watch time AND completion percentage
- **Session impact** — Does your video keep people on YouTube longer?
- **Viewer satisfaction** — YouTube now uses surveys + behavior to estimate quality
- **Negative feedback** — "Not interested," skips, very low retention hurt you
- **Topical authority** — Channels focused on clear topics get recommended more

**2025 Changes:** AI-driven hyper-personalization (device, time of day, habits). Older evergreen videos get revived when topics trend again. Stronger emphasis on authority, depth, and "entity-rich" content (aligned with Google Search updates).

**Optimal Specs:**

| Format | Specs | Performance |
|--------|-------|-------------|
| Shorts | 10-35 sec (discovery), up to 60 sec | Highest reach, lower depth |
| Long-form | 8-12 minutes (sweet spot) | Best for monetization + depth |
| Thumbnail | 1280x720px | CTR target: 4-10% (Home), 6-12% strong |

#### YouTube Shorts Script Template

```
[HOOK - 0-2 seconds]
"[Immediate value promise or pattern interrupt]"

Examples:
- "Here's why [common belief] is wrong"
- "[Number] second [topic] lesson"
- "The [industry] hack that changed everything"

[BODY - 2-50 seconds]
[Deliver value fast]

[Each point: 5-10 seconds max]

[Keep visual movement—don't stand still]

[CTA - 50-60 seconds]
"Subscribe for more [topic]"
OR
"Full video on my channel"
OR
End abruptly (drives rewatch for missed content)
```

#### YouTube Long-Form Framework (HIVES)

**H - Hook (0-30 seconds)**
```
[Pattern interrupt or bold claim]
[Quick credibility if needed]
[Preview of what they'll learn]
"By the end of this video, you'll know exactly how to [outcome]"
```

**I - Intro (30 seconds - 1 minute)**
```
[Brief context on why this matters]
[Who this is for]
[What you'll cover]
"Let's dive in"
```

**V - Value (Main content)**
```
[Deliver on the promise]
[Clear sections with verbal signposting]
"First... Second... Third..."
[Examples and proof for each point]
```

**E - Engagement Prompts (Throughout)**
```
[Every 2-3 minutes, insert:]
"Let me know in the comments if [question]"
"Hit like if [relatable statement]"
"If you're finding this useful, subscribe"
```

**S - Strong CTA (Final 30 seconds)**
```
[Summarize key points]
[Clear next action]
"If you want to go deeper on [topic], watch this video next"
[End screen with subscribe + related video]
```

#### YouTube Thumbnail + Title Patterns

**Thumbnail Principles:**
- 3 elements max (face, text, object)
- High contrast colors
- Readable at small size
- Emotion on face (if showing face)
- Curiosity gap (show outcome, not process)

**Title Formulas:**

| Pattern | Example |
|---------|---------|
| How I [result] | "How I Built a 6-Figure Newsletter in 8 Months" |
| [Number] [Things] That [Outcome] | "7 LinkedIn Mistakes Killing Your Reach" |
| Why [Thing] Doesn't Work | "Why Your Content Strategy Isn't Working" |
| The [Adjective] [Thing] | "The Boring Marketing Strategy That Actually Works" |
| I [Did X] For [Time]. Here's What Happened | "I Posted Daily for 90 Days. Here's What Happened" |
| [Year] Guide to [Topic] | "2024 Guide to Growing on LinkedIn" |
| [Thing] vs [Thing] | "Threads vs Twitter: Which One Should You Use?" |

---

## The Atomization Workflow

### Step 1: Extract

From your source content, pull out:

```
CORE INSIGHT:
[One sentence that captures the main point]

SUPPORTING POINTS:
1. [Point + brief explanation]
2. [Point + brief explanation]
3. [Point + brief explanation]
4. [Point + brief explanation]
5. [Point + brief explanation]

STORIES/EXAMPLES:
- [Story 1]
- [Story 2]

DATA/PROOF:
- [Stat 1]
- [Stat 2]

QUOTABLE LINES:
- "[Quote 1]"
- "[Quote 2]"

CONTRARIAN TAKES:
- [Take 1]
- [Take 2]
```

### Step 2: Map to Platforms

| Content Element | Best Platforms | Best Formats |
|-----------------|----------------|--------------|
| Core insight | All | Single posts, hooks |
| Supporting points (together) | LinkedIn, Twitter | Carousel, thread |
| Individual points | All | Single posts |
| Stories | Instagram, TikTok | Reels, Stories |
| Data points | LinkedIn, Twitter | Image posts, carousels |
| Quotable lines | Twitter, Instagram | Quote graphics |
| Contrarian takes | Twitter, TikTok | Single tweets, video hooks |

### Step 3: Transform

For each platform, apply:

1. **Format** — Use the templates above
2. **Hook** — Platform-specific hook formula
3. **Length** — Match platform norms
4. **CTA** — Platform-appropriate action
5. **Voice** — Adjust formality (LinkedIn > Instagram > TikTok)

### Step 4: Sequence

**Optimal posting sequence:**

1. **LinkedIn carousel** — Day 1 (longest shelf life)
2. **Twitter thread** — Day 1-2 (good for discussion)
3. **Instagram carousel** — Day 2-3 (repurpose LinkedIn design)
4. **TikTok/Reel** — Day 3-4 (needs video production)
5. **YouTube Short** — Day 4-5 (can repurpose TikTok)
6. **Single posts** — Ongoing (extract individual points)

---

## Anti-Patterns: What Not to Do

### Don't:

1. **Copy-paste across platforms**
   - Each platform has different norms
   - Cross-posted content performs 40-60% worse

2. **Use the same hook everywhere**
   - LinkedIn hooks ≠ TikTok hooks
   - Adjust energy and format per platform

3. **Ignore platform-native features**
   - No hashtags on LinkedIn carousels
   - Always use captions on video
   - Instagram needs visual-first thinking

4. **Post everything at once**
   - Stagger across days/weeks
   - Gives each piece room to perform

5. **Forget the CTA**
   - Every platform piece needs a clear next action
   - But make it platform-appropriate

### Do:

1. **Lead with the best hook per platform**
2. **Adapt length to platform norms**
3. **Use native formatting (threads, carousels, etc.)**
4. **Front-load value (especially for video)**
5. **Create platform-specific visuals when possible**

---

## Transformation Examples

### Example: Blog Post → Multi-Platform

**Source:** 2,000-word blog post on "5 Pricing Mistakes That Kill SaaS Growth"

**Atomization:**

| Platform | Format | Content |
|----------|--------|---------|
| LinkedIn | Carousel | 8 slides: Hook + 5 mistakes + recap + CTA |
| LinkedIn | Text Post | Deep dive on mistake #1 with personal story |
| Twitter | Thread | 7 tweets: Hook + 5 mistakes + wrap |
| Twitter | Single | Just mistake #3 (most contrarian) as hot take |
| Instagram | Carousel | Visual version of LinkedIn carousel |
| Instagram | Reel | 30-sec: "Stop making these pricing mistakes" |
| TikTok | Video | 20-sec: Most controversial mistake, hot take style |
| YouTube Short | Video | 45-sec: All 5 mistakes, rapid fire |

### Example: Podcast Episode → Multi-Platform

**Source:** 45-minute podcast interview with actionable insights

**Atomization:**

| Platform | Format | Content |
|----------|--------|---------|
| LinkedIn | Text Post | Best quote + context + your take |
| LinkedIn | Carousel | Key framework from interview |
| Twitter | Thread | 10 best insights from the episode |
| Twitter | Single | Best quote as standalone insight |
| Instagram | Carousel | Visual quotes from guest |
| Instagram | Reel | Best 30-second clip with captions |
| TikTok | Video | Spiciest take from interview |
| YouTube Short | Video | Best insight with visual hook |
| YouTube | Long-form | Full episode or highlights compilation |

---

## Platform Voice Adjustments

The same insight needs different energy per platform:

| Platform | Voice | Example (same insight) |
|----------|-------|----------------------|
| LinkedIn | Professional, thoughtful | "After 10 years in marketing, I've learned that simplicity beats complexity. Here's why:" |
| Twitter | Punchy, direct | "Hot take: Simple marketing > 'sophisticated' marketing. Every time." |
| Instagram | Visual, inspirational | [Image with text: "Simple > Sophisticated" + story in caption] |
| TikTok | Casual, energetic | "Y'all I need to talk about why everyone's overcomplicating their marketing..." |
| YouTube | Conversational, thorough | "If you've been in marketing for any length of time, you've probably noticed something..." |

---

## Quick Reference: Platform Specs (December 2025)

| Platform | Optimal Length | Best Format | Hook Window | Top Signal |
|----------|---------------|-------------|-------------|------------|
| LinkedIn | 1,200-1,500 chars | Carousel | First 3 lines | Dwell time + topic authority |
| Twitter/X | <100 chars (single) | Thread (8-15) | First tweet | Replies + early engagement |
| Instagram | 6-10 slides | Carousel | First slide | DM shares ("sends per reach") |
| TikTok | 30-60 seconds (if retention high) | Short video | First 3 seconds | Completion + niche alignment |
| YouTube (Shorts) | 10-35 seconds | Vertical video | First 2 seconds | Completion rate |
| YouTube (Long) | 8-12 minutes | Horizontal | First 30 seconds | Satisfaction + session time |

---

## The Test

Good atomization means:

1. **Each piece stands alone** — Makes sense without the source
2. **Each piece feels native** — Doesn't feel "repurposed"
3. **Hooks match the platform** — Right energy, right format
4. **Value is front-loaded** — Best stuff first
5. **CTAs are appropriate** — Platform-native actions
6. **Quality over quantity** — 5 great pieces > 15 mediocre ones

---

## How This Connects to Other Skills

**Input from:**
- **seo-content** → Blog posts to atomize
- **newsletter** → Newsletter editions to atomize
- **direct-response-copy** → Landing page insights to distribute
- **brand-voice** → Ensures consistent voice across platforms

**The flow:**
1. Create source content (blog, newsletter, video)
2. **content-atomizer transforms into platform pieces**
3. Each piece drives back to source or offer
4. Repeat with next piece of source content
