# Platform Playbook: Deep Reference

Detailed breakdowns, creator examples, and tested patterns for each platform. Study these to understand what actually works.

---

## LinkedIn Deep Dive

### The Algorithm (December 2025)

LinkedIn uses a **three-step process**: quality filtering (spam/low/high classification), engagement testing (initial audience sample in first hour), and network/relevance ranking based on user interests and poster expertise.

**Priority signals:**

1. **Dwell Time** — How long someone spends reading your post (still #1)
2. **Topic Authority** — Consistent niche posting builds algorithmic trust over time
3. **Authentic Engagement** — AI detects engagement pods via comment velocity, patterns, and semantics
4. **Relevance Over Recency** — Mid-2025 update shows older posts (2-3 weeks) if highly relevant to user
5. **Native Content** — Posts without external links get significantly more reach

**The Golden Hour:** First 60 minutes determines whether your post reaches 2nd/3rd-degree connections. Strong early engagement = exponential reach.

**2025 Reality:** Organic views down ~50%, engagement down ~25%, follower growth down ~59% as LinkedIn prioritizes quality, relevance, and authentic expertise over volume.

### Carousel Mechanics

**Why carousels work:**
- Force longer dwell time (each swipe = more time on post)
- Educational content performs best on LinkedIn
- Save-worthy = algorithm gold
- Can be repurposed to Instagram with minor tweaks

**Optimal carousel structure:**

| Slide | Purpose | Design Notes |
|-------|---------|--------------|
| 1 | Hook | Bold text, minimal design, creates curiosity |
| 2 | Setup | Why this matters or what's wrong |
| 3-7 | Content | One point per slide, readable at small size |
| 8 | Summary | Quick reference version |
| 9 | CTA | Save, follow, repost |

**Design specs:**
- 1080x1350px (4:5 ratio) — Takes up maximum feed space
- Max 10 slides per carousel
- Font size: Minimum 24pt for body, 40pt+ for headlines
- High contrast (dark text on light, or vice versa)
- Consistent design system across slides

### Top LinkedIn Creators to Study

**Justin Welsh** (@justinwelsh)
- Format: Text posts, carousels, simple wisdom
- Hook style: Personal observation → lesson
- Example: "I've made $5M as a solopreneur. Here's what most people get wrong about building online..."
- What to learn: Consistency, simple formats, credibility stacking

**Sahil Bloom** (@sahaborting)
- Format: Frameworks, life lessons, carousels
- Hook style: Philosophical observation → framework
- Example: "The most successful people I know all share one trait..."
- What to learn: Framework creation, reflection prompts

**Lara Acosta** (@laraacosta)
- Format: Carousels, text posts on personal branding
- Hook style: Contrarian take → proof
- Example: "Stop posting 'value content' on LinkedIn. Here's why..."
- What to learn: Visual carousel design, contrarian positioning

**Jasmin Alic** (@jasmin-alic)
- Format: Text posts with strong opinions
- Hook style: Bold claim → breakdown
- Example: "LinkedIn is not dying. Your content is."
- What to learn: Direct hooks, opinion-led content

### LinkedIn Hook Examples (Tested)

**Hooks that drove 1M+ impressions:**

> "I spent 10 years building the wrong career. Here's what I wish I knew at 25:"

> "The lie about 'working hard' that nobody talks about:"

> "I've reviewed 500+ LinkedIn profiles this year. The same 5 mistakes keep appearing:"

> "Unpopular opinion: Your morning routine doesn't matter. Here's what does:"

> "I made $0 for 2 years. Then everything changed. Here's the shift:"

**Hook structures:**

1. **Personal failure → lesson**
   > "I got fired in 2019. Best thing that ever happened. Here's why:"

2. **Contrarian + proof**
   > "I stopped [common practice]. Results: [outcome]. Here's what I do instead:"

3. **Credibility + insight**
   > "After [impressive stat], I've noticed the top [role] all do this:"

4. **Bold prediction**
   > "[Industry] is about to change forever. Here's what's coming:"

5. **Question + promise**
   > "Why do some [roles] grow fast while others stay stuck? I finally figured it out:"

---

## Twitter/X Deep Dive

### The Algorithm (December 2025)

X prioritizes content in the **For You** feed based on recency, engagement, relevance, media, account credibility, and diversity.

**Priority signals:**

1. **Replies** — Highest weight, especially from accounts you engage with
2. **Quote Tweets** — 2x engagement value vs plain retweet
3. **Time Spent** — On tweet and on clicked links
4. **Media Boost** — Images/videos/GIFs increase visibility scores
5. **Profile Clicks** — Curiosity driven by tweet

**2025 Changes Under Elon Musk:**
- **Following feed now uses Grok AI** for ranking (based on past interactions and topics)—no longer purely chronological
- Users default to **For You** feed, not Following
- Stronger push on early engagement amplification and trending/local signals

**Thread mechanics:**
- First tweet determines 90% of thread success
- Optimal thread length: 8-15 tweets
- Add value in every tweet (no filler)
- Media per tweet boosts engagement
- Early engagement (first hours) critical for amplification

### Thread Architecture

**Tweet 1: The Hook**
```
[Bold claim or promise]

[One-line elaboration]

🧵 A thread on [topic]:
```

**Tweet 2: The Setup**
```
First, some context:

[Why this matters]
[Who needs to hear this]
```

**Tweets 3-X: The Content**
```
[Number]. [Point headline]

[2-3 lines of explanation]

[Example or proof]
```

**Tweet X-1: The Summary**
```
TL;DR:

• [Point 1]
• [Point 2]
• [Point 3]
• [Point 4]
• [Point 5]
```

**Tweet X: The CTA**
```
If this was useful:

1. Follow @[handle] for more
2. Retweet the first tweet
3. [Specific action related to content]

[Link if relevant]
```

### Top Twitter Creators to Study

**Dickie Bush** (@dickiebush)
- Format: Threads on writing, solo business
- Hook style: Numbered list promise
- Example: "I've written 600+ threads. Here are 10 lessons I learned the hard way:"
- What to learn: Thread structure, CTA placement

**Shaan Puri** (@shaanvp)
- Format: Single tweets, threads on business ideas
- Hook style: Observation → insight
- Example: "Most people think they need more traffic. What they actually need:"
- What to learn: Punchy single tweets, idea density

**Sahil Lavingia** (@shl)
- Format: Minimalist wisdom, founder insights
- Hook style: Short, declarative statements
- Example: "The best companies have the simplest strategies."
- What to learn: Brevity, conviction

**Alex Hormozi** (@hormozi)
- Format: Business wisdom, contrarian takes
- Hook style: Bold claim + proof
- Example: "Rich people don't budget. Here's what they do instead:"
- What to learn: High conviction, no hedging

### Twitter Hook Examples (Tested)

**Single tweets that drove 10K+ engagement:**

> "The best marketing doesn't feel like marketing."

> "Stop trying to go viral. Start trying to be useful."

> "Your competition isn't other companies. It's obscurity."

> "Most 'overnight successes' took 5+ years. They just didn't document year 1-4."

> "The person who reads one book on a topic knows more than 95% of people."

**Thread hooks that drove massive engagement:**

> "I've spent $50M on ads. Here's what I'd do differently:"

> "10 businesses you can start with $0:"

> "The psychology behind viral content (based on 500+ examples):"

> "I went from $0 to $1M in 18 months. Here's exactly what I did:"

---

## Instagram Deep Dive

### The Algorithm (December 2025)

Instagram uses **multiple ranking systems** for Feed, Reels, Stories, and Explore—each weighing signals differently.

**Priority signals:**

1. **DM Shares ("Sends Per Reach")** — Now one of the STRONGEST discovery signals, especially for Reels and Explore
2. **Saves** — Still critical for Feed and Explore; indicates long-term value
3. **Watch Time & Retention** — For Reels, completion rate is king
4. **Likes Per Reach** — Quality signal (not raw likes)
5. **Relationship Signals** — DMs, profile taps, comment history strengthen your visibility to those users
6. **Early Velocity** — First 30-90 minutes determines push to wider audience

**2025 Changes:**
- **Photos getting more support in Feed** (Adam Mosseri statement)—rebalancing, not abandoning video
- **Carousels expanded to 20 slides** in some regions
- **Hashtag weighting significantly reduced**—content signals matter more than tags
- New **"Your Algorithm" feature** lets users see why they're seeing content and remove interests

**Reels vs. Carousels:**
- Reels: Best for discovery and new eyeballs (7-15 sec for viral, 30-45 sec for tutorials)
- Carousels: Highest engagement, best for saves and depth (6-10 slides sweet spot)
- Photos: Getting renewed support in 2025, especially for photo-native audiences

### Carousel Deep Dive

**Why carousels dominate:**
- Each swipe = more time on post = algorithmic boost
- Swipe-through rate signals interest
- Save-worthy format for educational content
- Can tell a story across slides

**Slide-by-slide breakdown:**

| Slide | Goal | Design Principle |
|-------|------|------------------|
| 1 | Stop scroll | Bold text, curiosity, minimal elements |
| 2 | Hook deeper | "Here's the problem" or "Most people think" |
| 3-7 | Deliver value | One point per slide, readable, visual |
| 8-9 | Recap | Summary for those who swiped fast |
| 10 | Convert | Save, follow, share CTA |

### Reel Mechanics

**The 3-second rule:**
- 65% of viewers decide to keep watching or scroll in first 3 seconds
- Front-load the hook visually AND verbally
- Start mid-action, not with intro

**Optimal Reel lengths:**
- 7-15 seconds: Highest completion rate
- 15-30 seconds: Good for tutorials
- 30-60 seconds: Acceptable if value is dense
- 60-90 seconds: Only for highly engaged audiences

**Reel patterns that work:**

1. **Talking head + text overlay**
   - You speaking + key points as text
   - Best for thought leadership

2. **Before/After**
   - Show transformation immediately
   - Best for results-based content

3. **POV + Scenario**
   - "POV: You're [relatable situation]"
   - Best for humor/relatability

4. **Tutorial/How-to**
   - Show the process
   - Best for actionable content

5. **Trending audio + niche twist**
   - Use trending sound with your industry angle
   - Best for discovery

### Top Instagram Creators to Study

**Chris Do** (@thechrisdo)
- Format: Design carousels, business wisdom
- Hook style: Provocative statements
- Example: "Stop charging hourly. Here's why:" [carousel]
- What to learn: High-quality carousel design, business positioning

**Vanessa Lau** (@vanessalau.co)
- Format: Reels, carousels on content creation
- Hook style: Direct tutorial promise
- Example: "3 hooks that will get you more views"
- What to learn: Tutorial Reel structure

**Gary Vaynerchuk** (@garyvee)
- Format: High-volume Reels, talking head
- Hook style: Energy + bold claim
- Example: "The truth about [topic] nobody wants to hear"
- What to learn: High-energy hooks, volume strategy

### Instagram Caption Formulas

**The Story Caption:**
```
[Hook line that creates curiosity]

I remember when [personal story setup]...

[Story middle - the struggle]

Then [turning point].

[Lesson learned]

What's your experience with [topic]?

---

💾 Save | 📤 Share | 💬 Comment
```

**The List Caption:**
```
[Hook: Number + benefit]

Here's exactly what I mean:

1️⃣ [Point + brief explanation]

2️⃣ [Point + brief explanation]

3️⃣ [Point + brief explanation]

Which one resonates most? 👇
```

**The Teach Caption:**
```
[Hook: Contrarian or surprising statement]

Here's what most people don't realize:

[Explanation - 2-3 paragraphs]

Try this instead:
→ [Action 1]
→ [Action 2]
→ [Action 3]

Save this for later 📌
```

---

## TikTok Deep Dive

### The Algorithm (December 2025)

TikTok's 2025 algorithm prioritizes **enhanced personalization**, focusing on watch time (especially first seconds), niche communities, contextual content understanding, and video quality.

**Priority signals:**

1. **Watch Time (First Seconds)** — Completion rate is #1, but early seconds weighted heavily
2. **Rewatch Rate** — Multiple views = strong signal
3. **Shares** — Especially to DMs
4. **Niche Community Alignment** — 2025 rewards specialized audiences over broad virality
5. **Contextual Categorization** — AI distinguishes humor, education, emotion to match interests
6. **Video Quality** — Lighting, sound, editing now integrated into ranking

**2025 Changes:**
- **Longer content favoritism** — Algorithm now favors 30-60+ seconds if retention is high
- **Niche community boost** — Specialized audiences (#BookTok, #MarketingTok) get rewarded over generic viral attempts
- **Deeper AI personalization** — Analyzes watch duration, replays, and cross-platform media habits
- **Contextual understanding** — AI categorizes content type to better match user preferences

**The testing pattern:**
- TikTok shows your video to small groups first (~200-500 people)
- If engagement is strong, it shows to more
- Each "batch" must perform for the next batch to see it
- This is why first 3 seconds determine everything

### Hook Mastery

**The 3-second test:**
- What is the viewer seeing visually?
- What are they hearing?
- What question/curiosity is planted?

**Hook categories:**

**1. Identity Callout**
> "This is for my [specific group]..."
> "If you're a [identity], you need to hear this"
> "Only [role] will understand this"

**2. Pattern Interrupt**
> [Start mid-action, no intro]
> [Unexpected visual that doesn't match audio]
> [Jump cut to key moment]

**3. Controversy Spark**
> "I'm gonna get hate for this but..."
> "[Popular opinion] is wrong. Here's why."
> "Unpopular opinion in the [industry] space:"

**4. Proof First**
> [Show the result, then explain]
> "Here's how I [got result]"
> [Before/after with outcome first]

**5. Curiosity Gap**
> "The thing about [topic] that nobody talks about..."
> "I can't believe [brand/industry] doesn't want you to know this"
> "This one thing changed everything:"

### Video Structure Patterns

**The Rapid Teach (15-30 sec):**
```
0-3 sec: Hook (bold claim)
3-25 sec: 3-5 rapid points
25-30 sec: CTA or loop point
```

**The Story Hook (30-60 sec):**
```
0-3 sec: Start in the middle ("So there I was...")
3-10 sec: Setup context
10-45 sec: Story with tension
45-60 sec: Payoff/lesson
```

**The Myth Bust (15-45 sec):**
```
0-3 sec: "Stop believing [myth]"
3-30 sec: Why it's wrong + what's true
30-45 sec: What to do instead
```

**The POV (15-30 sec):**
```
0-3 sec: "POV: [relatable scenario]"
3-25 sec: Act out the scenario
25-30 sec: Punchline or insight
```

### Top TikTok Creators to Study (Business/Education)

**Alex Hormozi** (@hormozi)
- Format: Talking head, green screen, clips
- Hook style: Bold claim + proof
- Example: "The lie you've been told about [topic]"
- What to learn: No-BS delivery, rapid value

**Jade Darmawangsa** (@jadedarmawangsa)
- Format: Business tips, lifestyle
- Hook style: Specific result + how
- Example: "How I made $10k in my first month doing [thing]"
- What to learn: Proof-first hooks, specificity

**Marina Mogilko** (@marinamogilko)
- Format: Entrepreneurship, education
- Hook style: Personal story + insight
- Example: "I went from [situation A] to [situation B]. Here's what changed:"
- What to learn: Story-based hooks

**Hank Green** (@hankgreen)
- Format: Educational, science, commentary
- Hook style: Curiosity + expertise
- Example: "There's something weird about [topic] nobody talks about"
- What to learn: Educational content delivery

### TikTok-Specific Tips

1. **Sound matters** — Use trending sounds when relevant (even at low volume)
2. **Captions required** — 80%+ watch without sound
3. **Loop potential** — End where you started for rewatches
4. **Comment bait** — End with question or controversial take
5. **Series format** — "Part 1," "Episode 2" drives follows
6. **Green screen** — You + content behind you (tweets, data, etc.)

---

## YouTube Deep Dive

### The Algorithm (December 2025)

YouTube optimizes for **viewer satisfaction and retention** across both Shorts and long-form, with AI-driven personalization and stronger quality/authority checks.

**Video-level signals:**
- **Click-through rate (CTR)** — How often people click when shown your video
- **Average view duration & % watched** — Raw watch time AND completion percentage
- **Session impact** — Does your video keep people on YouTube longer?
- **Viewer satisfaction** — YouTube uses surveys + behavior to estimate quality
- **Negative feedback** — "Not interested," skips, very low retention hurt you

**Channel-level signals:**
- **Topical consistency and authority** — Focused channels get recommended more
- **History of viewer satisfaction** — Based on surveys + engagement over time
- **Upload regularity and library depth** — More data for the system to work with

**2025 Changes:**
- **AI-driven hyper-personalization** — Device, time of day, individual habits
- **Evergreen revival** — Old videos get surfaced when topics trend again
- **Authority/depth emphasis** — Aligned with Google Search updates; entity-rich content rewarded
- **Single satisfaction objective** — Shorts and long-form both feed channel understanding

### Shorts vs. Long-Form

**YouTube Shorts:**
- Discovery engine (like TikTok FYP)
- Drives subscribers but lower watch time value
- Can repurpose TikTok content
- 10-35 seconds optimal for discovery, up to 60 for stories

**Long-Form:**
- Monetization engine (ad revenue)
- Search + browse (evergreen discovery)
- 8-12 minutes sweet spot for most niches
- Builds deeper audience relationship

### Thumbnail Psychology

**The 3-element rule:**
- Maximum 3 visual elements
- Face, text, object (or any combination of 2-3)

**What drives clicks:**

| Element | Why It Works |
|---------|--------------|
| Expressive face | Emotion is magnetic |
| Bold text (3-4 words max) | Adds context at small size |
| Before/after | Curiosity about transformation |
| Contrast colors | Stands out in feed |
| Curiosity gap | Shows outcome, not process |

**What kills clicks:**
- Cluttered design
- Generic thumbnails
- Too much text
- Low contrast
- Face with neutral expression

**CTR Benchmarks (December 2025):**
- **Home & Suggested:** 4-10% typical; 6-12% is strong for established channels
- **Search-driven content:** 8-15% CTR for well-targeted how-to/tutorial topics
- **Shorts:** CTR less relevant—swipe-through vs swipe-away is the analog

Note: YouTube balances CTR with watch time and satisfaction. Clickbait that gets clicks but poor retention gets down-ranked.

### Title Formulas That Work

**The "How" Title:**
> "How I [Achieved Result] in [Timeframe]"
> "How to [Achieve Outcome] (Step-by-Step)"
> "How [Known Person/Company] [Does Thing]"

**The Number Title:**
> "[Number] [Things] That [Outcome]"
> "[Number] Mistakes [Role] Make"
> "[Number] Signs [Situation]"

**The Curiosity Title:**
> "Why [Surprising Thing] Is [Counterintuitive Truth]"
> "The [Adjective] [Thing] That [Outcome]"
> "What [Expert/Company] Doesn't Want You to Know About [Topic]"

**The Transformation Title:**
> "I [Did X] for [Time Period]. Here's What Happened."
> "From [State A] to [State B]: My Journey"
> "[Result] in [Timeframe]: Exactly How I Did It"

### Long-Form Structure (AIDA Framework)

**Attention (0-30 seconds):**
- Pattern interrupt or bold claim
- Quick credibility (if needed)
- Preview of value
- "Stay until the end for [bonus]"

**Interest (30 sec - 2 min):**
- Why this matters
- Who this is for
- What you'll cover
- Build anticipation

**Desire (Main content):**
- Deliver on promise
- Clear sections
- Examples and proof
- Verbal signposting ("First... Next... Finally...")

**Action (Last 30 seconds):**
- Summary
- Clear next step
- End screen (subscribe + next video)

### Top YouTube Creators to Study

**Ali Abdaal** (@aliabdaal)
- Format: Productivity, self-improvement
- Hook style: Relatable problem + solution preview
- What to learn: Clean structure, personality

**Thomas Frank** (@thomasfrank)
- Format: Productivity tutorials
- Hook style: Specific promise + demonstration
- What to learn: Tutorial structure, visual quality

**Peter McKinnon** (@petermckinnon)
- Format: Photography/video tutorials
- Hook style: Energy + immediate value
- What to learn: Production quality, personality

**Marques Brownlee (MKBHD)** (@mkbhd)
- Format: Tech reviews
- Hook style: Clean, direct, trusted
- What to learn: Consistency, trust-building

### YouTube Shorts Patterns

**Pattern 1: The Rapid Tip**
```
Hook: "[Number]-second [topic] tip"
Body: Deliver immediately
CTA: "Subscribe for more"
```

**Pattern 2: The Clip**
```
Hook: Best moment from long-form video
Body: Self-contained value
CTA: "Full video on my channel"
```

**Pattern 3: The Transformation**
```
Hook: Show the result
Body: Quick explanation of how
CTA: "Want the full tutorial?"
```

**Pattern 4: The Reaction**
```
Hook: React to trending topic/content
Body: Your hot take
CTA: "What do you think?"
```

---

## Cross-Platform Content Calendar

### The 5-3-2 Weekly Rhythm

**5 posts per week: Value content**
- Carousels, threads, educational Reels
- Atomized from your core content

**3 posts per week: Engagement content**
- Questions, polls, hot takes
- Drives comments and conversation

**2 posts per week: Personal/behind-the-scenes**
- Stories, personal observations
- Builds connection

### Weekly Schedule Template

| Day | LinkedIn | Twitter | Instagram | TikTok | YouTube |
|-----|----------|---------|-----------|--------|---------|
| Mon | Carousel | Thread | Carousel | Educational | Short |
| Tue | Text post | Single tweets | Story | — | — |
| Wed | — | Thread | Reel | Hot take | — |
| Thu | Text post | Single tweets | Story | Tutorial | Short |
| Fri | Carousel | — | Carousel | — | — |
| Sat | — | Single tweets | Reel | Personal | — |
| Sun | — | — | Story | — | Long-form |

### Content Repurposing Matrix

| Source | → LinkedIn | → Twitter | → Instagram | → TikTok | → YouTube |
|--------|------------|-----------|-------------|----------|-----------|
| Blog Post | Carousel, 2x text | Thread, 3x single | Carousel, Reel | 2-3 clips | Short, Long |
| Newsletter | Text post, carousel | Thread | Carousel | 1-2 clips | Short |
| Podcast | Quote posts | Thread, clips | Reel clips | 3-5 clips | Full episode |
| Video | Key points as text | Thread of insights | Reel clips | Repurpose | Source |
| Data/Research | Carousel | Thread | Carousel | Green screen | Short |

---

## Platform-Specific CTAs

### LinkedIn CTAs
- "Repost to help someone in your network"
- "Follow for more [topic]"
- "Comment with your biggest takeaway"
- "Tag someone who needs to see this"
- "Save this for later (bookmark in top right)"

### Twitter CTAs
- "RT the first tweet if this was useful"
- "Follow @[handle] for more"
- "Reply with your take"
- "Quote tweet with your experience"
- "Bookmark this thread"

### Instagram CTAs
- "Save this post for later 📌"
- "Send this to someone who needs it"
- "Drop a [emoji] if this resonated"
- "Comment [word] for [resource]"
- "Follow for daily [topic]"

### TikTok CTAs
- "Follow for more [topic]"
- "Part 2?" (drives comments)
- "Save this" (drives saves)
- "Duet this with your take"
- "Link in bio"

### YouTube CTAs
- "Subscribe and hit the bell"
- "Watch this video next" (with end screen)
- "Leave a comment with [question]"
- "Like this video if it helped"
- "Join the [membership/channel]"

---

## Common Mistakes by Platform

### LinkedIn Mistakes
1. Posting links in main body (kills reach)
2. Too many hashtags (3-5 max)
3. No line breaks (wall of text)
4. Hashtags in carousel slides
5. Copying Twitter energy (too casual)

### Twitter Mistakes
1. Thread too long (20+ tweets)
2. No hook in first tweet
3. Filler tweets with no value
4. Not replying to comments
5. Posting at wrong times

### Instagram Mistakes
1. Static images only (algorithm punishes)
2. Hashtags in wrong places
3. No captions on video
4. Reposting TikToks with watermark
5. Inconsistent visual style

### TikTok Mistakes
1. Slow intros (no hook for 3+ seconds)
2. Not using captions
3. Ignoring trending sounds
4. Over-produced content (authenticity wins)
5. Not responding to comments

### YouTube Mistakes
1. Clickbait that doesn't deliver
2. No hook in first 30 seconds
3. Thumbnail too cluttered
4. Title doesn't match content
5. No cards/end screens
