---
name: content-atomizer
description: Repurposes single content pieces into multiple formats for maximum distribution while maintaining brand voice. This skill should be used when maximizing ROI from pillar content, filling content calendars efficiently, reaching audiences across multiple platforms, or when creating original content for every channel feels unsustainable.
---

# Content Atomizer

This skill extracts maximum value from every piece of content by strategically repurposing it across formats and platforms - without losing quality or sounding repetitive.

## Objective

Transform one substantial piece of content into many derivative pieces, each optimized for its destination platform while maintaining consistent brand voice and messaging.

## Intake Questions

Before atomizing content, gather context:

1. **Source content**: What is the original piece? (Blog post, video, podcast, webinar, report)
2. **Target platforms**: Where should the atomized content go? (LinkedIn, Twitter/X, Instagram, YouTube, email, etc.)
3. **Audience overlap**: Are the same people on multiple platforms or different segments?
4. **Brand voice**: What's the established voice? (Reference `brand-voice` skill)
5. **Goals per platform**: What action do you want on each? (Awareness, clicks, engagement, follows)
6. **Content calendar**: What's the publishing cadence per platform?
7. **Evergreen vs. timely**: Does this content have a shelf life?

## The Atomization Matrix

Transform source content into these derivative formats:

### From a Blog Post / Article

| Derivative Format | What to Extract | Platform |
|------------------|-----------------|----------|
| Twitter/X thread | Main points as numbered list | Twitter/X |
| LinkedIn post | Key insight + personal take | LinkedIn |
| Instagram carousel | Tips/steps as slides | Instagram |
| Email newsletter section | Summary + link | Email |
| Quote graphics | Quotable lines | All social |
| YouTube Short / Reel | One tip explained | YouTube, IG, TikTok |
| Podcast talking points | Discussion outline | Podcast |
| Infographic | Data/process visualization | Pinterest, LinkedIn |
| Slide deck | Key points as slides | SlideShare, LinkedIn |
| FAQ content | Questions answered in post | Website, help docs |

### From a Video / Webinar

| Derivative Format | What to Extract | Platform |
|------------------|-----------------|----------|
| Blog post | Full transcript, edited | Website |
| Short clips (60-90s) | Key moments | YouTube Shorts, Reels, TikTok |
| Audiogram | Audio + waveform visual | Social media |
| Quote graphics | Best soundbites | All social |
| Twitter/X thread | Main points summarized | Twitter/X |
| Email recap | Highlights + replay link | Email |
| LinkedIn article | Expanded written version | LinkedIn |
| Slide deck | Presentation slides reused | SlideShare |
| GIF moments | Reactions, demonstrations | Social, website |
| Transcript PDF | Lead magnet or resource | Website |

### From a Podcast Episode

| Derivative Format | What to Extract | Platform |
|------------------|-----------------|----------|
| Show notes post | Summary + timestamps | Website |
| Full transcript | Searchable text version | Website |
| Blog post | Key insights expanded | Website |
| Audiogram clips | Best 60-second moments | Social media |
| Quote graphics | Guest quotes, key insights | Social media |
| Twitter/X thread | Episode highlights | Twitter/X |
| Newsletter | Episode summary + link | Email |
| YouTube video | Video version if recorded | YouTube |
| Pull quotes | For promotional use | All channels |
| Guest spotlight | Feature the guest | LinkedIn, Twitter/X |

### From a Report / Research

| Derivative Format | What to Extract | Platform |
|------------------|-----------------|----------|
| Blog posts (series) | One post per finding | Website |
| Infographics | Data visualizations | Pinterest, LinkedIn |
| Twitter/X threads | Key stats and insights | Twitter/X |
| LinkedIn posts | Individual findings | LinkedIn |
| Press release | Newsworthy findings | Media |
| Slide deck | Presentation version | Conferences, webinars |
| Webinar | Walk through findings | Live presentation |
| Email series | One finding per email | Email |
| Stat graphics | Individual data points | All social |
| Executive summary | Short PDF version | Lead magnet |

## Platform-Specific Adaptation

Each platform has different requirements:

### Twitter/X
- **Length**: 280 characters or threads
- **Tone**: Conversational, punchy
- **Format**: Text, images, threads, polls
- **Best for**: Ideas, insights, engagement
- **Hook**: First line must stop the scroll

### LinkedIn
- **Length**: Up to 3,000 characters
- **Tone**: Professional but human, relatable, and opinionated
- **Format**: Text posts, carousels, articles, video
- **Best for**: B2B, thought leadership, career content, personal branding
- **Hook**: First 2 lines are critical before "...see more"
- **Timing**: Tuesday-Thursday, 8-11 AM (audience's time zone)
- **Links**: Place external links in the first comment, not the post body, to avoid algorithm penalties

### Instagram
- **Length**: 2,200 characters (but shorter better)
- **Tone**: Visual-first, casual, authentic
- **Format**: Feed posts, carousels, Reels, Stories
- **Best for**: Visual content, personal brands, how-tos
- **Hook**: Strong first slide/frame

### YouTube
- **Length**: Varies (Shorts: 60s, Long-form: 10-20min optimal)
- **Tone**: Energetic, valuable, entertaining
- **Format**: Long-form, Shorts, Community posts
- **Best for**: Tutorials, entertainment, deep dives
- **Hook**: First 30 seconds critical

### TikTok
- **Length**: Up to 10 minutes (but 15-60s performs best)
- **Tone**: Authentic, entertaining, trend-aware
- **Format**: Short videos, duets, stitches
- **Best for**: Younger audiences, entertainment, trends
- **Hook**: First 1-3 seconds critical

### Email
- **Length**: 200-500 words typically
- **Tone**: Personal, direct, valuable
- **Format**: Newsletter sections, standalone emails
- **Best for**: Deeper engagement, conversions
- **Hook**: Subject line + first line

## Viral LinkedIn Post Framework (2025)

When repurposing content for LinkedIn, follow this proven structure for maximum reach:

### 1. The Scroll-Stopping Hook
The first 2 lines must earn the click on "...see more".
- **Stat/Data**: Start with a surprising number.
- **Bold Opinion**: Challenge common wisdom in your niche.
- **Personal Moment**: Share a vulnerable or relatable struggle.
- **Unexpected Twist**: Start with a premise and flip it immediately.
- **Avoid**: "Just wanted to share some thoughts..." or "I've been thinking about..."

### 2. The Single Message Body
Don't cram multiple ideas into one post.
- **One Post, One Intent**: Stick to one story, one lesson, or one tip.
- **Scannable Formatting**: Use 1-3 lines per paragraph max.
- **Mobile-Friendly**: Use whitespace to make it easy to read on phones.
- **Specifics**: Name tools, give real numbers, and use concrete examples.

### 3. The Discussion-Starting CTA
End with a prompt that invites conversation.
- **Real Questions**: "Have you felt this same pressure?" or "What's one tool I missed?"
- **Low Friction**: Make it easy for people to share their own experience.
- **Avoid Engagement Bait**: Never use "Like if you agree" or "Comment 'YES' below".
- **Optional CTA**: If the post is a heartfelt story, it's okay to skip the CTA entirely.

### 4. Early Engagement Strategy
LinkedIn's algorithm prioritizes posts that get traction in the first 60-90 minutes.
- **Reply Immediately**: Engage with every comment in the first hour.
- **Seed the Link**: If you have a link to share, post it as the first comment after publishing.

## Content Hierarchy

Structure your content ecosystem:

```
                 ┌─────────────────────────────┐
                 │      PILLAR CONTENT         │
                 │  (Blog post, Video, Report) │
                 └─────────────┬───────────────┘
                               │
           ┌───────────────────┼───────────────────┐
           │                   │                   │
           ▼                   ▼                   ▼
    ┌─────────────┐     ┌─────────────┐     ┌─────────────┐
    │ SUPPORTING  │     │ SUPPORTING  │     │ SUPPORTING  │
    │  Blog posts │     │   Videos    │     │   Emails    │
    └──────┬──────┘     └──────┬──────┘     └──────┬──────┘
           │                   │                   │
           ▼                   ▼                   ▼
    ┌─────────────────────────────────────────────────────┐
    │               MICRO CONTENT                         │
    │  Social posts, Clips, Graphics, Quotes, Stories     │
    └─────────────────────────────────────────────────────┘
```

**Rules**:
- Pillar content: Comprehensive, original, high-effort
- Supporting content: Derived, expanded on subtopics
- Micro content: Snackable, platform-native, high-volume

## Efficiency Workflow

Batch production process for maximum efficiency:

### Step 1: Create Pillar Content
- Invest heavily in one comprehensive piece
- Make it your best work on the topic
- Include multiple angles and subtopics

### Step 2: Extract Core Elements
Pull from pillar content:
- Key insights (3-5)
- Quotable lines (5-10)
- Data points (all stats)
- Steps/processes (full lists)
- Stories/examples (all narratives)

### Step 3: Map to Platforms
Assign elements to platforms based on the **AMA Framework**:
- **Audience**: Who are we talking to on this specific platform? (Speak to one real person).
- **Message**: What is the one key insight they need from this piece?
- **Action**: What specific action should they take?

Assign elements to platforms based on:
- Platform format requirements
- Audience on each platform
- Goals per platform

### Step 4: Batch Create
Create all derivatives in batches:
- All graphics in one session
- All written posts in one session
- All video clips in one session

### Step 5: Schedule Distribution
Stagger publication:
- Don't post everywhere same day
- Space derivatives over weeks
- Maintain consistent presence per platform

## Voice Consistency Checklist

When atomizing, maintain brand voice:

- [ ] Same vocabulary and terminology
- [ ] Consistent perspective (first person, third person)
- [ ] Matching energy level (enthusiastic, measured)
- [ ] Aligned values and opinions
- [ ] Recognizable style markers
- [ ] **No Em-Dashes**: Ensure no em-dashes (-) or en-dashes (-) are used in any platform derivatives.

**Adaptation allowed**:
- Tone can flex slightly for platform (more casual on TikTok, more professional on LinkedIn)
- Length adjusts for platform
- Format changes for platform requirements

**Not allowed**:
- Contradicting messaging across platforms
- Different personalities on different channels
- Conflicting information or opinions

## Output Format

When atomizing content, deliver:

1. **Source Analysis**: Summary of pillar content and extractable elements
2. **Atomization Plan**: What derivatives to create, for which platforms
3. **Derivative Content**: Full copy/scripts for each piece
4. **Visual Specifications**: Requirements for graphics/video (if applicable)
5. **Distribution Schedule**: When to publish each piece
6. **Cross-Linking Strategy**: How pieces connect back to pillar content

## Cross-References

- Apply `brand-voice` to ensure consistency across all derivatives
- Source content may come from `seo-content` pillar articles
- Turn derivatives into `newsletter` sections
- Support `lead-magnet` promotion across channels
- `keyword-research` topics inform pillar content selection
- `orchestrator` routes here for content distribution projects
