# Platform Query Templates

## YouTube Analysis

### Trending Content Discovery
```
Query: What cardiology/heart health videos are getting the most views on YouTube this week? 
Include: title, channel, view count, upload date, and why it's performing well.
```

### Content Gap Analysis
```
Query: What cardiology topics do YouTube viewers frequently request in comments but 
creators haven't covered well? Focus on the gap between demand and supply.
```

### Competitor Analysis
```
Query: Analyze the top 5 cardiology YouTube channels. What content formats and 
topics perform best for them? What patterns emerge?
```

## Twitter/X Analysis

### Trending Discussions
```
Query: What cardiology and heart health topics are cardiologists and healthcare 
professionals discussing on Twitter/X this week? Include any viral threads.
```

### Controversial Takes
```
Query: What controversial or contrarian cardiology opinions are generating 
engagement on Twitter/X? Focus on professional debates.
```

### News Hooks
```
Query: What cardiology news stories are getting the most reaction on Twitter/X?
How are healthcare professionals responding?
```

## LinkedIn Professional

### Thought Leadership Topics
```
Query: What cardiology and healthcare leadership topics are getting high 
engagement on LinkedIn this week? Focus on posts from doctors and executives.
```

### Industry Trends
```
Query: What healthcare industry trends are cardiology professionals discussing 
on LinkedIn? Include any data or reports being shared.
```

## Reddit Deep Dives

### Patient Questions
```
Query: What questions are people asking in heart health and cardiology 
subreddits that aren't getting good answers? Focus on common concerns.
```

### Professional Discussions
```
Query: What are medical professionals discussing in cardiology-related 
subreddits? Any emerging debates or interesting cases?
```

## News & Media

### Breaking Stories
```
Query: What cardiology research or clinical findings are making headlines 
this week? Include source and publication details.
```

### Industry Developments
```
Query: What regulatory, policy, or industry changes are affecting cardiology 
this week? Focus on implications for patients and practitioners.
```

## Podcast Trends

### Popular Episodes
```
Query: What cardiology or medical podcast episodes are being discussed 
or recommended this week? What topics are they covering?
```

## Academic/Research

### New Studies
```
Query: What cardiology studies published in the last month are getting 
the most attention? Focus on those with clinical implications.
```

### Clinical Guidelines
```
Query: Are there any new or updated cardiology clinical guidelines being 
discussed? What are the key changes and debates?
```

---

# Content Format Recommendations by Platform

## YouTube
- **Best Formats**: Educational deep-dives (15-30 min), myth-busting, patient stories
- **Optimal Length**: 12-20 minutes for educational, 8-12 for news commentary
- **Key Elements**: Strong thumbnail, keyword-rich title, hook in first 30 seconds

## Twitter/X  
- **Best Formats**: Threads (5-15 tweets), single insight tweets, quote-tweet commentary
- **Optimal Length**: Threads work best; single tweets need strong hook
- **Key Elements**: First tweet must standalone, use whitespace, end with call-to-action

## LinkedIn
- **Best Formats**: Personal stories with lesson, data insights, contrarian professional takes
- **Optimal Length**: 1200-1500 characters (shows "see more" without being too long)
- **Key Elements**: Strong first line (hook), line breaks for readability, ask question at end

## Blog/SEO
- **Best Formats**: Comprehensive guides (3000+ words), how-tos, data studies
- **Optimal Length**: 2500-4000 words for SEO, 800-1200 for news commentary
- **Key Elements**: Table of contents, scannable headers, internal linking

## Short-Form Video (TikTok/Reels)
- **Best Formats**: Myth-busting, quick tips, surprising facts, reaction to trends
- **Optimal Length**: 30-60 seconds (TikTok), 15-30 seconds (Reels)
- **Key Elements**: Hook in first 2 seconds, text overlays, trending audio
