---
name: content-metrics
description: Knowledge base for measuring, analyzing, and optimizing content performance. Use when tracking metrics, analyzing patterns, or making data-driven content decisions.
---

# Content Metrics Skill

Framework for measuring and optimizing content performance across platforms.

## Metrics Hierarchy

### Vanity vs Value Metrics

**Vanity Metrics** (Nice to have):
- Follower count
- Total likes
- Impressions

**Value Metrics** (Actually matter):
- Engagement rate
- Comment quality
- Profile visits → follows
- Inbound opportunities
- Conversion to action

### The Metrics That Matter

| Metric | What It Measures | Why It Matters |
|--------|------------------|----------------|
| Engagement Rate | Likes+Comments+Shares / Impressions | True content resonance |
| Comment Count | Number of comments | Content sparked discussion |
| Save/Bookmark Rate | Saves / Impressions | Content worth keeping |
| Share Rate | Shares / Impressions | Content worth spreading |
| Profile Visits | Clicks to profile | Interest in author |
| Follow Rate | New followers / Impressions | Converting readers to audience |

## Platform-Specific Benchmarks

### LinkedIn

| Metric | Poor | Average | Good | Great |
|--------|------|---------|------|-------|
| Engagement Rate | <1% | 1-2% | 2-4% | >4% |
| Comment Rate | <0.1% | 0.1-0.3% | 0.3-0.5% | >0.5% |
| Impressions | <500 | 500-2K | 2K-10K | >10K |

### Twitter/X

| Metric | Poor | Average | Good | Great |
|--------|------|---------|------|-------|
| Engagement Rate | <0.5% | 0.5-1% | 1-2% | >2% |
| Retweet Rate | <0.1% | 0.1-0.5% | 0.5-1% | >1% |
| Reply Rate | <0.1% | 0.1-0.2% | 0.2-0.5% | >0.5% |

## Performance Categories

### Content Type Performance

Track performance by type:
- Personal stories
- Frameworks/how-tos
- Contrarian takes
- Industry commentary
- Curated content
- Questions/polls

### Topic Performance

Track by topic area:
- Leadership
- Technical
- Career advice
- Industry trends
- Personal brand
- Company/product

### Format Performance

Track by format:
- Text only
- Text + image
- Carousel
- Video
- Thread
- Poll

### Timing Performance

Track by:
- Day of week
- Time of day
- Posting frequency

## Analysis Frameworks

### The 80/20 Analysis

1. List all content from period
2. Rank by key metric (engagement)
3. Identify top 20%
4. Analyze: What do they share?
5. Identify bottom 20%
6. Analyze: What patterns appear?

### The Triple-F Framework

**Format**: What format performed best?
**Focus**: What topics resonated?
**Framing**: How was content positioned?

### Trend Analysis

```
1. Baseline: What's your average?
2. Compare: Each post vs average
3. Trend: Is average improving?
4. Outliers: What caused spikes?
5. Patterns: What's consistent?
```

## Data Collection

### What to Track

For each post, record:
- Date/time posted
- Platform
- Content type/format
- Topic
- Hook type used
- Length
- Key metrics (24h, 48h, 7d)
- Notable outcomes

### Memory Storage Format

```
Category: ["content-published", "[platform]"]
Content: "Post: [hook/summary]
Published: [date]
Platform: [platform]
Type: [content type]
Topic: [topic]
Metrics (7d): [likes], [comments], [shares], [impressions]
Notable: [any notable outcomes]"
```

## Optimization Framework

### The Testing Loop

```
1. Hypothesis: "Story hooks get more engagement"
2. Test: Publish 5 story-hook posts
3. Measure: Compare to baseline
4. Learn: Confirm or reject hypothesis
5. Apply: Adjust strategy
6. Repeat
```

### Variables to Test

**Hook Types:**
- Story tease
- Question
- Contrarian statement
- List promise
- Direct statement

**Content Length:**
- Short (<100 words)
- Medium (100-300 words)
- Long (300+ words)

**Posting Time:**
- Morning (7-10 AM)
- Midday (11 AM-2 PM)
- Afternoon (3-6 PM)
- Evening (7-10 PM)

**Frequency:**
- Daily
- Every other day
- 2-3x per week
- Weekly

## Pattern Recognition

### Signals of Good Content

- High comment-to-like ratio (people talking, not just clicking)
- Save/bookmark rate above average
- Comments asking questions (engagement)
- Shares with commentary added
- Profile visits spike after post

### Signals of Weak Content

- High impressions, low engagement (reached people, didn't resonate)
- No comments (didn't spark thought)
- Quick engagement drop-off (didn't hold attention)
- No profile visits (didn't build interest in author)

## Reporting Templates

### Weekly Check-in

```
This Week:
- Posts: X
- Avg Engagement: X (vs Y last week)
- Best: [Post summary] - [why it worked]
- Learning: [One insight]
```

### Monthly Review

```
This Month:
- Total Posts: X
- Engagement Trend: [up/down/stable]
- Top 3: [List with metrics]
- Pattern: [Key pattern identified]
- Next Month Focus: [Priority]
```

### Quarterly Analysis

```
Quarter Overview:
- Content Volume: X posts
- Audience Growth: X → Y followers
- Engagement Trend: [graph or summary]
- Top Performers: [Top 10 with analysis]
- Patterns Confirmed: [List]
- Strategy Adjustments: [Changes to make]
```

## Converting Insights to Action

### From Data to Decision

| Finding | Implication | Action |
|---------|-------------|--------|
| Story posts perform 2x | Audience likes narrative | Lead with stories more |
| Tuesday posts best | Audience active mid-week | Prioritize Tue-Thu |
| Long posts underperform | Audience prefers concise | Tighten editing |

### Priority Matrix

| | High Impact | Low Impact |
|---|------------|-----------|
| **Easy** | Do first | Do if time |
| **Hard** | Plan for | Don't do |

Focus optimization efforts on high-impact, easy changes first.
