---
name: content-reviewer
description: Use when reviewing written content (blog posts, marketing copy) for AI-generated patterns and improving prose for natural human voice
---

# Content Reviewer

## Overview

Review written content to detect AI-generated patterns and suggest improvements for more natural, human voice. Works best on blog posts, marketing copy, and documentation.

## When to Use

- After drafting content, before publishing
- When content "sounds AI-generated"
- When polishing prose for publication
- User asks to review content for AI-isms

## Workflow

```dot
digraph review_flow {
    "Read content" [shape=doublecircle];
    "Pass 1: AI patterns" [shape=box];
    "Pass 2: Style issues" [shape=box];
    "Pass 3: Structure" [shape=box];
    "Present findings with options" [shape=box];
    "User approves changes" [shape=doublecircle];

    "Read content" -> "Pass 1: AI patterns";
    "Pass 1: AI patterns" -> "Pass 2: Style issues";
    "Pass 2: Style issues" -> "Pass 3: Structure";
    "Pass 3: Structure" -> "Present findings with options";
    "Present findings with options" -> "User approves changes";
}
```

## Pass 1: AI Pattern Detection

Scan for these common AI-isms and flag with line numbers:

| Pattern | Example | Issue |
|---------|---------|-------|
| "Picture this:" openers | "Picture this: a user logs in..." | Cliché AI opener |
| Rhetorical question chains | "What if you could X? Tap into Y?" | Formulaic |
| Contrast structures | "The real unlock isn't X. It's Y" | Overused by AI |
| "Think of it as..." | "Think of it as a unified account" | AI filler phrase |
| "Consider how/a..." | "Consider how markets work:" | Sometimes ok, often AI-ish |
| Parallel structures | "What X does for Y, Z does for W" | Too symmetrical, formulaic |
| "This is a step towards..." | Generic progress language | Vague |
| "lays the foundation" | Cliché | Context-dependent |
| "This creates a flywheel" | Buzzy | Context-dependent |
| "hub" as noun | "interoperability hub" | Overused buzzword |
| Back-to-back rhetorical questions | "What if X? What about Y?" | AI pattern |
| Excessive bullet points | "How it will work: - X - Y - Z - W" | AI formatting, reads sloppy |

### Preferred Alternatives

| AI Pattern | Human Alternative |
|------------|-------------------|
| "Picture this: X" | Just state X directly |
| "What if you could X?" | "You could X" |
| "The real unlock isn't X. It's Y" | Cut, or just state Y |
| "Think of it as X" | "It's X" or use a dash |
| "Consider how X works:" | "X already works this way:" |
| "What X does for Y, Z does for W" | "Z plays the same role for W" |
| Excessive bullet points | Convert to flowing prose; use bullets only for truly parallel items |

## Pass 2: Style Issues

Check for:

- **Redundancy** - Same point made twice in different sections
- **Inconsistent formatting** - Some bullets bold, some not
- **Long sentences** - Could be split for clarity
- **Vague language** - Could be more concrete/specific
- **Salesy tone** - "That's volume you're not capturing" → "That's a user you're losing"
- **Jargon** - Technical terms without explanation
- **"settlement" vs "clearing"** - "Clearing" is often better (DTCC does clearing)
- **Excessive bullet points** - Lists that should be prose; bullets only work for truly parallel, scannable items

## Pass 3: Structure

- Does each section earn its length?
- Are examples concrete and current? (Avoid dated references)
- Does the flow feel natural?
- Are there abrupt transitions?
- Is there a clear narrative arc?

## Output Format

For each issue found, present as a table:

```markdown
| Line | Current | Suggested | Issue |
|------|---------|-----------|-------|
| 36 | "Picture this: a user..." | "A user..." | AI opener |
| 44 | "What if you could X? Y?" | "You could X, or Y." | Rhetorical chain |
```

Then for significant changes, offer options:

```markdown
**Line X:** [Current text]
**Issue:** [What's wrong]
**Options:**
1. [Alternative A]
2. [Alternative B]
3. [Cut entirely]
```

## Section-by-Section Review

When doing a full review, go section by section:

```markdown
### **[Section Name] (lines X-Y)**
**Verdict:** ✓ Good | Needs minor tweaks | Needs work
**Issues:**
- [specific issues with line numbers]
**Suggestions:**
- [specific suggestions]
```

## Final Summary

After all passes, provide:

```markdown
## Summary
- **AI patterns found:** X
- **Style issues:** X
- **Recommendation:** Ready to ship | Minor tweaks needed | Significant revision needed

**Remaining TODOs:**
- [any placeholders or missing content]
```

## Interaction Style

- Present options, don't force changes
- Be direct about issues
- Acknowledge when something is fine ("✓ Good")
- Know when to stop - diminishing returns are real
- Let user choose between alternatives
- Don't over-edit - preserve author's voice

## Critical Constraints

**DO:**
- Flag specific lines with issues
- Provide multiple options for fixes
- Be honest about quality
- Stop when content is good enough

**DON'T:**
- Rewrite entire sections without asking
- Force changes the user doesn't want
- Keep nitpicking after major issues are fixed
- Remove personality/voice from content
