---
name: content-writing
description: Writes e-learning module content including explanations, examples, and instructional text. Use when creating module content, writing topic explanations, developing examples, or when user mentions "write content," "module text," "explain topic," "content development," or "instructional content."
---

# E-Learning Content Writing

Guide for writing effective instructional content for e-learning modules.

## Content Structure

### Module Content Flow

Follow this structure for each content section:

```
1. HOOK (Attention)
   - Question, scenario, or surprising fact
   - "Why does this matter to you?"

2. OBJECTIVE (Expectation)
   - What learner will be able to do
   - Clear, specific outcome

3. CONTENT (Instruction)
   - Chunked information (5-7 items max)
   - Examples for each concept
   - Visual support references

4. PRACTICE (Application)
   - Knowledge check or activity
   - Immediate feedback

5. SUMMARY (Reinforcement)
   - Key takeaways (3-5 points)
   - Connection to next topic
```

## Writing Guidelines

### Voice and Tone

- **Second person**: "You will learn..." not "Learners will learn..."
- **Conversational**: Write as if speaking to one person
- **Active voice**: "Click the button" not "The button should be clicked"
- **Present tense**: "This process creates..." not "This process will create..."

### Readability

- Target 8th grade reading level (Flesch-Kincaid)
- Sentences: 15-20 words average
- Paragraphs: 3-4 sentences max
- One idea per paragraph

### Chunking Content

Apply the 7±2 rule:
- 5-9 items per list or concept group
- 3-5 key points per topic
- 5-7 minute content segments

## Content Templates

### Concept Explanation

```markdown
## [Concept Name]

[One-sentence definition]

**Why it matters:** [Relevance to learner's job/goals]

### How it works

[2-3 paragraphs explaining the concept]

### Example

[Concrete, realistic example from learner's context]

### Key Points

- [Point 1]
- [Point 2]
- [Point 3]
```

### Process/Procedure

```markdown
## How to [Task Name]

[Brief context - when and why to do this]

### Steps

1. **[Action verb] [object]**
   [Brief explanation if needed]

2. **[Action verb] [object]**
   [Brief explanation if needed]

3. **[Action verb] [object]**
   [Brief explanation if needed]

### Tips

- [Helpful tip 1]
- [Helpful tip 2]

### Common Mistakes

- [Mistake to avoid]
- [Mistake to avoid]
```

### Comparison

```markdown
## [Topic A] vs. [Topic B]

[Brief intro explaining why comparison matters]

| Aspect | [Topic A] | [Topic B] |
|--------|-----------|-----------|
| [Aspect 1] | | |
| [Aspect 2] | | |
| [Aspect 3] | | |

### When to use [Topic A]

[Situations where A is better]

### When to use [Topic B]

[Situations where B is better]
```

## Writing Examples

### Before (Poor)

> The implementation of the new customer relationship management system will necessitate that all employees undergo comprehensive training to ensure optimal utilization of the platform's capabilities and features.

### After (Good)

> You'll need training on the new CRM system before you can use it effectively. This module covers the essential features you'll use every day.

### Before (Poor)

> It is important to understand that there are multiple factors that should be considered when making a decision about which approach to take.

### After (Good)

> Consider these three factors before choosing your approach:
> 1. Timeline - How quickly do you need results?
> 2. Budget - What resources are available?
> 3. Risk - What could go wrong?

## Multimedia Integration

### When to Reference Visuals

Add visual callouts in your content:

```markdown
[IMAGE: Diagram showing the three-step process]

[VIDEO: 2-minute demonstration of the software interface]

[ANIMATION: How data flows through the system]
```

### Image Alt Text

Write descriptive alt text:

- **Informative**: `alt="Bar chart showing sales increased 40% in Q3"`
- **Process**: `alt="Flowchart: Step 1 leads to Step 2, which branches to Step 3a or 3b"`
- **Screenshot**: `alt="Settings menu with Privacy option highlighted"`

## Quality Checklist

Before finalizing content:

- [ ] Follows hook → objective → content → practice → summary structure
- [ ] Uses second person, conversational tone
- [ ] Sentences average 15-20 words
- [ ] Technical terms defined on first use
- [ ] Examples are realistic and relevant to audience
- [ ] Content chunked (5-7 items per group)
- [ ] Visual callouts included where helpful
- [ ] Key points summarized at end
- [ ] Aligns with stated learning objectives

## File Output

Save content to: `course-template/02-development/modules/module-XX/content/`
