# Effective Context Engineering for AI Agents

Source: https://www.anthropic.com/engineering/effective-context-engineering-for-ai-agents

## 核心定義

> "Context engineering is the art and science of curating what will go into the limited context window."

コンテキストエンジニアリングとは、限られたコンテキストウィンドウに何を入れるかを戦略的にキュレーションする技術。

## 基本原則

### 有限リソースとしてのコンテキスト

LLMは人間のワーキングメモリと同様に、制約された注意力予算で動作する。研究により「Context Rot」が示されている：トークン量が増えるほど、想起精度は低下する。

**結論**: コンテキストを貴重かつ有限なリソースとして扱う。

### 適切な抽象度（Right Altitude）

システムプロンプトは具体性と柔軟性のバランスを取る：

| 避けるべき極端 | 問題点 |
|--------------|--------|
| 硬直的なロジック | 時間とともに断片化 |
| 曖昧なガイダンス | 具体的な行動シグナルの欠如 |

## 長時間タスク向け3つの技法

### 1. Compaction（圧縮）

コンテキスト上限に近づいたら会話履歴を要約。アーキテクチャ決定や重要な詳細は保持しつつ、冗長な出力は破棄。

**調整ポイント**:
- Recall（関連情報の捕捉）
- Precision（不要な内容の排除）

### 2. Structured Note-Taking（構造化メモ）

エージェントが複数の推論サイクルにわたって永続的に追跡するための外部メモリファイルを維持。人間の認知を模倣：すべてを記憶するのではなく、外部システムを参照する。

### 3. Sub-Agent Architectures（サブエージェント構成）

専門化されたエージェントがクリーンなコンテキストで集中したタスクを処理し、凝縮されたサマリー（1,000〜2,000トークン）をメインコーディネーターに返す。

**効果**: 詳細な探索と高レベルの統合を分離。

## 設計ベストプラクティス

| 要素 | 推奨事項 |
|-----|---------|
| **ツール** | 最小限の実行可能セット、明確で重複しない機能 |
| **例示** | 網羅的なエッジケースより、多様な標準例をキュレート |
| **Just-in-Time取得** | 事前処理よりツール経由の動的データ読み込み |
| **ハイブリッド** | 速度のための事前ロードと自律探索能力のバランス |

## 指針

> **「望む結果の確率を最大化する、最小限の高シグナルトークンセットを見つける」**
