# Context Engineering for Agents

Source: https://blog.langchain.com/context-engineering-for-agents/

## 概要

Andrej Karpathy の定義:
> 「文脈ウィンドウを次のステップに必要な情報で満たす繊細な芸術と科学」

## 4つの主要戦略

### 1. Write Context（外部保存）

| 手法 | 説明 |
|-----|------|
| **スクラッチパッド** | タスク実行中にメモを保存 |
| **メモリ** | セッション間で学習内容を保持 |

多くのプロダクト（ChatGPT、Cursor、Windsurf等）が自動生成メモリを実装。

### 2. Select Context（選択的抽出）

- 関連するメモリや例を効果的に引き出す
- RAGをツール説明に適用し精度3倍向上
- コードエージェントはAST解析と複合的な検索技術を使用

### 3. Compress Context（圧縮）

| 手法 | 説明 |
|-----|------|
| **要約** | Claude Codeは「コンテキスト使用率95%後に自動圧縮」 |
| **トリミング** | 古いメッセージを戦略的に削減 |
| **エージェント境界** | 知識の受け渡し時に適用 |

### 4. Isolate Context（分離）

| 手法 | 説明 |
|-----|------|
| **マルチエージェント** | 関心の分離で異なるサブタスク処理 |
| **サンドボックス環境** | トークン重いオブジェクトを環境内に保持 |
| **状態オブジェクト** | 必要時のみLLMに公開 |

## 長時間実行の課題

エージェントの長時間実行では以下が発生しやすい:
- コンテキスト汚染
- 注意散漫
- 混乱・矛盾

> Cognition: 「コンテキストエンジニアリングがエージェント構築の最重要課題」

## 実装のベストプラクティス

| 要素 | 実践法 |
|-----|--------|
| **短期メモリ** | チェックポイント機能をスクラッチパッドとして活用 |
| **長期メモリ** | 複数セッション間でプロファイルやコレクションを保持 |
| **細粒度制御** | 各ノードで状態を操作し、段階的にコンテキスト公開 |
| **評価** | トークン使用量を追跡し改善効果を測定 |
