---
name: conversion-optimizer
description: Optimize CTA copy, hero sections, and button text for higher conversions using therapy-appropriate frameworks (PAS, AIDA, BAB). Maintains empathetic, non-salesy tone while driving action. Creates A/B test variations, scores conversion potential, and ensures CRPO compliance. Use when user mentions "CTA", "conversion rate", "improve button text", "more bookings", or asks about improving page performance.
---

# Conversion Copy Optimizer

## Purpose
Optimize copywriting elements for higher conversions while maintaining the empathetic, professional tone required for therapy practice marketing and full CRPO compliance.

## When to Use This Skill
- User mentions "CTA" or "call to action"
- User asks about "conversion rate" or "more bookings"
- User wants to "improve button text" or "hero section"
- Reviewing page performance (high traffic, low conversions)
- Creating new pages that need CTA elements

## Research Foundation

### 2024 Therapy Conversion Benchmarks

**Industry Statistics:**
- Healthcare industry average conversion rate: 3%
- Optimized therapy sites: 4%+ conversion rate
- 70% of new patients find therapists online
- Landing pages perform best with 1-3 strategically placed CTAs
- For therapy, trust-building is critical before conversion

**Key Insight:**
> "Behavioral health is a serious topic that requires honest and respectful vocabulary. You must recognize the potential vulnerability of those seeking mental health services."

**Sources:**
- [Mental Health CRO Guide](https://leadtorecovery.com/mental-health/cro/)
- [Therapist Website Conversions](https://www.rachelannreid.com/blogarchive/therapists-guide-website-conversions)
- [Behavioral Health Conversion Optimization](https://contentjourney.com/boosting-your-behavioral-health-conversion-rate/)

---

## Quick Start Workflow

### Step 1: Gather Context

**Required from user:**
```
1. Current CTA/copy to optimize
2. Page purpose (service page, location page, blog, etc.)
3. Target audience (students, professionals, general)
4. Current performance (if available):
   - Page views
   - Conversion rate
   - Bounce rate
```

**Request from user:**
```
Do you have:
- Google Analytics data for this page?
- Heatmap data (Hotjar, CrazyEgg)?
- Current conversion rate?
- Competitor CTA examples?
```

### Step 2: Analyze Current Copy

**Assessment Criteria:**

| Element | Score 0-10 | Notes |
|---------|------------|-------|
| Clarity | | Is action obvious? |
| Urgency (ethical) | | Sense of value without pressure |
| Trust signals | | CRPO, credentials visible nearby |
| Empathy | | Acknowledges visitor's situation |
| Value proposition | | Clear benefit to user |
| Friction reduction | | Addresses concerns/objections |

### Step 3: Apply Copywriting Framework

**IMPORTANT:** Traditional frameworks need adaptation for therapy. Never use high-pressure tactics.

---

## Therapy-Adapted Frameworks

### Framework 1: PAS (Problem → Agitation → Solution)

**Standard PAS:**
- Problem: Identify the problem
- Agitation: Make it worse
- Solution: Present your solution

**Therapy-Adapted PAS:**
- **Problem:** Acknowledge the challenge (empathetically)
- **Agitation:** Validate feelings, not amplify fear
- **Solution:** Offer hope through professional support

**Example:**

❌ **Standard PAS (Too Aggressive):**
> "Anxiety is ruining your life. It's getting worse every day, destroying your relationships and career. Without help, you'll never escape this cycle of fear."

✅ **Therapy-Adapted PAS:**
> "Living with anxiety can feel overwhelming—like it's coloring every aspect of your day. If you've been struggling to find relief on your own, you're not alone. Professional support can help you develop tools to manage anxiety and reclaim a sense of calm. Same-week appointments are available."

### Framework 2: AIDA (Attention → Interest → Desire → Action)

**Standard AIDA:**
- Attention: Grab attention
- Interest: Build interest
- Desire: Create desire
- Action: Prompt action

**Therapy-Adapted AIDA:**
- **Attention:** Speak to their experience (without dramatizing)
- **Interest:** Explain how therapy helps
- **Desire:** Paint picture of feeling better (realistic, not guaranteed)
- **Action:** Gentle, low-pressure next step

**Example:**

```
[ATTENTION]
Struggling with anxiety that won't go away?

[INTEREST]
Therapy offers evidence-based tools to help you understand
and manage anxious thoughts—not just cope, but genuinely
feel more at ease.

[DESIRE]
Imagine waking up without that knot in your stomach,
approaching challenges with confidence instead of dread.

[ACTION]
Book a free consultation to see if we're a good fit.
No pressure, no commitment.
```

### Framework 3: BAB (Before → After → Bridge)

**Standard BAB:**
- Before: Current painful state
- After: Desired better state
- Bridge: How to get there

**Therapy-Adapted BAB:**
- **Before:** Validate current experience (compassionately)
- **After:** Realistic vision of progress (not "cured")
- **Bridge:** Professional support as the path

**Example:**

```
[BEFORE]
Right now, anxiety might feel like a constant companion—
making simple tasks exhausting and stealing your peace of mind.

[AFTER]
Therapy can help you build a different relationship with anxiety.
Not making it disappear, but learning to respond differently,
so it no longer controls your day.

[BRIDGE]
As a CRPO registered psychotherapist specializing in ACT,
I help Ontarians develop practical skills for managing anxiety.
Same-week virtual appointments available.

[CTA]
Book Your Consultation →
```

---

## CTA Button Copy

### High-Converting Therapy CTAs

**Tested Effective (Low Friction):**
| CTA | Why It Works |
|-----|--------------|
| "Book a Free Consultation" | Low risk, no commitment |
| "Schedule Your First Session" | Clear, action-oriented |
| "Start Your Journey" | Positive, forward-looking |
| "Get Started Today" | Simple, immediate |
| "Request an Appointment" | Low pressure |

**Avoid (Too Pushy for Therapy):**
| CTA | Problem |
|-----|---------|
| "Fix Your Anxiety Now!" | Promises outcome |
| "Don't Wait Another Day!" | High pressure |
| "Transform Your Life" | Overpromises |
| "Get Help Before It's Too Late" | Fear-based |
| "Buy Now" | Transactional, not relational |

### Differentiated CTAs for NextStep

**Highlighting Unique Value:**
```
✅ "Book Same-Week Appointment"
✅ "Schedule a Virtual Session"
✅ "Find Evening/Weekend Times"
✅ "Check Insurance Coverage"
```

---

## Hero Section Optimization

### Anatomy of High-Converting Therapy Hero

```
┌─────────────────────────────────────────────────────────────┐
│                                                             │
│  [Subhead: Location/Service Context]                        │
│  Ontario Virtual Therapy                                    │
│                                                             │
│  [H1: Benefit-Focused Headline]                             │
│  Find Relief from Anxiety with                              │
│  Same-Week Virtual Therapy                                  │
│                                                             │
│  [Supporting Text: 1-2 sentences max]                       │
│  CRPO registered psychotherapist specializing in ACT.       │
│  Evening and weekend appointments available.                │
│                                                             │
│  [Primary CTA]              [Secondary CTA]                 │
│  Book Consultation          Learn More                      │
│                                                             │
│  [Trust Signals]                                            │
│  ✓ CRPO #10979  ✓ Same-Week Availability  ✓ Secure Virtual │
│                                                             │
└─────────────────────────────────────────────────────────────┘
```

### Hero Copy Formula

```
[Context] + [Benefit-Focused Headline] + [Credential/Differentiator] + [CTA]
```

**Examples:**

**Anxiety Page:**
```
Ontario Virtual Therapy

Break Free from the Cycle of Anxious Thoughts
Evidence-based therapy with same-week appointments.

CRPO registered psychotherapist (RP #10979) specializing
in Acceptance and Commitment Therapy for anxiety.

[Book Consultation]  [Learn About ACT]
```

**Depression Page:**
```
Virtual Therapy Across Ontario

You Don't Have to Face Depression Alone
Compassionate, evidence-based support when you need it.

Same-week virtual appointments with evening and
weekend availability.

[Schedule First Session]  [What to Expect]
```

---

## A/B Test Variations

### Generating Test Variations

For each CTA or headline, create 3-5 variations:

**Control (Current):**
```
Book Your Appointment
```

**Variation A (Benefit Focus):**
```
Start Feeling Better Today
```

**Variation B (Urgency - Ethical):**
```
Same-Week Appointments Available
```

**Variation C (Friction Reduction):**
```
Book a Free 15-Min Consultation
```

**Variation D (Value Prop):**
```
Get Professional Support Now
```

### Test Recommendations

| Element | Test Duration | Traffic Needed |
|---------|---------------|----------------|
| CTA Button Text | 2-4 weeks | 200+ clicks |
| Hero Headline | 2-4 weeks | 500+ views |
| Page Layout | 4-6 weeks | 1000+ views |

---

## Conversion Scoring Algorithm

**Score each CTA/copy element (0-100):**

```
Conversion Score =
  Clarity (0-25) +
  Trust Signals (0-25) +
  Emotional Resonance (0-20) +
  Friction Reduction (0-15) +
  CRPO Compliance (0-15)
```

**Scoring Rubric:**

| Element | 0-5 | 6-15 | 16-25 |
|---------|-----|------|-------|
| **Clarity** | Vague, confusing | Clear but generic | Crystal clear, specific |
| **Trust Signals** | None | Some credentials | CRPO + differentiators |
| **Emotional Resonance** | Cold/clinical | Warm | Deeply empathetic |
| **Friction Reduction** | Barriers remain | Some addressed | All concerns addressed |
| **CRPO Compliance** | Violations | Minor issues | Fully compliant |

**Score Interpretation:**
| Score | Grade | Action |
|-------|-------|--------|
| 85-100 | A | Deploy |
| 70-84 | B | Minor tweaks |
| 55-69 | C | Significant revision |
| Below 55 | D | Rewrite completely |

---

## CRPO Compliance for Conversion Copy

### Prohibited Language

**Never Use:**
- "Best therapist in Ontario"
- "Guaranteed results"
- "Cure your anxiety/depression"
- "100% success rate"
- "As seen in..." (testimonials)
- "Top-rated therapist"
- "Award-winning" (without verifiable proof)

### Safe High-Converting Language

**Use These Patterns:**
- "Evidence-based approach"
- "Professional support"
- "Same-week availability"
- "CRPO registered (#10979)"
- "Virtual sessions across Ontario"
- "Evening and weekend appointments"
- "Insurance receipts provided"

### Trust Signal Display

**Required near CTAs:**
```
✓ CRPO Registered (RP #10979)
✓ Same-Week Appointments
✓ Secure, Private Sessions
✓ Insurance Receipts Provided
```

---

## Complete CTA Box Template

```html
<div class="cta-box">
  <h3>Ready to Take the First Step?</h3>
  <p>
    Getting support doesn't have to be complicated.
    Book a same-week virtual appointment with a
    CRPO registered psychotherapist.
  </p>
  <ul class="trust-signals">
    <li>✓ CRPO #10979</li>
    <li>✓ Same-Week Availability</li>
    <li>✓ Evening & Weekend Options</li>
  </ul>
  <a href="/book" class="btn btn-primary">
    Book Your Consultation
  </a>
  <p class="secondary-action">
    <a href="/faq">Have questions? Read our FAQ</a>
  </p>
</div>
```

---

## Optimization Checklist

### Before Finalizing Any CTA:

**Copy Quality:**
- [ ] Clear action indicated
- [ ] Benefit to user obvious
- [ ] Empathetic tone (not clinical or salesy)
- [ ] Appropriate length (2-5 words for buttons)
- [ ] Active voice used

**Trust Building:**
- [ ] CRPO credentials nearby
- [ ] Differentiators mentioned (same-week, virtual)
- [ ] No pressure language
- [ ] Secondary action available (for hesitant visitors)

**CRPO Compliance:**
- [ ] No testimonial language
- [ ] No outcome guarantees
- [ ] No superlatives
- [ ] Factual claims only
- [ ] Credentials properly displayed

**Technical:**
- [ ] Button visible above fold
- [ ] Mobile-friendly tap target
- [ ] High contrast colors
- [ ] Links working

---

## Sources

**Conversion Optimization:**
- [Mental Health CRO](https://leadtorecovery.com/mental-health/cro/)
- [Therapist Website Conversions](https://www.rachelannreid.com/blogarchive/therapists-guide-website-conversions)
- [Behavioral Health Conversion](https://contentjourney.com/boosting-your-behavioral-health-conversion-rate/)

**Copywriting Frameworks:**
- [AIDA vs PAS Performance](https://www.anyword.com/blog/do-aida-and-pas-really-work-we-put-them-to-the-test-using-anywords-performance-prediction-feature/)
- [Copywriting Frameworks 2024](https://thecopybrothers.com/blog/copywriting-frameworks/)

**CRPO Compliance:**
- [CRPO Advertising Standards](https://crpo.ca/practice-standards/business-practices/advertising/)
