---
name: Copywriter
slug: copywriter
description: Craft persuasive marketing copy that drives conversions and engagement
category: writing
complexity: simple
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "write copy"
  - "marketing copy"
  - "ad copy"
  - "sales copy"
  - "landing page copy"
tags:
  - copywriting
  - marketing
  - advertising
  - conversion-optimization
---

# Copywriter

Create compelling marketing copy that captures attention, builds desire, and drives action. This skill helps you craft persuasive messages across all marketing channels—from ad headlines to landing pages, email campaigns to social media posts.

Whether you're launching products, promoting services, or building brand awareness, this skill delivers copy that resonates with your target audience and motivates them to take action. It applies proven copywriting frameworks, psychological triggers, and conversion principles to maximize impact.

Perfect for marketers, entrepreneurs, agencies, and businesses who need high-converting copy that sells without sounding salesy.

## Core Workflows

### Workflow 1: Landing Page Copy
1. **Audience Research** - Identify target customer pain points and desires
2. **Value Proposition** - Craft clear, compelling unique selling proposition
3. **Headline Creation** - Write attention-grabbing headline with subheadline
4. **Feature-Benefit Translation** - Convert features into customer benefits
5. **Social Proof Integration** - Add testimonials, stats, trust signals
6. **CTA Optimization** - Create irresistible call-to-action copy
7. **Objection Handling** - Address concerns and remove friction

### Workflow 2: Ad Campaign Copy
1. **Platform Selection** - Tailor copy for Google Ads, Facebook, LinkedIn, etc.
2. **Hook Development** - Create scroll-stopping opening lines
3. **Message Variants** - Write 5-10 versions for A/B testing
4. **Character Optimization** - Work within platform character limits
5. **Audience Segmentation** - Customize copy for different customer segments
6. **CTA Testing** - Create multiple call-to-action variations
7. **Performance Prediction** - Estimate which variants will perform best

### Workflow 3: Email Sequence
1. **Sequence Planning** - Map out email series flow and timing
2. **Subject Line Creation** - Write compelling, open-worthy subject lines
3. **Preview Text** - Optimize the first sentence for email previews
4. **Story Arc** - Build narrative across multiple emails
5. **Value Delivery** - Balance education with promotion
6. **Link Placement** - Strategic CTA positioning throughout
7. **Re-engagement** - Create follow-up for non-openers

### Workflow 4: Product Launch Copy
1. **Pre-Launch Teaser** - Build anticipation with mystery and exclusivity
2. **Launch Announcement** - Create big reveal messaging
3. **Benefit Stacking** - Highlight multiple value propositions
4. **Urgency Creation** - Add time-sensitive elements authentically
5. **Cross-Channel Consistency** - Align messaging across all platforms
6. **Post-Launch Follow-Up** - Keep momentum with results and updates

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Write headline | "Create headlines for [product/service]" |
| Landing page copy | "Write landing page for [offer]" |
| Email copy | "Write marketing email about [topic]" |
| Ad copy | "Create Facebook ad for [product]" |
| Product description | "Write product copy for [item]" |
| Social media post | "Create social copy for [announcement]" |
| Value proposition | "Craft value prop for [business]" |
| CTA variations | "Generate CTAs for [goal]" |

## Best Practices

- **Lead with benefits** - Features tell, benefits sell
- **Know your audience** - Write to one specific person, not "everyone"
- **Use power words** - Incorporate emotion-triggering language strategically
- **Create curiosity gaps** - Make them want to know more
- **Be specific** - "Increase revenue by 34%" beats "grow your business"
- **Tell stories** - Narratives are more persuasive than facts alone
- **Match awareness levels** - Adjust copy to where customer is in journey
- **Test constantly** - Always have A/B tests running
- **Remove friction** - Every word should move reader toward action
- **Prove claims** - Back up promises with data, testimonials, guarantees
- **Write conversationally** - Sound like a human, not a corporate robot
- **Use active voice** - "Get results" not "Results can be gotten"
- **Create scarcity authentically** - Limited-time offers must be genuine
- **Address objections** - Answer "why should I care?" and "what's the catch?"
- **Make it skimmable** - Bullets, bold text, short paragraphs for quick scanning
