---
name: copywriting
description: Direct response copywriting framework for landing pages, marketing copy, and product descriptions. Use when the user asks to write copy, landing pages, sales pages, or marketing content.
---

Write direct response copy like a smart friend who figured something out. Not a marketer. Not a salesperson. Someone who discovered something valuable and wants to share it.

## THE SLIDE

Seven-step structure for compelling copy:

1. **Headline** (80% of the work)
   - Make it specific, benefit-driven, curiosity-inducing
   - Test multiple versions - this is where you win or lose

2. **Problem** (quantify it)
   - Don't just state the problem - put a number on the pain
   - "Wasting 3 hours a day on manual data entry"

3. **Agitate** (make vivid)
   - Paint the picture of staying stuck
   - Make them feel the frustration they already have

4. **Credibility**
   - Why should they listen to you?
   - Keep it brief - just enough to earn attention

5. **Solution** (transform)
   - Present your solution as transformation, not features
   - Before → After, not "Product does X"

6. **Proof** (specific)
   - Concrete numbers, names, specifics
   - Social proof, case studies, results

7. **CTA** (benefit)
   - Lead with what they get, not what they do
   - "Start saving 3 hours daily" not "Sign up now"

## SO WHAT? CHAIN

Transform features into emotional resonance:

```
Feature → Functional → Financial → Emotional
```

**Always write from the Emotional end.**

Example:
- Feature: "AI-powered automation"
- Functional: "Handles repetitive tasks automatically"
- Financial: "Saves 15 hours per week"
- Emotional: "Finally have time for work that matters"

Write the emotional benefit first, then work backwards to explain how.

## RHYTHM

```
Short. Then breathe. Land it.
```

- Vary sentence length dramatically
- Use fragments for punch
- Let important points stand alone
- Don't be afraid of one-word sentences

## SPECIFICITY

Replace vague with concrete:

| Vague | Specific |
|-------|----------|
| "lots of money" | "$47,329" |
| "many users" | "2,894 makers" |
| "fast results" | "results in 14 days" |
| "save time" | "save 3.5 hours weekly" |
| "trusted by companies" | "used by Stripe, Notion, Linear" |

Specificity builds trust. Vague claims feel like marketing. Specific claims feel like truth.

## Anti-Patterns

NEVER write copy that:
- Leads with features instead of benefits
- Uses corporate buzzwords ("leverage", "synergy", "solution")
- Makes vague claims without specifics
- Forgets the human on the other side
- Sounds like every other landing page
- Uses fake urgency ("Only 3 spots left!")
- Over-promises with superlatives ("The BEST", "Revolutionary")

## Voice

- Write like you talk
- Use "you" more than "we"
- Be conversational, not formal
- Have opinions - wishy-washy copy doesn't convert
- Be confident without being arrogant
