---
name: copywriting-content
description: Write legally defensible content for LeadFraud.org. Use this skill when creating or editing any public-facing content to ensure it is protected against defamation claims while remaining impactful.
license: Internal use only
---

This skill ensures all LeadFraud.org content is legally defensible against defamation, libel, and tortious interference claims while remaining impactful and credible. Apply these principles to every piece of content.

The user provides content to write or review: headlines, body copy, evidence sections, vendor mentions, or any public-facing text.

## Legal Framework

LeadFraud.org operates in a legally sensitive space. Every claim must withstand potential legal scrutiny. The goal is to be **accurate, impactful, and legally bulletproof**.

### The Four Elements of Defamation (What They Must Prove)

For a defamation suit to succeed, the plaintiff must prove ALL of these:
1. **False statement of fact** — Opinion and verifiable facts are protected
2. **Published to third parties** — Cannot be avoided on a public website
3. **Fault (negligence or malice)** — Good faith research defeats this
4. **Actual damages** — Must prove specific, quantifiable harm

Our content strategy systematically defeats elements 1, 3, and 4.

## Core Principles

### 1. Facts Over Accusations

Transform accusations into verifiable observations.

| ❌ NEVER WRITE | ✅ WRITE INSTEAD |
|----------------|------------------|
| "They commit fraud" | "Public reviews describe experiences consistent with..." |
| "Their leads are fake" | "Leads frequently report no recall of opt-in" |
| "This vendor scams buyers" | "G2 reviews describe this pattern..." |
| "They lie about consent" | "The described consent mechanism raises questions about..." |
| "Fraudulent company" | "Practices that warrant buyer scrutiny" |

### 2. Attribution Over Assertion

Every factual claim must be attributed to a verifiable source.

**Source Hierarchy (strongest to weakest):**
1. **Direct quotes** from public platforms (G2, Reddit, LinkedIn)
2. **Third-party data** from verifiable tools (SimilarWeb, Ahrefs, SEMrush)
3. **Public filings** (SEC, court records, regulatory actions)
4. **Multiple corroborating accounts** (pattern documentation)
5. **Single firsthand accounts** (lowest weight, requires verification note)

**Attribution Format:**
```
"[Direct quote from source]"
— [Name or Verified User descriptor], [Platform], [Date]
```

### 3. Questions Over Statements

Rhetorical questions invite reader judgment without making claims.

| ❌ ACCUSATION | ✅ QUESTION |
|--------------|------------|
| "They can't generate enough traffic for these leads" | "Can a site with 500 monthly visitors generate 5,000 leads per month?" |
| "The consent is fake" | "What does this consent mechanism actually cover?" |
| "This is a scam" | "Does this match what you were promised?" |

### 4. Pattern Documentation Over Individual Targeting

Frame issues as **industry patterns** observed across multiple sources, not attacks on specific entities.

✅ **Good framing:**
> "A pattern observed across multiple content syndication vendors includes leads who report no recall of opt-in, content sites with minimal organic traffic, and batch-pattern timestamps in form submissions."

❌ **Risky framing:**
> "XYZ Company is committing fraud."

### 5. Invitation to Correct

Every page mentioning specific entities should include or reference:

> "We invite any vendor mentioned to provide corrections or formal responses. All vendor statements will be published in full, unedited. Contact: response@leadfraud.org"

This demonstrates **good faith** and defeats malice claims.

## Content Templates

### Vendor Mention Template

```
[Vendor Name] operates a network of content sites including [list sites].

**Public data suggests:**
- [Site] shows [X] monthly visitors according to SimilarWeb (as of [date])
- G2 reviewers have reported [specific pattern] (see Evidence section)

**Questions for buyers:**
- Does the claimed lead volume align with observable traffic?
- Can the vendor provide timestamped form submission logs?
```

### Evidence Citation Template

```
"[Direct quote, verbatim]"
— [Attribution: Verified User in [Industry], [Platform], [Date]]

Source: [Link to public source if available]
```

### Pattern Description Template

```
Across [N] reviews on [Platform], buyers describe a consistent pattern:
1. [Pattern element with percentage if available]
2. [Pattern element]
3. [Pattern element]

This pattern raises questions about [specific concern].
```

---

## Absolute Prohibitions

NEVER write content that:

1. **Calls anyone a criminal** without a conviction
   - ❌ "fraud" "scam" "criminal" "illegal" (as direct accusations)
   - ✅ "practices that warrant scrutiny" "patterns that raise questions"

2. **Claims certainty about intent**
   - ❌ "They intentionally deceive buyers"
   - ✅ "The outcome—whether intentional or not—is that buyers report..."

3. **Makes unverifiable claims**
   - ❌ "They made $50M from fake leads last year"
   - ✅ "Public estimates suggest the industry exceeds $1.6B annually"

4. **Uses hyperbolic language**
   - ❌ "The biggest scam in B2B history"
   - ✅ "A significant and underexamined industry practice"

5. **Implies illegal activity without proof**
   - ❌ "This violates GDPR"
   - ✅ "This consent mechanism may not meet GDPR's explicit consent standard"


## 🚨 Complete Prohibited Terms List

> [!CAUTION]
> **THIS IS THE MOST IMPORTANT SECTION OF THIS SKILL.**
> Failure to follow this list will expose LeadFraud.org to legal liability.
> When auditing or writing copy, you MUST search for ALL prohibited terms across the ENTIRE codebase, including: metadata (index.html, og: tags, twitter: tags), navigation, CTAs, button labels, and tool names.
> **DO NOT SKIP THIS. DO NOT ASSUME COPY IS CLEAN.**

### ❌ DON'T USE (All of These Are Prohibited)

| Term | Why | ✅ USE This Instead |
|------|-----|---------------------|
| `fraud` | Direct criminal accusation | **Pipeline Fog™**, questionable practices, lead laundering |
| `fraudulent` | Direct criminal accusation | **unverifiable**, questionable, consent-deficient |
| `scam` | Direct criminal accusation | **the $1.6B lead problem**, the billion-dollar question |
| `scammer` | Direct criminal accusation | vendor, operator, practitioner |
| `fake` | Implies intentional fabrication | **phantom leads**, ghost contacts, never-requested |
| `illegal` | Legal conclusion without proof | potentially non-compliant, raises legal questions |
| `criminal` | Legal conclusion without proof | questionable, concerning |
| `lie` / `lying` | Claims intent to deceive | misrepresents, inaccurate, does not match |
| `steal` / `stolen` | Criminal accusation | misappropriated, used without clear consent |
| `cheat` | Criminal/ethical accusation | underdelivers, does not match promises |
| `exposing` / `expose` | Implies hidden wrongdoing | **investigating**, **documenting**, revealing patterns in |
| `Exposé` | Sensational | **Report**, **Investigation** |
| `fabricated` | Implies intentional creation of false data | **manufactured provenance**, synthetic consent |
| `deceive` / `deception` | Claims intent | creates confusion, results in misunderstanding |
| `corrupt` / `corruption` | Criminal/ethical accusation | problematic, concerning practices |
| `exploit` | Negative intent | takes advantage of, leverages |
| `victim` | Legal implications | affected buyer, impacted organization |
| `attack` | Violent language | critique, document, investigate |
| `whistleblower` | We don't apply this label | source, insider, former employee |

### ✅ USE (Safe and Sharp)

| Term | Notes |
|------|-------|
| `investigation` | ✅ "Independent investigation" is fine |
| `evidence` | ✅ "Publicly available evidence" is fine |
| `Pipeline Fog™` | ✅ Our branded term — use liberally |
| `Consent Theater` | ✅ Our branded term |
| `Content Shell Sites` | ✅ Our branded term |
| `Email Spray` | ✅ Our branded term |
| `phantom leads` | ✅ Sharp, not accusatory |
| `ghost contacts` | ✅ Sharp, not accusatory |
| `lead laundering` | ✅ Descriptive of the process |
| `manufactured provenance` | ✅ Technical, implies process without accusing |
| `questionable` | ✅ Safe qualifier |
| `unverifiable` | ✅ Factual statement |
| `document` / `documenting` | ✅ Neutral action |
| `demand accountability` | ✅ Sharp CTA |

### Examples of Sharp Rewrites

| ❌ Legally Risky | ✅ Sharp & Safe |
|-----------------|----------------|
| "Exposing the $1.6B scam" | **"The $1.6B Lead Problem Nobody Talks About"** |
| "Fraud Calculator" | **"Pipeline Fog™ Calculator"** |
| "Fake Leads" | **"Phantom Leads"** or **"Ghost Contacts"** |
| "Help expose the fraud" | **"Demand accountability"** or **"Document the pattern"** |
| "fraudulent practices" | **"questionable lead practices"** or **"consent-deficient leads"** |
| "fabricated leads" | **"leads of manufactured provenance"** |

---

## 🔍 Agent Audit Methodology

> **WHY TERMS GET MISSED:** Agents often focus on body copy and miss metadata, component names, navigation labels, and UI text. This section prevents that.

### Mandatory Search Locations

When auditing copywriting, you MUST check ALL of these:

1. **index.html** — title, meta description, og: tags, twitter: tags
2. **All .tsx page files** — body copy, headers, subheaders
3. **Layout.tsx** — navigation labels, footer text, CTAs
4. **Component files** — button text, labels, tooltips
5. **package.json** — description field (if present)
6. **robots.txt / sitemap.xml** — if they exist

### Grep Commands to Run

Always run these searches when auditing:

```bash
# Prohibited terms (MUST fix all matches)
grep -riE "fraud|scam|fake|illegal|criminal|lie|lying|steal|stolen|cheat" src/ index.html

# Additional prohibited terms (MUST fix all matches)
grep -riE "expos(e|ing)|fabricat|deceiv|corrupt|exploit|victim|attack" src/ index.html
```

### Common Oversight Points

Agents frequently miss these locations:

| Location | What to Check |
|----------|---------------|
| Page `<title>` | Often contains "exposing" or "scam" |
| Meta descriptions | SEO text may use risky terms |
| CTA buttons | "Read the Exposé", "Expose fraud" |
| Tool names | "Fraud Calculator", "Scam Detector" |
| Completion messages | "You've helped expose fraud!" |

### Audit Checklist

Before completing a copywriting audit, verify:

- [ ] Searched ALL prohibited terms across entire codebase
- [ ] Checked index.html metadata (title, og:, twitter:)
- [ ] Checked navigation and footer text
- [ ] Checked CTA button labels
- [ ] Checked tool/calculator names
- [ ] Verified each match — is it a quote? definition? or risky usage?
- [ ] Provided sharp alternatives for each issue found

---

## Disclaimers

Include appropriate disclaimers based on content type:

### Standard Page Disclaimer
> LeadFraud.org presents publicly available data for educational purposes. We make no allegations of wrongdoing. Readers should conduct their own due diligence.

### Evidence Page Disclaimer
> All reviews quoted are from publicly available sources. We present this data for educational purposes and make no allegations of wrongdoing.

### Vendor Directory Disclaimer
> Traffic data should be verified using third-party tools. We present publicly available data for educational purposes.

## Pre-Publication Checklist

Before publishing any content, verify:

- [ ] Every factual claim has a verifiable source
- [ ] No direct accusations of fraud, scam, or criminal behavior
- [ ] No prohibited terms used (check the list above)
- [ ] Vendor response invitation is referenced or included
- [ ] Appropriate disclaimer is present
- [ ] Questions are used instead of accusations where possible
- [ ] Content focuses on patterns, not individual targeting
- [ ] All quotes are verbatim with proper attribution

## Examples

### ❌ Before (Legally Risky)

> DemandScience is running a massive fraud operation. They sell fake leads that never opted in. Their "content sites" are shells with no traffic. Buyers are getting scammed out of millions.

### ✅ After (Legally Safe, Still Impactful)

> G2 reviews of DemandScience describe a pattern: leads who report no recall of opting in, difficulty obtaining proof of form submissions, and engagement rates near zero.
>
> "We asked for proof that the contacts actually downloaded our assets. They could not."
> — Verified User in Marketing and Advertising, G2, 12/16/2022
>
> SimilarWeb data for DemandScience-associated content sites shows [X] monthly visitors. Buyers should verify whether this traffic supports claimed lead volumes.
>
> *We invite DemandScience to provide a response or correction. Contact: response@leadfraud.org*

---

## Key Terminology

Use these terms consistently across all content.

### Coined Terms (LeadFraud.org Originals)

| Term | Definition | Usage |
|------|------------|-------|
| **Pipeline Fog™** | Leads of questionable provenance that obscure true pipeline health | "This creates Pipeline Fog in your CRM" |
| **Consent Theater** | The appearance of opt-in compliance without genuine intent | "The consent mechanism appears to be Consent Theater" |
| **Content Shell Sites** | Low-traffic websites that exist to demonstrate "publisher network" | "Traffic analysis suggests these are Content Shell Sites" |
| **Email Spray** | Mass cold email tactics disguised as content distribution | "The distribution method resembles Email Spray" |

### Industry Terms (Define for Readers)

Always define these when first used on a page:

- **Content Syndication**: Distribution of content through third-party channels
- **MQL (Marketing Qualified Lead)**: Lead that meets marketing criteria for sales handoff
- **Lead Fulfillment**: Delivering promised lead volume to buyers under contract
- **Whitepaper**: Long-form gated content used for lead generation
- **ICP (Ideal Customer Profile)**: Target buyer characteristics and firmographics
- **CPL (Cost Per Lead)**: Price paid for each lead delivered

---

## Writing Style

### Tone

- **Authoritative** — Like a financial investigator or serious journalist
- **Evidence-based** — Every claim backed by data
- **Sharp but measured** — Brutal truths, professional delivery
- **Buyer-focused** — Empowering affected buyers, not attacking vendors

### Voice Inspiration

| Reference | What to Emulate |
|-----------|-----------------|
| **Michael Burry** | Contrarian, data-driven, willing to be unpopular |
| **Hindenburg Research** | Devastating findings, meticulous evidence |
| **ProPublica** | Public interest journalism, accessible but rigorous |

### Content Quality Standards

Every piece of content should:
1. Cite specific evidence (screenshots, data, quotes)
2. Explain WHY this matters (not just what)
3. Provide actionable next steps for readers
4. Avoid sensationalism while remaining compelling
5. Be scannable (headers, bullets, callouts)

---

Remember: The goal is to present **accurate, verifiable information** in a way that helps buyers make informed decisions. We are **researchers documenting patterns**, not accusers. This framing is both ethically sound and legally defensible.

## Social Media

Refer to the social media resources whenever asked to create social media content:

| Resource | Purpose | Location |
|----------|---------|----------|
| **Social Media** | Legal safety, writing style, most recent posts | `.claude/skills/copywriting-content/socialmedia.md` |
