---
name: social-media-copywriting
description: Create LinkedIn and X posts that match the author's voice and maintain continuity with past content. Use this skill when asked to draft social media content.
---

# Social Media Copywriting Skill

This skill guides creating LinkedIn and X posts that maintain tone, style, and thematic continuity with past content.

---

## Before Writing

### 1. Check for Recent Posts

Before drafting, ensure the posts resource is up to date:

```bash
python3 .claude/skills/copywriting-content/resources/tools/fetch_posts.py
```

### 2. Review Past Posts

Read the resource file to understand voice and themes:
`resources/linkedin-posts.md`

---

## Voice Analysis

Analyze past posts for:

| Element | What to Look For |
|---------|-----------------|
| **Tone** | Sharp, direct, evidence-backed, skeptical of vendor claims |
| **Structure** | Short paragraphs, line breaks for impact, rhetorical questions |
| **Themes** | Lead fraud, content syndication, pipeline fog, demand gen |
| **Hooks** | Provocative opening statements or questions |
| **Endings** | Questions for engagement, calls to action, hashtags |

---

## Post Structure

Follow this pattern based on past posts:

```
[Hook - provocative statement or question]

[2-3 short paragraphs expanding the point]

[Specific evidence, example, or list]

[Question for engagement or call to action]

[Relevant hashtags]
```

---

## Writing Guidelines

### Do
- Use short sentences and line breaks
- Back claims with evidence or examples
- Ask questions that provoke thought
- Maintain the skeptical, buyer-focused perspective
- Reference LeadFraud.org when relevant

### Don't
- Use fluff or corporate speak
- Make direct accusations (follow legal safety from SKILL.md)
- Write long unbroken paragraphs
- Sound promotional or salesy

---

## Platform Notes

### LinkedIn
- Longer form acceptable (see past posts)
- Use hashtags: #DemandGeneration #ContentSyndication #B2BMarketing #LeadGen
- Include line breaks for readability

### X (Twitter)
- Condense to <280 characters or thread format
- More punchy, fewer hashtags
- Same tone, tighter delivery

---

## Keeping Resources Updated

When you notice new posts that aren't in `resources/linkedin-posts.md`:
1. Run the fetch script to update
2. Only include posts after December 2025
3. Ensure full content is captured, not truncated

---

## Legal Safety

All posts must follow the legal guidelines in `SKILL.md`:
- No direct fraud accusations
- Use questions over statements
- Attribute claims to sources when possible
