# [패턴명/알고리즘명]

> 이 문서는 [패턴명]에 대한 학습 자료입니다.

## 개념 설명

### 정의
[패턴/알고리즘이 무엇인지 간단명료하게 설명]

### 언제 사용하는가?
[이 패턴/알고리즘을 사용하기 적합한 상황과 문제 유형]
- 상황 1: ...
- 상황 2: ...
- 상황 3: ...

### 핵심 아이디어
[문제를 해결하는 핵심 개념과 접근 방식]

## 동작 원리

### 단계별 설명

1. **[단계 1]**
   - 설명...

2. **[단계 2]**
   - 설명...

3. **[단계 3]**
   - 설명...

### 시각화 예시

```
[간단한 텍스트 다이어그램이나 예시]
예: 배열 [1, 2, 3, 4, 5]에서 크기 3인 윈도우
     [1, 2, 3] 4, 5
      1 [2, 3, 4] 5
      1, 2 [3, 4, 5]
```

## 예제 코드 (Python)

### 기본 구현

```python
def pattern_example(arr):
    """
    [패턴명] 기본 구현

    Args:
        arr: 입력 배열

    Returns:
        결과값
    """
    # 초기화
    # [필요한 변수 초기화 설명]

    # 메인 로직
    # [핵심 알고리즘 구현 설명]

    # 결과 반환
    pass
```

### 실전 예제

```python
def real_problem_solution(input_data):
    """
    실전 문제 적용 예시

    문제: [구체적인 문제 설명]
    """
    # 구현...
    pass
```

### 코드 설명

- **변수 역할**: ...
- **핵심 로직**: ...
- **엣지 케이스 처리**: ...

## 시간/공간 복잡도

### 시간 복잡도
- **평균**: O(...)
- **최악**: O(...)
- **최선**: O(...)

**분석**:
[왜 이런 복잡도가 나오는지 단계별로 설명]

### 공간 복잡도
- **복잡도**: O(...)

**분석**:
[사용하는 추가 메모리와 그 이유]

### 최적화 포인트
- 포인트 1: ...
- 포인트 2: ...
- 포인트 3: ...

## 관련 문제 추천

### 프로그래머스
1. **[문제명]** (Level X)
   - 링크: https://school.programmers.co.kr/learn/courses/30/lessons/XXXXX
   - 난이도: ⭐⭐⭐
   - 핵심: [이 패턴을 어떻게 적용하는지]

2. **[문제명]** (Level X)
   - 링크: ...
   - 난이도: ...
   - 핵심: ...

### 백준
1. **[문제 번호] - [문제명]**
   - 링크: https://www.acmicpc.net/problem/XXXX
   - 난이도: [실버/골드 X]
   - 핵심: ...

2. **[문제 번호] - [문제명]**
   - 링크: ...
   - 난이도: ...
   - 핵심: ...

### 학습 순서 추천
1. [쉬운 문제] → 기본 개념 익히기
2. [중간 문제] → 응용력 키우기
3. [어려운 문제] → 변형 패턴 학습

## 학습 팁

### 주의사항
⚠️ **흔한 실수**
- 실수 1: ...
- 실수 2: ...
- 실수 3: ...

### 핵심 포인트
✅ **반드시 기억할 것**
- 포인트 1: ...
- 포인트 2: ...
- 포인트 3: ...

### 변형 패턴
🔄 **응용 가능한 형태**
- 변형 1: ...
- 변형 2: ...
- 변형 3: ...

### 디버깅 팁
🐛 **막힐 때 체크리스트**
- [ ] 초기값 설정이 올바른가?
- [ ] 경계 조건을 처리했는가?
- [ ] 인덱스 범위가 올바른가?
- [ ] [패턴 특유의 체크 사항]

## 관련 개념

### 연관 알고리즘/패턴
- **[관련 패턴 1]**: 어떤 관계인지...
- **[관련 패턴 2]**: 어떤 관계인지...

### 추가 학습 자료
- [유용한 블로그/문서 링크]
- [시각화 도구 링크]
- [관련 영상 자료]

---

**작성일**: YYYY-MM-DD
**마지막 수정**: YYYY-MM-DD
