# [자료구조명]

> 이 문서는 [자료구조]의 구현 상세 설명 학습 자료입니다.

## 개념 설명

### 정의
[자료구조가 무엇인지 간단명료하게 설명]

### 왜 필요한가?
[이 자료구조가 해결하는 문제와 장점]
- 장점 1: ...
- 장점 2: ...
- 장점 3: ...

### 언제 사용하는가?
[사용 시나리오]
- 상황 1: ...
- 상황 2: ...
- 상황 3: ...

## 내부 구조

### 구성 요소

```python
class DataStructure:
    """자료구조의 주요 구성 요소"""

    def __init__(self):
        self.component1 = ...  # 역할: ...
        self.component2 = ...  # 역할: ...
        self.component3 = ...  # 역할: ...
```

### 불변 조건 (Invariants)

자료구조가 항상 유지해야 하는 속성:
1. **불변 조건 1**: [설명]
2. **불변 조건 2**: [설명]
3. **불변 조건 3**: [설명]

## 주요 연산 구현

### 1. 초기화 (Initialization)

```python
class DataStructure:
    def __init__(self, capacity=None):
        """
        자료구조 초기화

        Args:
            capacity: 초기 용량 (선택사항)

        시간 복잡도: O(...)
        공간 복잡도: O(...)
        """
        # 내부 저장소 초기화
        self._data = []  # 또는 다른 구조

        # 메타 정보
        self._size = 0

        # 기타 필요한 변수
        pass

    def _initialize_helper(self):
        """초기화 헬퍼 메서드"""
        pass
```

### 2. 삽입 (Insert/Add)

```python
def insert(self, item):
    """
    원소 삽입

    Args:
        item: 삽입할 원소

    Raises:
        ValueError: [에러 조건]

    시간 복잡도: O(...)
    공간 복잡도: O(...)

    구현 세부사항:
    1. [단계 1 설명]
    2. [단계 2 설명]
    3. [단계 3 설명]
    """
    # 1. 유효성 검사
    if [조건]:
        raise ValueError("...")

    # 2. 삽입 위치 찾기
    position = self._find_position(item)

    # 3. 실제 삽입
    self._insert_at(position, item)

    # 4. 불변 조건 유지
    self._maintain_invariants()

    # 5. 크기 업데이트
    self._size += 1

def _find_position(self, item):
    """삽입 위치 찾기 헬퍼"""
    pass

def _insert_at(self, position, item):
    """실제 삽입 수행 헬퍼"""
    pass

def _maintain_invariants(self):
    """불변 조건 유지 헬퍼"""
    pass
```

### 3. 삭제 (Delete/Remove)

```python
def remove(self, item):
    """
    원소 삭제

    Args:
        item: 삭제할 원소

    Returns:
        삭제된 원소

    Raises:
        KeyError: 원소가 없을 때

    시간 복잡도: O(...)
    공간 복잡도: O(...)
    """
    # 1. 원소 찾기
    position = self._find(item)
    if position == -1:
        raise KeyError(f"{item} not found")

    # 2. 삭제 수행
    removed = self._remove_at(position)

    # 3. 불변 조건 복구
    self._maintain_invariants()

    # 4. 크기 업데이트
    self._size -= 1

    return removed

def _find(self, item):
    """원소 찾기"""
    pass

def _remove_at(self, position):
    """실제 삭제 수행"""
    pass
```

### 4. 조회 (Search/Get)

```python
def get(self, key):
    """
    원소 조회

    Args:
        key: 찾을 키

    Returns:
        해당하는 값

    Raises:
        KeyError: 키가 없을 때

    시간 복잡도: O(...)
    """
    position = self._find(key)
    if position == -1:
        raise KeyError(f"{key} not found")

    return self._data[position]

def contains(self, item):
    """원소 존재 여부"""
    return self._find(item) != -1
```

### 5. 기타 유틸리티 연산

```python
def size(self):
    """크기 반환"""
    return self._size

def is_empty(self):
    """비어있는지 확인"""
    return self._size == 0

def clear(self):
    """모든 원소 제거"""
    self.__init__()

def __len__(self):
    """len() 지원"""
    return self._size

def __contains__(self, item):
    """in 연산자 지원"""
    return self.contains(item)

def __str__(self):
    """문자열 표현"""
    return f"DataStructure({self._data})"

def __repr__(self):
    """개발자용 표현"""
    return f"DataStructure(size={self._size}, data={self._data})"
```

## 완전한 구현 예제

### 기본 구현

```python
class CompleteDataStructure:
    """
    [자료구조] 완전한 구현

    불변 조건:
    - [조건 1]
    - [조건 2]

    시간 복잡도:
    - 삽입: O(...)
    - 삭제: O(...)
    - 조회: O(...)

    공간 복잡도: O(...)
    """

    def __init__(self):
        """초기화"""
        self._data = []
        self._size = 0

    # [위의 메서드들을 모두 포함한 완전한 구현]
    pass
```

### 테스트 코드

```python
def test_data_structure():
    """자료구조 테스트"""

    # 1. 초기화 테스트
    ds = CompleteDataStructure()
    assert ds.is_empty()
    assert len(ds) == 0

    # 2. 삽입 테스트
    ds.insert(10)
    ds.insert(5)
    ds.insert(15)
    assert len(ds) == 3

    # 3. 조회 테스트
    assert ds.contains(10)
    assert not ds.contains(100)

    # 4. 삭제 테스트
    ds.remove(5)
    assert len(ds) == 2
    assert not ds.contains(5)

    # 5. 엣지 케이스 테스트
    try:
        ds.remove(999)  # 없는 원소 삭제
        assert False, "Should raise KeyError"
    except KeyError:
        pass  # 정상

    print("All tests passed! ✓")

if __name__ == "__main__":
    test_data_structure()
```

## 시간/공간 복잡도

### 연산별 복잡도 표

| 연산 | 평균 | 최악 | 설명 |
|------|------|------|------|
| 삽입 | O(...) | O(...) | ... |
| 삭제 | O(...) | O(...) | ... |
| 조회 | O(...) | O(...) | ... |
| 검색 | O(...) | O(...) | ... |

### 상세 분석

**삽입 연산**:
- 위치 찾기: O(...)
- 실제 삽입: O(...)
- 불변 조건 유지: O(...)
- **전체**: O(...)

**공간 복잡도**:
- 데이터 저장: O(n)
- 추가 메타데이터: O(...)
- **전체**: O(...)

## 최적화 기법

### 1. [최적화 기법 1]

**문제**: [현재 구현의 비효율적인 부분]

**해결**:
```python
def optimized_method(self):
    """최적화된 구현"""
    # [개선된 코드]
    pass
```

**효과**: O(...) → O(...)

### 2. [최적화 기법 2]

**문제**: ...
**해결**: ...
**효과**: ...

## 변형 및 확장

### 변형 1: [변형명]

**차이점**: [기본 구현과의 차이]

```python
class VariantDataStructure(CompleteDataStructure):
    """변형 구현"""

    def __init__(self):
        super().__init__()
        # 추가 변수

    # 변형된 메서드들
    pass
```

### 변형 2: [변형명]

**차이점**: ...

## 관련 문제 추천

### 프로그래머스

1. **[문제명]** (Level X)
   - 링크: https://school.programmers.co.kr/learn/courses/30/lessons/XXXXX
   - 난이도: ⭐⭐⭐
   - **구현 포인트**: [이 자료구조의 어떤 메서드를 사용/변형하면 되는지]
   - 핵심: ...

2. **[문제명]** (Level X)
   - 링크: ...
   - 난이도: ...
   - **구현 포인트**: ...

### 백준

1. **[문제 번호] - [문제명]**
   - 링크: https://www.acmicpc.net/problem/XXXX
   - 난이도: [실버/골드 X]
   - **구현 포인트**: ...
   - 핵심: ...

## 학습 팁

### 구현 연습 방법

💻 **단계별 구현 연습**
1. 먼저 인터페이스만 정의 (메서드 시그니처)
2. 각 메서드를 하나씩 구현
3. 테스트 케이스 작성 및 검증
4. 불변 조건이 유지되는지 확인
5. 엣지 케이스 처리

### 주의사항

⚠️ **구현 시 실수하기 쉬운 부분**
- 실수 1: 불변 조건을 깨뜨리는 구현
- 실수 2: 경계 조건 (비어있을 때, 가득 찼을 때) 미처리
- 실수 3: 메모리 누수 또는 중복 참조
- 실수 4: 삽입/삭제 후 크기 업데이트 누락

### 디버깅 체크리스트

🐛 **막힐 때 확인할 것**
- [ ] 불변 조건이 모든 연산 후에 유지되는가?
- [ ] 엣지 케이스를 모두 처리했는가?
- [ ] 인덱스 범위가 올바른가?
- [ ] 크기 변수가 정확하게 업데이트되는가?
- [ ] 메모리 참조가 올바른가?

### 코드 리뷰 포인트

✅ **좋은 구현의 특징**
- 각 메서드의 책임이 명확함
- 헬퍼 메서드로 복잡도를 낮춤
- 불변 조건이 명시되고 유지됨
- 엣지 케이스가 모두 처리됨
- 테스트가 포함됨

## 비교 분석

### vs [다른 자료구조]

| 특징 | [현재 자료구조] | [다른 자료구조] |
|------|----------------|----------------|
| 삽입 | O(...) | O(...) |
| 삭제 | O(...) | O(...) |
| 조회 | O(...) | O(...) |
| 공간 | O(...) | O(...) |
| **사용 시기** | [언제 유리] | [언제 유리] |

## 관련 개념

### Python 내장 자료구조와의 관계

- **list**: ...
- **dict**: ...
- **set**: ...
- **heapq**: ...
- **collections.deque**: ...

### 응용 자료구조

- **[응용 1]**: 이 자료구조를 기반으로...
- **[응용 2]**: ...

---

**작성일**: YYYY-MM-DD
**마지막 수정**: YYYY-MM-DD

**학습 방법**: 직접 타이핑하며 구현해보세요! 코드를 복사하지 말고 이해하며 작성하세요.
