# [알고리즘명/개념명]

> 이 문서는 [알고리즘/개념]에 대한 수학적 원리 중심 학습 자료입니다.

## 개념 설명

### 정의
[수학적/이론적 정의]

### 문제 상황
[어떤 문제를 해결하기 위한 것인지]

### 핵심 아이디어
[수학적 접근의 핵심 개념]

## 수학적 기초

### 필요한 선행 지식
- **개념 1**: 간단한 설명
- **개념 2**: 간단한 설명
- **개념 3**: 간단한 설명

### 표기법
- `n`: 입력 크기
- `dp[i]`: ...
- `f(n)`: ...
- 기타 사용할 변수들...

## 점화식 / 수식 유도

### 문제 분석

**목표**: [무엇을 구하려고 하는가]

**부분 문제 정의**:
```
dp[i] = [i번째 상태에서의 최적값/경우의 수]
또는
f(n) = [n에 대한 함수]
```

### 점화식 유도 과정

**Step 1: 기저 사례 (Base Case)**
```
dp[0] = [초기값]
dp[1] = [초기값]
...
```
**이유**: [왜 이 값인지 설명]

**Step 2: 재귀적 관계 찾기**

현재 상태 `dp[i]`를 이전 상태로 표현하면:

```
dp[i] = [이전 상태들의 관계식]
```

**유도 과정**:
1. `dp[i]`는 무엇을 의미하는가? → ...
2. `dp[i]`를 구하기 위해 필요한 정보는? → ...
3. 이전 상태 `dp[i-1]`, `dp[i-2]`, ... 와의 관계는? → ...

**Step 3: 최종 점화식**

```
dp[i] = {
    [base case]           if i == 0 또는 특정 조건
    [재귀 관계식]          otherwise
}
```

### 예시로 확인

**입력**: n = 5

| i | dp[i] | 계산 과정 |
|---|-------|-----------|
| 0 | ... | base case |
| 1 | ... | base case |
| 2 | ... | dp[2] = ... |
| 3 | ... | dp[3] = ... |
| 4 | ... | dp[4] = ... |
| 5 | ... | dp[5] = ... |

## 수학적 증명

### 정확성 증명 (Correctness)

**정리**: 이 알고리즘은 올바른 결과를 생성한다.

**증명**:

**1. 귀납법 기초 (Base Case)**
- n = 0 또는 n = 1일 때: ...
- 올바른 이유: ...

**2. 귀납적 가정 (Induction Hypothesis)**
- k < i에 대해 dp[k]가 올바르다고 가정

**3. 귀납적 단계 (Induction Step)**
- dp[i]가 올바름을 보이기:
  ```
  dp[i] = [점화식]
        = [가정에 의해...]
        = [결론]
  ```

**따라서** 수학적 귀납법에 의해 모든 n에 대해 올바르다. ∎

### 최적 부분 구조 (Optimal Substructure)

**증명해야 할 것**: 전체 문제의 최적해가 부분 문제의 최적해로 구성됨

**증명**:
- 전체 문제의 최적해를 S라 하자
- S를 부분 문제로 나누면 S₁, S₂, ...
- 만약 S₁이 최적이 아니라면 → [모순 유도]
- 따라서 S₁, S₂, ... 모두 최적이어야 함 ∎

## 복잡도 분석

### 시간 복잡도

**분석**:
```
총 실행 횟수 = Σ[각 단계의 연산 횟수]
             = ...
             = O(...)
```

**상세 분석**:
- 외부 루프: n번 반복
- 내부 루프: ... 번 반복
- 각 iteration 당: O(...) 연산
- **전체**: O(n × ... × ...) = O(...)

**점근적 표기법 증명**:
- 상한 (Upper Bound): O(...) 임을 보이기
  ```
  T(n) ≤ c·n² (c > 0, n > n₀)
  ```
- 하한 (Lower Bound): Ω(...) 임을 보이기
- **따라서** Θ(...) ∎

### 공간 복잡도

**분석**:
```
사용 메모리 = [배열 크기] + [추가 변수]
           = O(n) + O(1)
           = O(n)
```

**최적화 가능성**:
- 현재 공간: O(...)
- 최적화 후: O(...) (방법: ...)

## 예제 코드 (Python)

### 수학적 접근 구현

```python
def mathematical_solution(n):
    """
    수학적 점화식을 코드로 구현

    점화식: dp[i] = ...

    Args:
        n: 입력 크기

    Returns:
        dp[n]: n에 대한 최종 답

    시간 복잡도: O(...)
    공간 복잡도: O(...)
    """
    # 기저 사례
    if n == 0:
        return [base_value]

    # DP 테이블 초기화
    dp = [0] * (n + 1)
    dp[0] = [base_value_0]
    dp[1] = [base_value_1]

    # 점화식 적용
    for i in range(2, n + 1):
        # dp[i] = [점화식 구현]
        dp[i] = ... # 점화식 그대로 구현

    return dp[n]
```

### 공간 최적화 버전

```python
def optimized_solution(n):
    """
    공간 복잡도 O(n) → O(1) 최적화

    관찰: dp[i]는 dp[i-1], dp[i-2]만 사용
    따라서 전체 배열 불필요
    """
    # 이전 값들만 저장
    prev2, prev1 = [base_0], [base_1]

    for i in range(2, n + 1):
        current = ... # 점화식
        prev2, prev1 = prev1, current

    return prev1
```

## 관련 수학 개념

### 조합론 (Combinatorics)
- **경우의 수**: [관련 있다면 설명]
- **순열/조합**: [공식과 활용]

### 확률 (Probability)
- **기댓값**: E[X] = ...
- **분산**: Var[X] = ...

### 수열 (Sequences)
- **등차수열**: aₙ = a₁ + (n-1)d
- **등비수열**: aₙ = a₁ · rⁿ⁻¹
- **피보나치 수열**: F(n) = F(n-1) + F(n-2)

## 관련 문제 추천

### 프로그래머스

1. **[문제명]** (Level X)
   - 링크: https://school.programmers.co.kr/learn/courses/30/lessons/XXXXX
   - 난이도: ⭐⭐⭐
   - **수학적 포인트**: [어떤 점화식/수식이 핵심인지]
   - 핵심: ...

2. **[문제명]** (Level X)
   - 링크: ...
   - 난이도: ...
   - **수학적 포인트**: ...

### 백준

1. **[문제 번호] - [문제명]**
   - 링크: https://www.acmicpc.net/problem/XXXX
   - 난이도: [실버/골드 X]
   - **수학적 포인트**: ...
   - 핵심: ...

## 학습 팁

### 수학적 사고 연습

📐 **점화식 유도 연습**
1. 작은 케이스부터 손으로 계산
2. 패턴 찾기
3. 일반화된 식 세우기
4. 수학적 귀납법으로 검증

### 주의사항

⚠️ **흔한 수학적 실수**
- 실수 1: 기저 사례를 잘못 설정
- 실수 2: 점화식에서 중복 계산
- 실수 3: 오버플로우 미고려 (mod 연산 필요)

### 증명 연습

✅ **스스로 증명해보기**
- [ ] 정확성 증명 (귀납법)
- [ ] 최적 부분 구조 증명
- [ ] 시간 복잡도 증명
- [ ] 공간 복잡도 분석

### 디버깅 팁

🐛 **수학적 검증 방법**
- [ ] 작은 입력으로 손계산 vs 코드 결과 비교
- [ ] 점화식이 코드에 정확히 반영되었는지 확인
- [ ] 기저 사례가 수학적 정의와 일치하는지
- [ ] 오버플로우 체크 (필요 시 mod 연산)

## 심화 학습

### 관련 정리 (Theorems)

- **[정리 1]**: 설명...
- **[정리 2]**: 설명...

### 확장 개념

- **고급 DP**: [메모이제이션 vs 타뷸레이션]
- **최적화 기법**: [분할 정복 최적화, Convex Hull Trick 등]

### 추가 학습 자료

- 참고 서적: ...
- 관련 논문: ...
- 온라인 강의: ...

---

**작성일**: YYYY-MM-DD
**마지막 수정**: YYYY-MM-DD

**학습 방법**: 반드시 손으로 점화식을 유도하고 증명해보세요!
