---
name: "Court Records Search"
description: "Search federal and state court records for litigation history"
allowed-tools:
  - src.tools.court_records
---

# Court Records Search

## Purpose

Search federal and state court records to identify litigation history, criminal records, bankruptcies, and legal proceedings for individuals and entities.

## When to Use

- Due diligence on business counterparties and partners
- Background checks on executives and key personnel
- Investigation of potential litigation risk
- Bankruptcy and insolvency analysis
- Criminal background screening for high-risk roles
- Asset recovery and judgment enforcement
- Regulatory compliance for financial institutions
- Fraud investigation and evidence gathering

## How to Use

The court records tool searches multiple jurisdictions and case types:

- **Civil Litigation**: Contract disputes, tort claims, commercial litigation
- **Criminal Records**: Federal and state criminal proceedings
- **Bankruptcy Cases**: Chapter 7, 11, 13 filings and proceedings
- **Family Court**: Divorce, custody (where publicly accessible)
- **Regulatory Proceedings**: SEC, FTC, other agency actions
- **Appellate Courts**: Appeals and higher court decisions

## Examples

**Executive background check:**
```
Subject: Robert Thompson, proposed CEO
Search: Federal and state courts in all residence/business jurisdictions
Focus: Criminal history, civil litigation, bankruptcy filings
```

**Business counterparty screening:**
```
Entity: ABC Manufacturing Corp
Investigation: Contract disputes, product liability cases, regulatory actions
Risk Assessment: Litigation history and financial stability
```

**Fraud investigation:**
```
Subject: Investment advisor under investigation
Search: Securities violations, civil fraud cases, criminal charges
Evidence: Pattern of fraudulent activity across jurisdictions
```

**Asset recovery:**
```
Debtor: XYZ Holdings LLC and principals
Search: Judgment liens, asset transfers, bankruptcy proceedings
Strategy: Identify recoverable assets and legal remedies
```

## Important Notes

- Court record access varies by jurisdiction and case type
- Some records may be sealed, expunged, or restricted access
- Federal courts generally have better online access than state courts
- Criminal records may have specific privacy protections
- Bankruptcy records are typically public but may have limited personal info
- Search multiple jurisdictions where subject has lived/operated
- Consider both individual names and business entities
- Be aware of statute of limitations and record retention periods
- Some states restrict criminal background check usage in employment