# Example Long-Form Twitter Posts

These examples demonstrate the target style: Cremieux's casual rigor with medical content.

---

## Example 1: GLP-1 Drugs and Heart Failure

---

**Semaglutide just became the best HFpEF drug we have.**

The STEP-HFpEF trial results are in. Symptom improvement: 6.3 points better than placebo on the Kansas City Cardiomyopathy Questionnaire. That's not subtle. It's the largest symptomatic improvement in any HFpEF trial.

For context: we've been trying to find something that works for HFpEF for two decades. CHARM-Preserved, I-PRESERVE, TOPCAT, PARAGON-HF—all failed or showed marginal benefit at best. The only clear win was EMPEROR-Preserved, and even that showed smaller symptom improvements than this.

**The numbers**

529 patients with HFpEF and BMI ≥30. Randomized to semaglutide 2.4mg weekly or placebo.

After one year:
- KCCQ score: +7.8 points (semaglutide) vs +1.5 (placebo)
- 6-minute walk: +21 meters improvement
- Body weight: -13% vs -3%
- HF hospitalization: 8 vs 24 events (HR 0.18)

That hospitalization number has wide confidence intervals—only 32 events total. But the direction is clear.

**Why does it work?**

Obesity and HFpEF share biology. More fat means more blood volume, higher filling pressures, worse exercise tolerance. Weight loss directly addresses this.

But there's probably more going on. CRP dropped 39% in the semaglutide group. Something anti-inflammatory is happening beyond just weight loss.

**The catch**

This was a one-year trial. Will benefits persist? Probably, but we don't know.

Mean BMI was 37. Patients closer to BMI 30 might see smaller effects.

Cost remains a problem. Weekly semaglutide isn't cheap.

**Bottom line**

For patients with HFpEF and obesity, this changes the conversation. Semaglutide isn't just about weight anymore. It's the most effective symptomatic therapy we've tested in this population.

---

SOURCES:
1. Kosiborod MN et al. NEJM 2023;389:1069-1084.
2. Solomon SD et al. NEJM 2021;385:1451-1461.

---

## Example 2: Trend Skepticism Piece

---

**Early-onset cancer is rising. But how much is real?**

Colorectal cancer under 50 has increased about 2% annually since the mid-1990s. The headlines call it an epidemic. But before concluding something terrible is happening, consider the alternative: we're looking harder.

**What changed since the 1990s?**

Colonoscopy became common. CT and MRI utilization exploded. Genetic testing identified high-risk individuals earlier. Awareness campaigns encouraged screening.

Each of these shifts increases detected cancers without any change in underlying disease.

**The lead-time problem**

Detect a cancer five years earlier, and incidence rises for five years before stabilizing. The patient would have been diagnosed eventually—we just moved the diagnosis earlier.

This creates an apparent "epidemic" that's really a detection effect.

**What the mortality data shows**

Here's the key: mortality has increased modestly, but less than incidence.

If incidence doubled while mortality stayed flat, we'd know it was all detection artifact. If both doubled proportionally, we'd know it was real disease increase.

The truth is somewhere between. Some real increase. A lot of detection effect mixed in.

**The honest conclusion**

Something is probably happening. The mortality rise, though small, suggests genuine increase. Obesity, processed food, sedentary behavior—all plausible contributors.

But the magnitude is overstated. When you look harder, you find more. The "cancer epidemic" framing sensationalizes a moderate trend.

**What to do with this**

For clinicians: take GI symptoms seriously in younger patients. Don't dismiss complaints as "too young for cancer."

For patients: awareness is reasonable. Anxiety is not. Absolute risk of colon cancer before 50 remains about 5 per 100,000.

---

SOURCES:
1. Siegel RL et al. J Natl Cancer Inst 2017;109(8):djw322.
2. Welch HG, Black WC. J Natl Cancer Inst 2010;102:605-613.

---

## Example 3: Drug Comparison

---

**PCSK9 inhibitors vs. bempedoic acid: not equivalent.**

Both add onto statins. Both reduce LDL. Both have outcomes data. But they're not interchangeable.

**The efficacy gap**

PCSK9 inhibitors cut LDL by 50-60%. Bempedoic acid cuts it by about 18%.

A patient at LDL 130 on statin could reach ~55 with a PCSK9 inhibitor or ~107 with bempedoic acid. That's not a minor difference.

**Outcomes data**

FOURIER and ODYSSEY showed PCSK9 inhibitors reduce cardiovascular events by roughly 15% over 2-3 years.

CLEAR Outcomes showed bempedoic acid reduces events by 13%. But in a statin-intolerant population, so direct comparison is tricky.

Both work. PCSK9 inhibitors work more if you need maximum LDL lowering.

**When to use bempedoic acid**

True statin intolerance. It doesn't cause myopathy—gets activated only in the liver.

Injection refusal. Some patients won't do shots. Bempedoic acid is a daily pill.

**When to use PCSK9 inhibitors**

Very high risk: prior MI, FH, recurrent events despite therapy.

LDL way above target. If you need 50% reduction, 18% won't cut it.

**The bottom line**

PCSK9 inhibitors are more potent. Bempedoic acid is more convenient and works for statin-intolerant patients.

For most high-risk patients who can tolerate injections, PCSK9 inhibitors remain the stronger option.

---

SOURCES:
1. Sabatine MS et al. NEJM 2017;376:1713-1722.
2. Schwartz GG et al. NEJM 2018;379:2097-2107.
3. Nissen SE et al. NEJM 2023;388:1353-1364.

---

## What These Examples Show

### Structure
- Hook with data (first 1-2 sentences)
- Clear angle or question
- Evidence in short paragraphs
- Skepticism or caveats
- Direct conclusion
- Sources at end

### Voice
- Short paragraphs
- Conversational headers ("The catch," "The bottom line")
- First person occasionally
- Confident where evidence is strong
- No promotional language

### Anti-AI Patterns (Absent)
- No "underscores/highlights the importance"
- No tailing participles
- No throat-clearing openers
- No "comprehensive/robust/nuanced"
- No exactly-three lists
- No excessive em dashes
- No "It's not just X, it's Y"

---

## Common Mistakes to Avoid

### ❌ Academic Opening
"In recent years, there has been growing recognition that GLP-1 receptor agonists may confer benefits beyond glycemic control, with emerging evidence suggesting favorable effects on cardiovascular and metabolic parameters in patients with heart failure with preserved ejection fraction."

### ✅ Cremieux Opening
"Semaglutide just became the best HFpEF drug we have."

---

### ❌ Puffed Conclusion
"These findings underscore the transformative potential of this therapeutic approach, highlighting the need for clinicians to incorporate these agents into their treatment algorithms while remaining mindful of individual patient characteristics and preferences."

### ✅ Cremieux Conclusion
"For patients with HFpEF and obesity, this changes the conversation."

---

### ❌ Mechanism Jargon
"The pleiotropic effects of SGLT2 inhibitors encompass a multifaceted array of pathophysiological mechanisms, including modulation of myocardial substrate utilization, attenuation of neurohormonal activation, and amelioration of maladaptive remodeling processes."

### ✅ Cremieux Mechanism
"How does it work? Three things seem to matter: heart metabolism shifts, sodium retention drops, and fibrosis might slow. We don't fully understand which effect matters most."
