# Voice Guide: Cremieux Style + Anti-AI Writing

This guide covers two things:
1. How to sound like Cremieux (casual rigor, not academic)
2. How to avoid AI writing tells

---

## Part 1: The Cremieux Sound

### Paragraph Length

**Academic:** Paragraphs run 100-200 words, containing multiple ideas, citations, and qualifications all packed together in a way that requires careful reading to parse.

**Cremieux:** One idea. One paragraph. Move on.

Sometimes just one sentence.

### Sentence Rhythm

**Academic:** All sentences are medium-length, around 20-30 words, with similar structure, creating a monotonous rhythm that signals "formal writing."

**Cremieux:** Short. Then longer when you need to explain something. Mix it up. Fragments work.

### Headers

**Academic:**
- "Introduction"
- "Methods and Materials"
- "Results"
- "Discussion"
- "Clinical Implications"

**Cremieux:**
- "What the data shows"
- "The catch"
- "So what?"
- Or no headers at all—just bold for emphasis

### Confidence Level

**Academic:** "While the evidence suggests a potential association, further research is warranted to establish causality and determine the optimal intervention strategies."

**Cremieux:** "The data is clear. This works."

Hedge only when genuinely uncertain. Confidence signals competence.

### First Person

**Use sparingly but naturally:**
- "I've read through the trials..."
- "What I find interesting here..."
- "In my read of this data..."

**Avoid overuse:**
- Not every paragraph
- Not to express opinion without evidence
- Not to signal humility ("I'm just a...")

---

## Part 2: AI Writing Tells (Complete List)

### Category 1: Importance Puffery

AI constantly claims things are important instead of showing why.

**Delete these phrases:**
- "underscores the importance of..."
- "highlights the significance of..."
- "serves as a testament to..."
- "plays a crucial/vital/pivotal role in..."
- "reflects broader trends in..."
- "represents a significant shift toward..."
- "is a reminder that..."
- "speaks to the..."
- "marks a key turning point..."

**Example fix:**

❌ "This trial underscores the importance of early intervention in heart failure management, highlighting the need for timely initiation of guideline-directed medical therapy."

✅ "Start GDMT early. Every month of delay costs outcomes."

### Category 2: Tailing Participles

Sentences ending with "-ing" phrases that claim meaning. Inanimate things can't "highlight" or "emphasize."

**Delete these endings:**
- "...ensuring sustainable outcomes"
- "...highlighting the need for..."
- "...emphasizing the importance of..."
- "...reflecting broader concerns about..."
- "...contributing to our understanding of..."
- "...demonstrating the value of..."
- "...underscoring the significance of..."

**Example fix:**

❌ "The trial enrolled 3,000 patients with established cardiovascular disease, emphasizing the importance of secondary prevention in high-risk populations."

✅ "The trial enrolled 3,000 patients with established CVD—exactly the population where you'd expect treatment to matter most."

### Category 3: Throat-Clearing Openers

Never start with these:

- "In today's..."
- "In the realm of..."
- "In recent years..."
- "When it comes to..."
- "It's important to note that..."
- "It's worth mentioning that..."
- "It goes without saying that..."

**Example fix:**

❌ "In recent years, there has been growing interest in the role of GLP-1 receptor agonists in cardiovascular risk reduction, with emerging evidence suggesting benefits beyond glycemic control."

✅ "GLP-1 agonists reduce cardiovascular events by about 15%. The mechanism isn't fully understood, but the outcomes data is solid."

### Category 4: Overused AI Vocabulary

These words appear 10-1000x more often in AI text than human text:

**Extreme overuse (replace always):**
- delve → look at, examine, dig into
- tapestry → (delete or use: mix, combination)
- landscape → field, area, market
- comprehensive → thorough, full
- robust → strong, solid
- nuanced → detailed, subtle
- multifaceted → complex
- leverage → use
- utilize → use
- harness → use
- foster → build, create, encourage
- navigate → handle, manage, work through
- underscore → (delete)
- showcase → show
- empower → help, enable

**High overuse (use sparingly if ever):**
- pivotal (show why it matters instead)
- crucial (show why it matters instead)
- vital (show why it matters instead)
- groundbreaking (let readers judge)
- unprecedented (rarely true)
- innovative (empty)
- cutting-edge (empty)
- seamless (empty)
- paradigm (pretentious)
- synergy (corporate)

### Category 5: Structural Tells

**Rule of Three:** AI groups things in threes constantly. "fast, efficient, and reliable" or "mortality, morbidity, and hospitalization."

Fix: Use two items. Or four+. Rarely exactly three.

**Em Dash Overuse:** AI uses more em dashes than humans.

Fix: Maximum one per paragraph. Often commas or periods work better.

**Negative Parallelism:** "It's not just about X, it's about Y."

Fix: Just say Y.

❌ "It's not just about lowering blood pressure—it's about reducing cardiovascular events."

✅ "These drugs reduce cardiovascular events, not just blood pressure."

### Category 6: Promotional Language

**Delete these words:**
- groundbreaking
- revolutionary
- game-changing
- stunning
- remarkable
- fascinating
- incredible
- breathtaking
- transformative

**If something is genuinely remarkable, show it with data:**

❌ "The remarkable results of this groundbreaking trial..."

✅ "The trial showed a 26% reduction in mortality—larger than any prior therapy in this population."

---

## Part 3: Before/After Examples

### Example 1: Trial Summary

**Before (AI/Academic):**
> In this pivotal randomized controlled trial, investigators demonstrated that the novel therapeutic intervention was associated with a statistically significant reduction in the composite primary endpoint, underscoring the importance of early treatment initiation and highlighting the potential for this approach to transform clinical practice in the management of patients with heart failure.

**After (Cremieux):**
> The trial hit its primary endpoint: 26% reduction in death or hospitalization. That's a larger effect than we saw with ACE inhibitors in the original trials. For a disease that kills half of patients within five years, this matters.

### Example 2: Mechanism Explanation

**Before (AI/Academic):**
> The pathophysiological mechanisms underlying the observed clinical benefits are multifaceted, encompassing direct effects on myocardial metabolism, modulation of neurohormonal activation, and amelioration of the maladaptive remodeling processes that contribute to disease progression, thereby fostering improved cardiac function and enhanced patient outcomes.

**After (Cremieux):**
> How does it work? Three things seem to matter: the drug shifts heart metabolism from fatty acids to ketones (more efficient fuel), it reduces sodium retention (less fluid overload), and it may directly slow fibrosis. We don't fully understand which effect drives outcomes, but the clinical signal is consistent.

### Example 3: Clinical Implications

**Before (AI/Academic):**
> These findings carry significant implications for clinical practice, suggesting that healthcare providers should consider incorporating this therapeutic modality into their treatment algorithms for appropriate patient populations, while remaining mindful of the need for individualized assessment and shared decision-making in the context of patient preferences and comorbid conditions.

**After (Cremieux):**
> Start this drug in your next eligible patient. The NNT is 21 over three years—roughly one hospitalization prevented for every 21 patients treated. That's better than most things we do.

### Example 4: Limitations

**Before (AI/Academic):**
> It is important to acknowledge several limitations of the present analysis. The observational nature of the data precludes causal inference, and residual confounding cannot be entirely excluded despite rigorous statistical adjustment. Furthermore, the generalizability of these findings to diverse patient populations warrants careful consideration.

**After (Cremieux):**
> The usual caveats apply. Observational data can't prove causation. The cohorts were mostly white and mostly American. And unmeasured confounding is always possible—people who drink less soda probably differ in other ways too.

But: the consistency across 34 cohorts, the clear dose-response, and the biological plausibility make this more than just correlation.

---

## Part 4: Self-Editing Checklist

Before publishing, run these passes:

### Pass 1: Importance Scan
Search for: significant, important, crucial, vital, pivotal, key, underscores, highlights, emphasizes, reflects, demonstrates

For each hit: Is there evidence? If not, delete.

### Pass 2: Participle Check
Search for: -ing endings (ensuring, highlighting, emphasizing, reflecting, contributing)

Delete the entire phrase. If the point matters, rewrite as a separate sentence.

### Pass 3: Vocabulary Scan
Search for: delve, tapestry, landscape, leverage, utilize, foster, navigate, robust, comprehensive, nuanced, multifaceted, harness, empower

Replace with simpler words or delete.

### Pass 4: Structure Check
- Any lists of exactly three items? → Change to two or four+
- More than one em dash per paragraph? → Convert some to commas/periods
- Any "It's not just X, it's Y"? → Just say Y

### Pass 5: Opener Check
Does it start with:
- Data or a specific claim? ✅ Good
- "In recent years..." or "In the realm of..." or "When it comes to..."? ❌ Rewrite

### Pass 6: Paragraph Length
- Any paragraphs over 4 sentences? → Break up
- All paragraphs similar length? → Vary them

---

## Part 5: Quick Reference Card

### ✅ Do This

- Open with data
- Short paragraphs
- Confident conclusions
- Specific numbers
- First person (sparingly)
- Questions to frame analysis
- Let readers judge importance

### ❌ Not This

- Open with "In recent years..."
- Long paragraphs
- Excessive hedging
- Only relative risk
- Impersonal academic voice
- Claim everything is important
- "underscores," "highlights," "emphasizes"
