# Clue Writing Guidelines

## Difficulty Calibration

Target college students with moderate verbal fluency (SAT-level vocabulary, not GRE).

### Straightforward (60% of clues)

Direct definitions with context from source material.

- Use clear, accessible language
- Reference specific content from the source
- Avoid dictionary-style definitions

**Examples:**
- "Programming construct that repeats code execution" → LOOP
- "Data structure storing key-value pairs" → DICTIONARY

### Moderate (30% of clues)

Indirect references requiring inference.

- Provide examples instead of definitions
- Use contextual hints from surrounding material
- Reference relationships between concepts

**Examples:**
- "Python, Java, and C++ are examples of these" → LANGUAGES
- "What a compiler produces from source code" → BINARY

### Challenging (10% of clues)

Subtle wordplay or etymology (but not cryptic crossword level).

- Light wordplay accessible to general audience
- Historical or etymological connections
- Requires synthesis across multiple concepts

**Examples:**
- "Named after a Greek letter, this constant is approximately 3.14159" → PI
- "From Latin 'to lead out', the process of drawing conclusions from data" → INFERENCE

## Clue Format Types

### Definitional
Standard definition with subject-specific context.
"Process by which plants convert sunlight to energy" → PHOTOSYNTHESIS

### Contextual
References specific content from source material.
"In Chapter 3, this scientist proposed the theory of relativity" → EINSTEIN

### Fill-in-the-blank
Complete a phrase or statement from the source.
"The ___ method allows objects to initialize their state" → CONSTRUCTOR

### Example-based
Identify category from examples.
"HTTP, FTP, and SMTP are types of these" → PROTOCOLS

### Relationship
Define by relationship to other concepts.
"The inverse operation of encryption" → DECRYPTION

## Avoid

- Clues requiring knowledge beyond the source material
- Obscure vocabulary not in the source
- Ambiguous clues with multiple valid answers
- Cultural references that may exclude some students
- Clues shorter than 4 words (too cryptic)
