---
name: curriculum-develop-content
description: Create detailed lesson plans, instructional materials, learning activities, and differentiation strategies aligned to learning objectives. Use when developing instructional content, writing lesson plans, or creating learning activities. Activates on "create lesson plan", "develop content for [objective]", "write instructional materials", or "design learning activities".
---

# Instructional Content Development

Create comprehensive lesson plans, learning activities, and instructional materials aligned to learning objectives and appropriate for educational level.

## When to Use

Automatically activate when the user:
- Needs to create lesson plans
- Asks "develop content for [learning objective]"
- Wants learning activities designed
- Requests "write instructional materials"
- Says "create hands-on activities"
- Needs differentiation strategies

## Required Inputs

- **Learning Objectives**: Specific objectives to address
- **Curriculum Design**: Architecture/sequence context
- **Educational Level**: K-5, 6-8, 9-12, undergraduate, graduate, post-graduate
- **Lesson Duration**: Time available (e.g., "45 minutes", "90 minutes", "3 hours")
- **Resources Available** (optional): Materials, technology, space constraints

## Workflow

### 1. Analyze Learning Objectives

For target objectives, identify:
- Bloom's cognitive level
- Content knowledge required
- Skills to be developed
- Prerequisites needed
- Standards alignment

### 2. Design Lesson Structure

Use research-based lesson models:

**K-12 Model (Gradual Release)**:
1. Hook/Anticipatory Set (5-10%)
2. Direct Instruction/Modeling (20-30%)
3. Guided Practice (30-40%)
4. Independent Practice (20-30%)
5. Closure/Assessment (5-10%)

**Higher Ed Model**:
1. Activation/Connection (10%)
2. Content Delivery (30%)
3. Active Learning (40%)
4. Application/Transfer (15%)
5. Synthesis/Next Steps (5%)

### 3. Create Complete Lesson Plan

Generate detailed plan with all components:

```markdown
# Lesson Plan: [TITLE]

**Learning Objectives**: [LO-X.X, LO-X.Y]
**Educational Level**: [Level]
**Duration**: [Time]
**Lesson Date**: [Date]

## Lesson Overview

**Purpose**: [What this lesson accomplishes in the unit sequence]

**Big Idea**: [Core concept students will understand]

**Essential Question**: [Open-ended question framing the learning]

## Standards Addressed

- [Standard Code]: [Standard description]

## Learning Objectives

By the end of this lesson, students will:
- **LO-X.X**: [Full objective with success criteria]
- **LO-X.Y**: [Full objective with success criteria]

## Materials & Resources

**Teacher Materials**:
- [Item 1 with quantity]
- [Item 2 with quantity]

**Student Materials**:
- [Item 1 per student/group]
- [Item 2 per student/group]

**Technology**: [Devices, software, websites needed]

**Handouts**: [List all worksheets, guides]

## Prerequisite Knowledge

Students should already know/be able to:
- [Prerequisite 1]
- [Prerequisite 2]

## Lesson Procedures

### 1. Hook/Engagement (5 minutes)

**Activity**: [Compelling opening]

**Teacher Does**:
- [Action 1]
- [Action 2]

**Students Do**:
- [Response 1]
- [Response 2]

**Purpose**: [Why this hook connects to learning]

### 2. Direct Instruction (15 minutes)

**Objective Addressed**: [LO-X.X]

**Content to Cover**:
- [Concept 1 with explanation]
- [Concept 2 with explanation]
- [Concept 3 with explanation]

**Teaching Strategy**: [Lecture, demonstration, think-aloud, etc.]

**Teacher Script/Notes**:
> [Key points to emphasize, example explanations, questions to pose]

**Check for Understanding**:
- [Quick check method]
- [Expected response]

### 3. Guided Practice (15 minutes)

**Objective Addressed**: [LO-X.X]

**Activity**: [Description of collaborative/supported practice]

**Grouping**: [Individual, pairs, small groups, whole class]

**Task**:
1. [Step 1 students complete with support]
2. [Step 2 students complete with support]
3. [Step 3 students complete with support]

**Teacher Role**:
- Circulate and monitor
- Ask probing questions: [Examples]
- Provide scaffolding: [How]

**Success Indicators**:
- Students can [observable behavior]
- Common errors to watch for: [List]

### 4. Independent Practice (20 minutes)

**Objective Addressed**: [LO-X.Y]

**Activity**: [Description of individual application]

**Task**: [Detailed instructions students will receive]

**Differentiation** (see full section below):
- **Advanced**: [Extension]
- **On-Level**: [Core task]
- **Support Needed**: [Simplified/scaffolded version]

**Assessment**: [How you'll know students achieved objective]

### 5. Closure (5 minutes)

**Activity**: [Exit ticket, reflection, summary]

**Prompts**:
- [Question 1 to assess understanding]
- [Question 2 to connect to next lesson]

**Next Steps**: [Preview of upcoming lesson]

## Differentiation Strategies

### For Advanced Learners
- **Challenge**: [Extension activity or deeper question]
- **Enrichment**: [Additional complexity or real-world application]
- **Pacing**: [Allow faster pace, add breadth]

### For Struggling Learners
- **Scaffolding**: [Sentence frames, graphic organizers, step-by-step guides]
- **Simplification**: [Reduced complexity, fewer steps]
- **Support**: [Partner work, teacher check-ins, modified success criteria]

### For English Language Learners
- **Language Support**: [Vocabulary pre-teaching, visual aids, sentence stems]
- **Comprehension**: [Simplified text, translated resources, buddy system]
- **Expression**: [Allow native language, provide word banks]

### For Students with Disabilities
- **Accommodations**: [Extended time, reduced items, assistive technology]
- **Modifications**: [Adjusted expectations, alternative formats]
- **Supports**: [Visual schedules, manipulatives, sensory tools]

## Assessment

### Formative Assessment (During Lesson)
- **Checks**: [Questions, observations, quick tasks]
- **Purpose**: [What you're monitoring]
- **Adjustments**: [How you'll respond to data]

### Summative Assessment (End of Lesson)
- **Method**: [Exit ticket, quiz, observation, product]
- **Criteria**: [What constitutes mastery]
- **Data Use**: [How results inform next steps]

## Common Misconceptions & How to Address

1. **Misconception**: [What students often think]
   - **Why**: [Reasoning behind misconception]
   - **Address**: [Instructional strategy to correct]

2. **Misconception**: [Another common error]
   - **Why**: [Reasoning]
   - **Address**: [Strategy]

## Vocabulary

| Term | Student-Friendly Definition | Visual/Example |
|------|----------------------------|----------------|
| [Word 1] | [Simple definition] | [How to represent] |
| [Word 2] | [Simple definition] | [How to represent] |

## Safety Considerations (if applicable)

- [Safety rule or precaution]
- [Equipment handling procedures]

## Homework/Extension (optional)

**Assignment**: [Description]
**Purpose**: [How this extends/reinforces learning]
**Time Expected**: [Minutes]

## Reflection Notes (Post-Lesson)

*To be completed after teaching:*

**What worked well**:

**What to adjust**:

**Student challenges**:

**Time management**:

---

**Artifact Metadata**:
- **Artifact Type**: Lesson Plan
- **Objectives**: [LO list]
- **Level**: [Level]
- **Duration**: [Time]
- **Next Phase**: Review or Deliver
```

### 4. Level-Appropriate Content Development

**K-5**:
- Concrete, hands-on activities
- Short attention span segments (10-15 min max)
- Heavy use of visuals, manipulatives
- Simple, clear language
- Repetition and practice emphasized

**6-8**:
- Bridge concrete/abstract
- Group work and collaboration
- Start introducing complex texts
- Build independence gradually
- Connect to student interests

**9-12**:
- Abstract concepts expected
- Student-led inquiry
- Complex texts and problems
- Prepare for college/career
- Depth over breadth

**Undergraduate**:
- Self-directed learning
- Case studies and applications
- Discussion-based
- Reading and research outside class
- Professional contexts

**Graduate/Post-Grad**:
- Seminar format
- Original research
- Peer teaching
- Expertise development
- Field contribution

### 5. Generate Learning Activities

Create engaging activities aligned to objectives:

**Activity Types by Bloom's Level**:
- **Remember**: Flashcards, matching, labeling, listing
- **Understand**: Summarizing, explaining, demonstrating, illustrating
- **Apply**: Problem-solving, demonstrations, experiments, simulations
- **Analyze**: Comparing, organizing, deconstructing, attributing
- **Evaluate**: Critiquing, judging, testing, detecting
- **Create**: Designing, constructing, planning, producing

### 6. Output Format

**Human-Readable** (default):
- Formatted markdown lesson plan
- Write to: `curriculum-artifacts/lessons/[title]-lesson.md`

**JSON Format**:
```json
{
  "artifact_type": "lesson_plan",
  "title": "string",
  "objectives": ["LO-1.1"],
  "duration_minutes": 45,
  "level": "string",
  "sections": [
    {
      "name": "Hook",
      "duration_minutes": 5,
      "activities": ["string"],
      "teacher_actions": ["string"],
      "student_actions": ["string"]
    }
  ],
  "materials": ["string"],
  "assessments": ["string"]
}
```

### 7. CLI Interface

```bash
# Develop content for specific objectives
/curriculum.develop-content --objectives "LO-1.1,LO-1.2" --duration "45 min" --level "6-8"

# With context from design
/curriculum.develop-content --design "photosynthesis-design.md" --lesson "Unit 1, Lesson 1"

# Multiple lessons at once
/curriculum.develop-content --design "quadratics-design.md" --unit "Unit 1" --all-lessons

# JSON output
/curriculum.develop-content --objectives "LO-3.1" --format json

# Help
/curriculum.develop-content --help
```

## Composition with Other Skills

**Input from**:
- `/curriculum.design` - Objectives and architecture
- `/curriculum.assess-design` - Assessment expectations
- `/curriculum.research` - Misconceptions, pedagogical approach

**Output to**:
- `/curriculum.develop-multimedia` - Lesson plans inform script needs
- `/curriculum.review-pedagogy` - Content reviewed for quality
- `/curriculum.package-*` - Lessons packaged for delivery

## Exit Codes

- **0**: Success - Lesson plan created
- **1**: Invalid educational level
- **2**: Cannot load objectives
- **3**: Duration invalid or unrealistic
- **4**: Insufficient information to create plan
