---
name: curriculum-review-bias
description: Identify and eliminate bias, stereotypes, and non-inclusive language; ensure cultural responsiveness and equity throughout curriculum materials. Use when checking for bias, reviewing inclusivity, or ensuring equitable content. Activates on "check for bias", "review inclusivity", "cultural responsiveness", or "equity check".
---

# Bias Detection & Inclusive Language Review

Analyze curriculum materials to identify bias, stereotypes, cultural assumptions, and barriers; recommend inclusive, equitable alternatives.

## When to Use

- Review content for bias and stereotypes
- Check inclusive language use
- Ensure cultural responsiveness
- Validate equitable representation
- Assess fairness in assessment items

## Required Inputs

- **Curriculum Materials**: Any content to review (lessons, assessments, multimedia)
- **Educational Level**: K-5 through post-graduate
- **Student Demographics** (optional): Known diversity characteristics

## Workflow

### 1. Load Materials for Analysis

Read all content including:
- Instructional text
- Examples and scenarios
- Assessment items
- Images and media descriptions
- Names and characters used

### 2. Scan for Bias Categories

**Gender Bias**:
- ❌ Gender stereotypes (e.g., "nurses are women", "engineers are men")
- ❌ Gendered language (e.g., "chairman", "mankind")
- ❌ Assuming binary gender
- ❌ Unequal representation in examples
- ✅ Gender-inclusive language ("chairperson", "humanity")
- ✅ Balanced representation across genders

**Racial/Ethnic Bias**:
- ❌ Stereotypical associations
- ❌ Tokenism (single representative)
- ❌ Cultural assumptions
- ❌ Eurocentric perspectives only
- ✅ Diverse representation
- ✅ Multiple cultural perspectives
- ✅ Respectful, accurate portrayals

**Socioeconomic Bias**:
- ❌ Assuming resources/privilege (e.g., "have your parents drive you", "use your home computer")
- ❌ Stigmatizing poverty
- ❌ Examples only accessible to wealthy
- ✅ Awareness of varied economic situations
- ✅ Accessible alternatives provided

**Ability Bias (Ableism)**:
- ❌ Using disability as metaphor (e.g., "turn a blind eye", "fell on deaf ears")
- ❌ Assuming physical abilities
- ❌ Negative framing of disabilities
- ✅ Person-first or identity-first language (contextually appropriate)
- ✅ Disability included neutrally when relevant

**Age Bias**:
- ❌ Stereotypes about age groups
- ❌ Dismissive of any age
- ✅ Age-appropriate without being patronizing
- ✅ Respectful of all ages

**Religious/Cultural Bias**:
- ❌ Assuming dominant religion
- ❌ Religious holidays as universal
- ❌ Cultural practices as "weird" or "exotic"
- ✅ Secular examples or multi-faith
- ✅ Cultural practices presented respectfully

**Geographic Bias**:
- ❌ Urban-only or rural-only assumptions
- ❌ US-centric examples (if international audience)
- ❌ Assuming specific regional knowledge
- ✅ Diverse geographic contexts
- ✅ Explain regional references

**Linguistic Bias**:
- ❌ Mocking non-standard dialects
- ❌ Assuming English fluency
- ❌ Complex idioms without explanation
- ✅ Clear, accessible language
- ✅ Support for multilingual learners

### 3. Analyze Representation

Count and assess:

**Character/Example Diversity**:
- Names used: [Analyze cultural diversity]
- Roles depicted: [Analyze who does what]
- Authority figures: [Who holds power/expertise]
- Problem-solvers: [Who finds solutions]

**Target**: No single group always in leadership, expertise, or success roles; No single group always needing help or failing

### 4. Review Assessment Items for Fairness

Check each item for:
- **Cultural Load**: Does success require specific cultural knowledge unrelated to the objective?
- **Language Barriers**: Is unnecessary complex vocabulary used?
- **Scenario Bias**: Do examples disadvantage specific groups?
- **Stereotype Threat**: Could wording trigger identity-based anxiety?

### 5. Generate Bias Review Report

```markdown
# Bias & Inclusivity Review: [TOPIC]

**Review Date**: [Date]
**Materials Reviewed**: [List]
**Diversity Lens**: Gender, Race/Ethnicity, SES, Ability, Age, Religion/Culture, Geography, Language

## Executive Summary

**Overall Rating**: [Excellent | Good | Needs Revision | Poor]

**Critical Issues**: [Count]
**Moderate Concerns**: [Count]
**Recommendations**: [Count]

**Readiness**: [Ready | Minor revisions | Major revisions]

## Bias Findings by Category

### Gender Bias

**Issues Found**: [Count]

**Critical** (Must Fix):
1. [Location]: "[Problematic text]"
   - **Problem**: [Explanation]
   - **Recommendation**: "[Suggested replacement]"

**Moderate** (Should Fix):
1. [Location]: "[Problematic text]"
   - **Problem**: [Explanation]
   - **Recommendation**: "[Suggested alternative]"

### Racial/Ethnic Bias

[Same structure]

### Socioeconomic Bias

[Same structure]

### Ability Bias

[Same structure]

### Age, Religious, Geographic, Linguistic Bias

[Same structure for each]

## Representation Analysis

### Names Used

| Name | Cultural Origin | Role/Context | Issue |
|------|----------------|--------------|-------|
| John | Anglo-American | Doctor (authority) | Part of pattern: only Anglo names in authority |
| Maria | Latina | Patient (receiving help) | ⚠️  Pattern concern |
| Li Wei | Chinese | Student (struggling) | ❌ Stereotype reinforcement |

**Analysis**: Names show pattern of Anglo individuals in authority, others needing help. Reinforces problematic hierarchies.

**Recommendation**: Diversify authority figures—include Maria as doctor, Li Wei as expert, etc.

### Role Distribution

| Role Type | Gender | Race/Ethnicity | Pattern Issue |
|-----------|--------|----------------|---------------|
| Doctor (3 examples) | Male (3) | White (3) | ❌ No diversity |
| Teacher (4 examples) | Female (4) | White (3), Asian (1) | ⚠️  Gender stereotype |
| Scientist (2 examples) | Male (2) | White (2) | ❌ No diversity |

**Recommendation**: Balance gender and race across all professional roles

## Assessment Fairness Review

### Item-Level Analysis

**Item MC-1.5**:
- **Text**: "Calculate the cost of a family ski vacation..."
- **Issue**: Assumes familiarity with skiing, family vacations, disposable income
- **Impact**: May disadvantage students from lower SES backgrounds
- **Recommendation**: Use universally accessible scenario: "Calculate the cost of items at a school store..."

**Item ESSAY-2.1**:
- **Text**: "Describe a time your family celebrated a holiday..."
- **Issue**: Assumes stable family structure and holiday celebration
- **Impact**: May be painful/impossible for students in foster care, refugees, non-celebratory families
- **Recommendation**: "Describe a memorable day or event you experienced..."

## Language Accessibility

**Complex/Unclear Language**: [Count]

Examples:
- [Location]: "[Complex phrase]"
  - **Issue**: Grade 10 reading level in grade 6 material
  - **Simplify to**: "[Simpler version]"

**Idioms Needing Explanation**: [List]

**Recommendations**: [Language simplification strategies]

## Positive Findings

**Strengths**:
- ✅ Diverse names used in Unit 2
- ✅ Multiple cultural perspectives in readings
- ✅ Accessible language in most materials
- ✅ Gender-neutral language throughout

## Priority Recommendations

### Priority 1 (Critical—Must Fix)
1. Remove stereotype in Item 3 (Asian student struggling with math)
2. Replace ski vacation scenario with equitable alternative
3. Diversify authority figures in examples

### Priority 2 (Important—Should Fix)
1. Balance gender in professional roles
2. Add cultural context explanations
3. Simplify complex phrases

### Priority 3 (Enhancement)
1. Add more diverse names
2. Include disability representation
3. Expand geographic diversity

## Revision Checklist

- [ ] All critical issues addressed
- [ ] Representation balanced across materials
- [ ] Assessment items culturally fair
- [ ] Language accessible to all students
- [ ] Stereotypes eliminated
- [ ] Multiple perspectives included

---

**Artifact Metadata**:
- **Artifact Type**: Bias Review Report
- **Critical Issues**: [Count]
- **Status**: [Pass/Needs Revision]
- **Next Phase**: Address issues, then Accessibility Review
```

### 6. CLI Interface

```bash
# Full bias review
/curriculum.review-bias --materials "curriculum-artifacts/"

# Assessment-only review
/curriculum.review-bias --focus "assessments" --items "assessment-items.md"

# Specific bias category
/curriculum.review-bias --focus "gender,race" --content "lessons/*.md"

# Help
/curriculum.review-bias --help
```

## Composition with Other Skills

**Input from**: All development and design skills

**Output to**:
- User for revisions
- `/curriculum.review-accessibility` (after bias issues addressed)

## Exit Codes

- **0**: No issues found
- **1**: Issues found, revisions needed
- **2**: Cannot load materials
- **3**: Invalid focus specified
