---
name: customer-experience
description: 인터뷰, 관찰, 제품 테스트를 통해 포괄적인 고객 경험 데이터를 생성합니다. 고객 여정 맵 작성 준비 시 사용하세요.
---

# 고객 경험 조사

## 목적

인터뷰, 관찰, 체험이라는 3가지 조사 방법을 통해 포괄적인 고객 경험 데이터를 생성합니다.

## 사용 시점

- 시장 조사와 고객경험 단계 정의가 완료된 후
- 고객 여정 맵 작성 전
- 고객의 실제 행동과 감정을 파악해야 할 때
- 사용자가 "고객 경험", "인터뷰", "관찰", "체험"을 언급할 때

## 필수 입력
- MVP 주제
- 타겟 고객 정의
- 고객경험 단계 (customer-journey-stages 결과)
- 시장 조사 결과 (선택사항)

## 조사 방법

### 1. 고객 경험 인터뷰

#### 인터뷰 개요
- **목적**: 서비스 기획 전 현재 환경에서의 고객 행동, 인식, 감정 반응 및 불편 사항 분석을 통한 현재 문제와 잠재 니즈 발굴
- **기간**: {기간}
- **대상 고객 그룹**: {고객 유형}
- **방법**: 1:1 심층 인터뷰
- **고객경험 단계**: {고객경험 단계}

#### 인터뷰 일정
| 인터뷰 일시 | 장소 | 인터뷰어 | 고객명 | 고객 프로필 |
|------------|------|----------|--------|------------|
| {날짜/시간} | {장소} | {인터뷰어} | {가명} | {나이, 직업, 특징} |

(10명 반복)

#### 고객별 인터뷰 내용

**고객 1: {가명} - {프로필}**

**{고객경험 단계 1}**
- **행동**: {이 단계에서 하는 행동}
- **생각**: {이 단계에서의 생각}
- **긍정적 느낌**: {좋은 점}
- **부정적 느낌**: {불편한 점, 문제}

**{고객경험 단계 2}**
- **행동**: {이 단계에서 하는 행동}
- **생각**: {이 단계에서의 생각}
- **긍정적 느낌**: {좋은 점}
- **부정적 느낌**: {불편한 점, 문제}

(모든 고객경험 단계 반복)

(10명의 고객 반복)

#### 핵심 인사이트
- **Pain Points**: (주요 문제점 3-5개)
- **Needs**: (핵심 니즈 3-5개)
- **기대 가치**: {고객이 기대하는 가치}
- **주목할 만한 인용구**: 고객의 실제 발언

### 2. 고객 관찰 결과

#### 관찰 개요
- **목적**: 서비스 기획 전 현재 환경에서의 고객 행동, 인식, 감정 반응 및 불편 사항 분석
- **기간**: {기간}
- **대상**: {관찰 대상}
- **방법**: 현장 관찰, Contextual Inquiry
- **고객경험 단계**: {고객경험 단계}

#### 관찰 일정
| 관찰 일시 | 장소 | 관찰자 | 관찰 대상 | 프로필 |
|----------|------|--------|----------|--------|
| {날짜/시간} | {장소} | {관찰자} | {가명} | {나이, 직업, 특징} |

(10회 관찰 반복)

#### 관찰 결과

**관찰 1: {가명} - {프로필}**

**{고객경험 단계 1}**
- **관찰된 행동**: {구체적 행동 기술}
- **어려움/문제**: {발견된 문제}
- **특이사항**: {주목할 점}

**{고객경험 단계 2}**
- **관찰된 행동**: {구체적 행동 기술}
- **어려움/문제**: {발견된 문제}
- **특이사항**: {주목할 점}

(모든 고객경험 단계 반복)

(10회 관찰 반복)

#### Pain Point 및 니즈 분석
| 관찰된 문제 | 도출된 니즈 |
|-----------|-----------|
| {문제 1} | {니즈 1} |
| {문제 2} | {니즈 2} |

#### 행동 패턴 분석
1. **패턴 1**: {패턴 설명}
   - 빈도: {높음/중간/낮음}
   - 시사점: {의미}

(3-5개 패턴 반복)

### 3. 고객 체험 테스트

#### 체험 개요
- **목적**: 기존 서비스/제품 사용 체험을 통한 문제점 및 개선 기회 발견
- **기간**: {기간}
- **대상 서비스/제품**: {체험 대상}
- **방법**: 실제 사용 체험
- **고객경험 단계**: {고객경험 단계}

#### 체험 일정 및 내용
| 날짜 | 서비스/제품명 | 구매/사용 내용 | 배송/포장 |
|------|-------------|--------------|----------|
| {날짜} | {이름} | {내용} | {평가} |

(10회 체험 반복)

#### 상세 체험 평가

**체험 1: {서비스/제품명}**

**{고객경험 단계 1}**
- **경험 내용**: {구체적 경험}
- **긍정적 측면**: {좋았던 점}
- **부정적 측면**: {불편했던 점}
- **만족도**: {5점 만점}

**{고객경험 단계 2}**
- **경험 내용**: {구체적 경험}
- **긍정적 측면**: {좋았던 점}
- **부정적 측면**: {불편했던 점}
- **만족도**: {5점 만점}

(모든 고객경험 단계 반복)

(10회 체험 반복)

## 종합 인사이트

### 주요 발견사항
1. {발견사항 1}
2. {발견사항 2}
3. {발견사항 3}

(3-5개)

### 고객 여정 단계별 Pain Points
| 고객경험 단계 | Pain Points | 빈도 |
|-------------|------------|------|
| {단계 1} | {pain point} | {높음/중간/낮음} |
| {단계 2} | {pain point} | {높음/중간/낮음} |

### 개선 기회 영역
1. **영역 1**: {영역}
   - 잠재적 영향: {높음/중간/낮음}
   - 개선 방향: {방향}

(3-5개)

### 우선순위 고객 니즈
1. **니즈 1**: {니즈} (중요도: ★★★)
2. **니즈 2**: {니즈} (중요도: ★★☆)
3. **니즈 3**: {니즈} (중요도: ★☆☆)

### 여정 맵 작성 권고사항
- {권고사항 1}
- {권고사항 2}
- {권고사항 3}

## 중요 가이드라인

- 각 조사 결과는 구체적이고 현실적이어야 함
- 실제 고객의 언어와 표현 사용
- 정성적 데이터와 정량적 데이터 균형
- Journey Map 작성에 바로 활용 가능하도록 상세하게 작성
- 구체적인 예시와 시나리오 포함
- 고객 익명성 유지하면서도 구체적으로 작성
- 모든 조사는 고객경험 단계를 기준으로 수행

## 도구 활용

### Sequential MCP 사용
복잡한 인터뷰 데이터 분석과 패턴 도출이 필요할 때 Sequential MCP를 활용하여 체계적으로 인사이트를 도출하세요.

## 결과 파일
- `define/관찰결과.md`
- `define/체험결과.md`
- `define/고객경험인터뷰결과.md`
- `define/고객경험인터뷰결과취합.md`

## 주의사항

- 인터뷰는 개방형 질문 위주
- 관찰은 객관적 사실 기록
- 체험은 직접 경험한 내용만 작성
- 고객경험 단계별로 데이터 구조화
- 10명 이상의 고객 데이터 확보 권장
- Pain point와 니즈를 명확히 구분
- 정량적 지표 (만족도, 빈도) 포함

## 다음 단계

고객 경험 조사 완료 후:
1. 고객 여정 맵 작성 (이 데이터를 기반으로)
2. 문제 가설 정의
3. 킹핀 문제 및 방향성 정의
