---
name: customer-experience
description: Expert customer service guidance from Madame Zelda for managing guest interactions, queue flow, and creating memorable festival experiences
---

# Customer Experience Expertise

**Expert:** Madame Zelda  
**Specialty:** Guest Relations, Queue Management, VIP Service

This skill provides actionable guidance for delivering exceptional customer experiences at festivals and events.

## 🎭 Handling Difficult Customers

### The Three-Step Approach

1. **Acknowledge First** - Validate their feelings before proposing solutions
   - "I understand this is frustrating..."
   - "You're absolutely right to be concerned about..."
   - "Thank you for bringing this to my attention..."

2. **Never Say 'No' - Offer Alternatives**
   - ❌ "We can't do that"
   - ✅ "Here's what we CAN do for you..."
   - ✅ "Let me offer you an alternative that might work even better..."

3. **Turn Complaints into Compliments**
   - Use the VIP upgrade technique
   - Provide unexpected value
   - Make them feel special, not just satisfied

### Wait Time Recovery Protocol

**If someone has been waiting 20+ minutes:**
- Immediately offer "VIP reading" to bump them ahead
- Acknowledge the wait explicitly: "Thank you for your patience"
- Add extra value: extend their session by 30 seconds
- Create a memorable moment they'll share positively

### Customer Personality Types

#### The Skeptic
- **Approach:** "Mysterious Stranger" fortune style
- **Technique:** Lean into the mystery, don't try to convince
- **Language:** "The cards suggest..." (not "I know...")
- **Outcome:** They often become the biggest advocates

#### Kids Under 10
- **Approach:** "Adventure Quest" style
- **Technique:** Frame fortunes as exciting journeys
- **Engagement:** Ask them questions, make it interactive
- **Parent Impact:** Parents love seeing their kids engaged

#### The Chatty Customer
- **Approach:** Boundaries with grace
- **Technique:** Offer "extended reading" slot for later
- **Language:** "I'd love to continue this - let me book you for 3pm"
- **Benefit:** Keeps line moving while honoring their interest

## ⏱️ Queue Management

### Target Timing
- **Standard reading:** 2-3 minutes maximum
- **Rush period:** 90 seconds is acceptable with pre-written fortunes
- **VIP/Extended:** 5 minutes maximum

### Rush Period Protocol
**Pre-Written Fortune System:**
- Always have 5 generic but meaningful fortunes ready
- Rotate them to avoid repetition
- Personalize with one unique detail per customer
- Keep them positive and actionable

**Example Pre-Written Fortunes:**
1. "A new opportunity awaits - be ready to say yes"
2. "Someone from your past will bring unexpected joy"
3. "Your creativity will solve a challenging problem soon"
4. "Trust your instincts in an upcoming decision"
5. "A small kindness you show will return tenfold"

### Visual Time Management
- Use signage: "Current wait: ~15 minutes"
- Update every 30 minutes during peak times
- Never over-promise ("better to delight than disappoint")
- Provide alternative activities: "Visit the ice rink while you wait"

## 🌟 VIP Experience Tips

### Personalization Techniques
- **Remember repeats:** "Welcome back! How did that opportunity work out?"
- **Notice details:** Comment on a unique accessory or smile
- **Create callbacks:** "Remember the card I drew for you - the sun..."

### Maintaining Ambiance
**Even During Busy Times:**
- Keep lighting consistent
- Maintain mystical language
- Never rush the "reveal moment"
- End with a ritual (hand gesture, card placement)

### The Opening Script
Busy or not, always:
1. Greet warmly: "Welcome, I've been expecting you..."
2. Create presence: Make eye contact, pause
3. Transition: "Let's see what the cards reveal..."

### The Closing Script
- Summarize in one sentence
- Provide one actionable insight
- Create callback: "Remember this card when..."
- Warm goodbye: "May your path be bright"

## 🎯 Quick Decision Trees

### Customer Complaint Resolution

```
Customer Issue?
│
├─ Wait Time Related
│  ├─ <15 min → Acknowledge, set expectations
│  ├─ 15-20 min → Apologize, offer timeline update
│  └─ 20+ min → VIP BUMP + extra value
│
├─ Service Quality Related
│  ├─ Fair criticism → Acknowledge, offer redo or refund
│  ├─ Unrealistic → Explain gently, offer alternative
│  └─ Abusive → Escalate to supervisor
│
└─ Other Guest Conflict
   ├─ Guests bothering each other → Mediate, separate
   ├─ Lost/Found issue → [See: lost-and-found skill]
   └─ Safety concern → [See: security-vendor-management skill]
```

### Personality Type Selection

```
Observe Customer:
│
├─ Skeptical/Doubtful Body Language
│  └─ Use "Mysterious Stranger" Style
│     - Lean into mystery
│     - Don't try to convince
│     - Let them discover
│
├─ Young Child (Under 10)
│  └─ Use "Adventure Quest" Style
│     - Interactive questions
│     - Exciting language
│     - Engage parents too
│
├─ Very Talkative/Social
│  └─ Set Boundaries Gracefully
│     - Offer extended slot
│     - Keep experience warm
│     - Protect queue flow
│
└─ Nervous/Anxious
   └─ Use Reassuring Approach
      - Extra warmth
      - Positive fortunes
      - Calming pace
```

## 📋 Templates & Forms

See the following templates in `templates/`:
- `customer-feedback-form.md` - Collect improvement ideas
- `vip-experience-checklist.md` - Ensure consistent VIP service
- `wait-time-log.md` - Track and optimize queue flow

## 🔗 Related Skills

- **Security Issues:** [See: security-vendor-management]
- **Lost Items:** [See: lost-and-found]
- **Communication/Marketing:** [See: festival-marketing]

---

**Remember:** Every interaction is an opportunity to create a story worth sharing. Make it magical. ✨
