---
name: customer-support-120
description: 顧客期待を120%超える神対応カスタマーサポート。6つの教育要素+太陽スタイル統合で2000文字以上の心を動かす返信を作成。
version: "1.0.0"
author: TAISUN
category: marketing
tags: [customer-support, copywriting, taiyo-style, education, high-satisfaction]
dependencies: [taiyo-analyzer]
---

# Customer Support 120% Skill

## Overview

顧客の期待を**120%超える**カスタマーサポート返信作成スキル。
6つの教育要素を太陽スタイルで自然に組み込み、**2000文字以上**の心を動かす返信を生成。

## When to Use

```
「120%のカスタマーサポート返信を作成して」
「神対応の返信を書いて」
「/customer-support-120」
「お客様への返信を太陽スタイルで」
```

## 120%対応の定義

```
┌─────────────────────────────────────────────────────────────┐
│                    120% Support Model                        │
├─────────────────────────────────────────────────────────────┤
│                                                             │
│  通常対応 (100%)                                             │
│  ├── 質問への回答                                            │
│  └── 基本的な丁寧さ                                          │
│                                                             │
│  120%対応 (+20%)                                             │
│  ├── 質問の背景にある本当の悩みに寄り添う                     │
│  ├── 聞かれていないけど役立つ情報を先回り提供                 │
│  ├── 次のステップを具体的に示す                               │
│  ├── 感情的なサポートと励まし                                 │
│  └── 「この人に相談してよかった」と思わせる                   │
│                                                             │
└─────────────────────────────────────────────────────────────┘
```

## 6つの教育要素（太陽統合版）

### 要素配置マトリクス

| 要素 | 目的 | 配置位置 | 太陽パターン |
|-----|------|---------|-------------|
| **信用** | 信頼構築 | 冒頭〜本文前半 | 社会的証明 + 権威トリガー |
| **目的** | 理想未来 | 本文中盤 | 希望・快楽トリガー |
| **問題** | 現状認識 | 本文前半 | 損失回避トリガー（軽め）|
| **手段** | 差別化 | 本文中盤〜後半 | 独自性キラーワード |
| **投資** | 価値認識 | 本文後半 | 実証済み系 |
| **行動** | 次ステップ | 締めくくり | 行動喚起型語尾 |

### 各要素の実装方法

#### 1. 信用（Trust Building）
**目的**: 「この人なら信頼できる」と感じさせる

**太陽パターン適用**:
- 具体的な数字を使用（「◯名の方が同じ悩みを...」）
- 第三者の声を引用風に
- 経験に基づく発言

**例文**:
```
実は、これまで1,247名以上の方から
同じようなご質問をいただいてきました。

その中で見えてきた「成功する方の共通点」を
今日は特別にお伝えしますね。
```

#### 2. 目的（Vision Painting）
**目的**: 理想の未来を描かせる

**太陽パターン適用**:
- 希望系キラーワード
- 具体的なイメージ喚起
- 五感への訴求

**例文**:
```
◯◯さんが、3ヶ月後に
「あの時、相談してよかった」と
笑顔でおっしゃっている姿が目に浮かびます。

きっとその頃には、今の悩みが
嘘のように感じられるはずです。
```

#### 3. 問題（Problem Awareness）
**目的**: 現状の課題を明確化（優しく）

**太陽パターン適用**:
- 共感・同意誘導型語尾
- 読者巻き込み型
- 軽い恐怖トリガー（脅さない）

**例文**:
```
実は、多くの方がこの段階で
「もう少し様子を見よう」と
先延ばしにしてしまうんです。

でも、◯◯さんは今日、
こうして質問してくださった。

それだけで、もう一歩先に
進んでいらっしゃいます。
```

#### 4. 手段（Solution Differentiation）
**目的**: 独自の解決策を提示

**太陽パターン適用**:
- 専門性キラーワード
- 権威トリガー
- 断定形語尾

**例文**:
```
ここで重要なのは、
一般的な方法とは少し違うアプローチです。

私たちが10年かけて検証してきた方法では、
まず◯◯から始めることをお勧めしています。

なぜなら、この順番が
最も成果が出やすいことが
データで証明されているからです。
```

#### 5. 投資（Value Recognition）
**目的**: 時間・労力の価値を認識させる

**太陽パターン適用**:
- 実証済み系キラーワード
- 対比・二極化（やるvs.やらない）
- 仮定・条件型語尾

**例文**:
```
もし今日からこの方法を実践されたら、
3ヶ月後には大きな違いが生まれます。

今ここに投資する時間は、
将来の◯◯さんへの最高のプレゼントです。

逆に、何もしなければ
1年後も同じ場所に立っているかもしれません。
```

#### 6. 行動（Action Trigger）
**目的**: 具体的な次のステップを示す

**太陽パターン適用**:
- 行動喚起型語尾
- 簡単・シンプル系キラーワード
- 今すぐ系

**例文**:
```
では、今日からできる
最初の一歩をお伝えしますね。

まずは◯◯をしてみてください。
たった5分でできることです。

それだけで、明日からの景色が
変わって見えるはずです。
```

## 返信構造（2000文字以上）

### 全体構成

```
┌─────────────────────────────────────────┐
│  冒頭部 (200-300文字)                    │
│  ├── 感謝・ねぎらい                      │
│  ├── 共感表明                            │
│  └── 質問の核心引用                      │
├─────────────────────────────────────────┤
│  本文部 (1400-1600文字)                  │
│  ├── 信用構築パート                      │
│  ├── 問題の明確化                        │
│  ├── 解決の方向性（目的提示）            │
│  ├── 具体的手段の説明                    │
│  ├── 投資価値の提示                      │
│  └── 補足情報・先回り回答                │
├─────────────────────────────────────────┤
│  締めくくり部 (300-400文字)              │
│  ├── 行動促進                            │
│  ├── 励まし・エール                      │
│  ├── 継続サポート約束                    │
│  └── 署名                                │
└─────────────────────────────────────────┘
```

### 文字数配分

| セクション | 文字数 | 比率 | 含む要素 |
|-----------|-------|-----|---------|
| 冒頭部 | 200-300 | 12% | 共感、信用の導入 |
| 本文部 | 1400-1600 | 75% | 全6要素 |
| 締めくくり | 300-400 | 13% | 行動、励まし |

## 太陽スタイル適用ルール

### 語尾バランス（サポート版）
```
共感・同意誘導型: 25-30%
断定形: 35-40%
疑問形: 15-20%
行動喚起型: 10-15%
その他: 5-10%
```

### 文章リズム
```
短文: 50%（通常より多め = 読みやすさ重視）
中文: 35%
長文: 15%

平均文長: 18-22文字（通常より短め）
1文1行率: 95%以上
空白行使用: 98%以上（通常より多め）
```

### 禁止キラーワード（サポートでは不適切）
- 過度な恐怖系（「人生終了」「どん底」等）
- 過度な緊急性（「今すぐ申し込まないと」等）
- 価格・販売促進系
- 限定性煽り

### 推奨キラーワード
- 共感系（「わかります」「同じ経験が」）
- 安心系（「大丈夫です」「ご安心ください」）
- 応援系（「応援しています」「きっとできます」）
- 具体系（「具体的には」「例えば」）

## 対応パターン別テンプレート

### パターン1: 初歩的な質問

**特徴**: 基本的な内容、初心者からの質問
**アプローチ**: 丁寧に、馬鹿にせず、自信を持たせる

**構成**:
1. 「素晴らしい質問です」で始める
2. 基本から丁寧に説明
3. 「最初は誰でも」で安心感
4. 次のステップを明確に

### パターン2: 複雑な悩み相談

**特徴**: 感情的、複数の要素が絡む
**アプローチ**: まず感情を受け止め、整理してあげる

**構成**:
1. 感情への共感を十分に
2. 悩みを分解・整理
3. 優先順位を示す
4. 一つずつ解決策を
5. 寄り添う姿勢で締める

### パターン3: クレーム・不満

**特徴**: 怒り、失望、要求
**アプローチ**: 誠実に受け止め、解決に全力

**構成**:
1. 謝罪（言い訳なし）
2. 状況の確認・整理
3. 具体的な解決策
4. 再発防止の約束
5. 感謝で締める

### パターン4: 成果報告・感謝

**特徴**: ポジティブ、共有したい気持ち
**アプローチ**: 一緒に喜び、さらなる成長を促す

**構成**:
1. 心からの祝福
2. 努力の称賛
3. 成功要因の分析
4. 次のステージへの示唆
5. 継続応援の約束

## 品質チェックリスト

### 必須項目（全て満たすこと）
- [ ] 2000文字以上
- [ ] 6つの教育要素すべて含む
- [ ] 質問の核心を引用している
- [ ] 具体的な次のステップがある
- [ ] 1文1行、適切な空白行
- [ ] 禁止表現を使用していない
- [ ] 署名がある

### 推奨項目（80%以上）
- [ ] 数字を使った具体例
- [ ] 経験に基づく発言
- [ ] 先回りの補足情報
- [ ] 励ましの言葉
- [ ] 継続サポートの約束

## 絶対禁止事項

### 表現禁止
- 具体的金額の言及
- 「必ず」「確実に」「100%」等の断定保証
- 内部用語（【目的】【問題】等の要素名）
- 装飾記号（*、**、_、#、-）をテキスト内で使用
- ダブルクオテーション（""）の多用
- 購入促進・セールストーク
- 限定性・緊急性の煽り

### 態度禁止
- 上から目線
- 説教くさい
- 事務的・テンプレ感
- 感情を無視した論理だけの回答

## 出力フォーマット

```
[担当者名]です。

「[質問の核心部分を1-2行で引用]」

とのことですね。

[冒頭部: 共感・感謝・信用導入]

[本文部: 6要素を自然に組み込んだ回答]
（適切な空白行で区切りながら）

[締めくくり部: 行動促進・励まし]

いつでもご相談くださいね。
◯◯さんのことを、心から応援しています。

[担当者名]
```

## 関連スキル

- `customer-support` - 基本版カスタマーサポート
- `taiyo-analyzer` - スコアリング・品質チェック
- `taiyo-style` - 太陽スタイル適用
- `copywriting-helper` - コピーライティング支援

## 使用例

### 基本使用
```
ユーザー: この質問に120%対応で返信して
「講座を始めたのですが、思うように進みません...」

→ 6要素分析 → 2000文字以上の返信作成 → 品質チェック
```

### スタイル指定
```
ユーザー: 企業スタイルで120%対応して

→ 丁寧語ベース、データ重視のスタイルで作成
```

### 改善依頼
```
ユーザー: この返信を120%対応に改善して
[既存の返信文]

→ 現状分析 → 不足要素特定 → リライト
```
