# レベル1: 基礎

## 概要

データ変換の基本概念と用語、スキーマ設計の基礎を整理する。

SKILL.md と本レベルのみで完結する基本運用を対象とする。

## 前提条件

- SKILL.md の概要とワークフローを読了している
- 入出力データの概要が把握できている

## 詳細ガイド

### 使用タイミング

- 要件整理の初期段階
- スキーマ整理の前段階

### 必要な知識

- 対象領域: データ変換の基本概念
- 主要概念: スキーマ、マッピング、ETL
- 実務指針: 要件テンプレートで整理する

### 判断基準

- 避けるべき判断: スキーマなしで変換を設計する

### 成果物の最小要件

- 入出力と目的が明記されている
- 主要テンプレート: `assets/schema-mapping-template.md`

### 主要リソース

- `SKILL.md`: 基本方針とワークフロー
- `references/schema-mapping-guide.md`: マッピング指針

### 主要テンプレート

- `assets/schema-mapping-template.md`: 参照のみ

## 実践手順

1. 入出力スキーマを整理する
2. 変換目的を明文化する
3. 要件メモを作成する

## チェックリスト

- [ ] 入出力が整理されている
- [ ] 変換目的が明記されている
- [ ] 要件メモが作成されている
