# レベル3: 応用

## 概要

複雑なパイプライン設計と最適化を扱う。

## 前提条件

- レベル2の設計成果物が揃っている
- 変換対象が明確になっている

## 詳細ガイド

### 使用タイミング

- 多段ETLの設計が必要なとき
- パフォーマンス最適化を行うとき

### 必要な知識

- 分割実行と再処理
- スループットの最適化

### 主要リソース

- `references/etl-design-patterns.md`: パイプライン設計
- `references/data-quality-metrics.md`: 品質指標

### 成果物要件

- 最適化方針が明記されている
- 再実行方針が整理されている

## 実践手順

1. ボトルネックを特定する
2. 分割実行方針を決める
3. 再処理フローを整理する

## チェックリスト

- [ ] 最適化方針が明記されている
- [ ] 再実行方針が定義されている
- [ ] 品質指標が整理されている
