# Deal Data Sources Reference

Sources for pharmaceutical M&A, licensing, and partnership data.

## Primary Sources

### SEC Filings (United States)

**URL**: https://www.sec.gov/edgar/search/

**Key Forms**:
| Form | Description | Use Case |
|------|-------------|----------|
| 8-K | Current report | Deal announcements |
| 10-K | Annual report | Overview of partnerships |
| 10-Q | Quarterly report | Ongoing activities |
| 20-F | Foreign registration | International companies |
| DEF 14A | Proxy statement | Deal details |
| S-1 | Registration | IPO details |

**API**: No official API, but third-party available
**Update**: Real-time
**Coverage**: US companies only

### Company Press Releases

**Sources**:
| Company | URL | Coverage |
|---------|-----|----------|
| Pfizer | https://www.pfizer.com/news | Global deals |
| Novartis | https://www.novartis.com/news | Global deals |
| Roche | https://www.roche.com/media | Global deals |
| AstraZeneca | https://www.astrazeneca.com/media | Global deals |

**Limitations**: PR-focused, may lack full financial details

## Commercial Databases

### BioCentury

**URL**: https://www.biocentury.com/

**Coverage**:
- M&A transactions
- Licensing deals
- IPOs
- Financings

**Update**: Daily
**Cost**: Subscription
**Depth**: High

### Citeline (formerly PharmaProjects)

**URL**: https://citeline.com/

**Coverage**:
- Global pipeline
- Deal tracking
- Company profiles

**Update**: Weekly
**Cost**: Subscription
**Depth**: Very high

### DealForma

**URL**: https://www.dealforma.com/

**Coverage**:
- Life sciences deals
- Valuation data
- Deal structures

**Update**: Real-time
**Cost**: Freemium
**Depth**: Medium

### Recap

**URL**: https://www.recap.com/

**Coverage**:
- Life sciences transactions
- Company valuations
- Market trends

**Update**: Daily
**Cost**: Freemium
**Depth**: Medium

## Free Sources

### Crunchbase

**URL**: https://www.crunchbase.com/

**Coverage**:
- Private company financings
- M&A
- IPOs
- Company profiles

**API**: Available (limited free)
**Update**: Continuous
**Coverage**: Biotech focus limited

### PitchBook

**URL**: https://pitchbook.com/

**Coverage**:
- Private capital markets
- M&A
- Venture capital

**Update**: Daily
**Cost**: Subscription
**Depth**: High

### Google News

**Query**: `pharma M&A source:news`

**Update**: Real-time
**Cost**: Free
**Depth**: Variable

## Regional Sources

### Europe

| Source | URL | Focus |
|--------|-----|-------|
| EMA | https://www.ema.europa.eu/ | Regulatory |
| Europa | https://europa.eu/ | Policy |
| National registers | Various | Country-specific |

### Asia

| Source | URL | Focus |
|--------|-----|-------|
| China NMPA | http://www.nmpa.gov.cn/ | Regulatory |
| Japan PMDA | https://www.pmda.go.jp/ | Regulatory |
| India CDSCO | https://cdsco.gov.in/ | Regulatory |

### Latin America

| Source | URL | Focus |
|--------|-----|-------|
| Brazil ANVISA | http://portal.anvisa.gov.br/ | Regulatory |
| Mexico COFEPRIS | https://www.gob.mx/cofepris | Regulatory |

## Conference Abstracts

### ASCO (American Society of Clinical Oncology)

**URL**: https://meetinglibrary.asco.org/

**Coverage**:
- Clinical trial results
- Partnership announcements
- Pipeline updates

**Update**: Annual meeting + year-round

### ESMO (European Society for Medical Oncology)

**URL**: https://www.esmo.org/

**Coverage**: Similar to ASCO, European focus

### JP Morgan Healthcare Conference

**URL**: https://www.jpmhealth.com/

**Coverage**:
- Corporate presentations
- Pipeline updates
- Deal announcements

**Update**: Annual (January)

## API Access

### BioCentury API

**Documentation**: https://api.biocentury.com/

**Endpoints**:
- Deals feed
- Company profiles
- News articles

**Authentication**: API key required

### Crunchbase API

**URL**: https://data.crunchbase.com/v3/

**Endpoints**:
- Organizations
- Acquisitions
- Deals

**Rate limit**: Varies by tier

### SEC EDGAR API

**Base URL**: https://www.sec.gov/Archives/edgar/data/

**No official API**, but third-party available:
- SEC-API (unofficial)
- Quandl (financial data)

## Deal Verification

### Cross-Check Process

```
1. Initial source (press release)
   ↓
2. SEC filing verification (if public)
   ↓
3. Company confirmation
   ↓
4. Multiple source agreement
   ↓
5. Record in database
```

### Red Flags

| Red Flag | Action |
|----------|--------|
| Single source only | Verify elsewhere |
| Round numbers | Likely estimate |
| No SEC filing | May be incomplete |
| Withdrawn announcement | Update status |

## Data Quality Issues

### Common Issues

| Issue | Example | Mitigation |
|-------|---------|------------|
| Delayed SEC filing | Form 8-K filed late | Mark as pending |
| Undisclosed value | "Undisclosed" | Estimate from similar deals |
| Currency confusion | USD vs EUR | Always verify |
| Double counting | Same deal multiple sources | Deduplicate |
| Changed status | Deal terminated | Update status |

### Data Normalization

**Standard fields**:
- Deal type (acquisition, licensing, partnership)
- Deal value (USD, convert if needed)
- Deal structure (upfront, milestones, royalties)
- Stage (preclinical, Phase 1-3, approved)
- Therapeutic area
- Geography

## Tracking Workflow

### Daily Monitoring

```python
def check_daily_feeds():
    sources = [
        "sec_8k",
        "press_releases",
        "bio feeds",
        "news_aggregators"
    ]

    for source in sources:
        new_deals = fetch(source)
        for deal in new_deals:
            if is_relevant(deal):
                verify_deal(deal)
                add_to_database(deal)
                notify_if_important(deal)
```

### Alert Criteria

**High priority**:
- Value > $500M
- Public company involved
- Phase 3 or approved asset
- Oncology or rare disease

**Medium priority**:
- Value $100-500M
- Private company
- Phase 2 asset

## Competitive Intelligence

### Monitoring Setup

| Competitor | What to Track | Sources |
|------------|---------------|---------|
| Pfizer | All oncology deals | Press releases, SEC |
| Novartis | CAR-T, gene therapy | Press releases, SEC |
| Roche | Diagnostics deals | Press releases, SEC |

### Alert Types

1. **New competitor entry** - Target acquisition
2. **Competitor exit** - Divestiture
3. **Partnership shift** - New collaboration
4. **Pipeline expansion** - New indication

## Reference

- **SEC EDGAR**: https://www.sec.gov/edgar/
- **BioCentury**: https://www.biocentury.com/
- **DealForma**: https://www.dealforma.com/
- **Crunchbase**: https://www.crunchbase.com/
