---
name: debug-helper
description: 调试助手技能。当用户遇到 Bug、错误信息、程序异常、性能问题需要排查，或需要分析日志、定位问题根因时使用此技能。
---

# Debug Helper

系统化的调试方法论，帮助快速定位和解决问题。

## 调试流程

1. **复现问题**：确认问题可稳定复现
2. **收集信息**：错误信息、日志、环境
3. **缩小范围**：二分法定位问题区域
4. **分析根因**：找到真正原因而非表象
5. **验证修复**：确认问题已解决

## 信息收集清单

### 必要信息
- 完整错误信息和堆栈跟踪
- 复现步骤（最小化）
- 环境信息（OS、语言版本、依赖版本）
- 最近的代码变更

### 日志分析
```bash
# 查找错误日志
grep -i "error\|exception\|fail" app.log

# 查看特定时间段
grep "2024-01-15 10:" app.log

# 追踪请求 ID
grep "req-123456" app.log
```

## 常见问题类型

### 🔴 运行时错误
- NullPointerException → 检查空值处理
- IndexOutOfBounds → 检查数组/列表边界
- TypeError → 检查类型转换

### 🟡 逻辑错误
- 条件判断错误 → 检查边界条件
- 循环问题 → 检查终止条件
- 状态管理 → 检查状态变更时机

### 🟠 性能问题
- 响应慢 → 检查 N+1 查询、循环内IO
- 内存泄漏 → 检查未释放资源
- CPU 高 → 检查死循环、低效算法

## 调试技巧

### 二分法定位
```
1. 在中间位置添加日志
2. 确定问题在前半还是后半
3. 重复直到定位到具体行
```

### 橡皮鸭调试
向他人（或自己）解释代码逻辑，往往能发现问题。

### 最小化复现
移除无关代码，构建最小可复现案例。

## 输出格式

```markdown
## 问题诊断报告

### 问题描述
[简述问题现象]

### 根因分析
[问题的真正原因]

### 解决方案
[具体的修复步骤]

### 预防措施
[如何避免类似问题]
```
