# December Pipeline Priming - Daily Sync Integration

Add these blocks to your daily sync and Pipeline OS for campaign tracking.

---

## Morning Ritual Addition (9am)

Add after standard pipeline check:

```
═══════════════════════════════════════
DECEMBER PRIMING CHECK
═══════════════════════════════════════

□ Check: Any email replies overnight?
  → Action: Respond within 2 hours

□ Check: LinkedIn notifications?
  → Action: Engage with comments, DM warm leads

□ Check: Today's calendar event?
  → Action: Execute scheduled campaign task

□ Check: Brand Scout queue?
  → Action: If <15 reports, add 2 targets today

CAMPAIGN PULSE:
- Emails sent: [X] / 25 target
- LinkedIn posts: [X] / 6 target
- Replies received: [X]
- Calls booked: [X] / 8 target
```

---

## Pipeline OS Addition

Add new section to _PIPELINE_TRACKER.csv or daily log:

### Campaign Tracker Columns

```csv
Date,Action,Tool,Target_Company,Status,Engagement,Notes
2024-12-16,LinkedIn Post 1,LinkedIn,N/A,Posted,X likes X comments,Volume Reality
2024-12-16,Brand Scout,Claude Code,Company A,Complete,N/A,Pain point: zone 8 pricing
2024-12-17,Email 1,Superhuman,Company A,Sent,Opened,Waiting for reply
```

### Weekly Summary Block

Add to Friday review:

```
═══════════════════════════════════════
PRIMING CAMPAIGN: WEEK OF [DATE]
═══════════════════════════════════════

ACTIVITY:
- Brand Scouts completed: [X]
- Email 1s sent: [X]
- Email 2s sent: [X]
- LinkedIn posts: [X]
- LinkedIn DMs: [X]

ENGAGEMENT:
- Email opens: [X]%
- Email replies: [X]
- LinkedIn engagers: [X]
- DM conversations: [X]

PIPELINE IMPACT:
- New leads identified: [X]
- Discovery calls booked: [X]
- Estimated pipeline value: $[X]

HOT PROSPECTS:
1. [Company] - [Why hot]
2. [Company] - [Why hot]
3. [Company] - [Why hot]

NEXT WEEK FOCUS:
- [Priority 1]
- [Priority 2]
- [Priority 3]
```

---

## HubSpot Integration

### Create Custom Properties

1. **Priming Campaign Touch** (Multi-select)
   - Email 1 - Volume Reality
   - Email 2 - Peak Check-in
   - Email 3 - GRI Primer
   - LinkedIn Engaged
   - DM Conversation

2. **Priming Campaign Stage** (Dropdown)
   - Seeded (Email 1 sent)
   - Engaged (Opened/Replied)
   - Warm (Positive reply)
   - Booked (Discovery scheduled)
   - Converted (In pipeline)

3. **GRI Carrier** (Dropdown)
   - UPS
   - FedEx
   - USPS
   - DHL
   - Other

### Create Saved View

Filter: Priming Campaign Stage is not empty
Sort: Last activity date (descending)
Columns: Company, Contact, Priming Stage, Last Touch, GRI Carrier

---

## Quick Commands for Claude Code

### Daily Check
```
Check December priming campaign status. 
What's scheduled for today?
Any replies to respond to?
```

### Generate Today's Content
```
Generate today's priming campaign content.
[LinkedIn post / Email batch / Follow-up]
```

### Weekly Review
```
Generate weekly priming campaign summary.
Include metrics vs targets and hot prospects.
```

### Brand Scout + Email Combo
```
Run Brand Scout for [COMPANY] and draft Email 1 using the December priming template.
```

---

## Automation Triggers (N8N)

### Trigger 1: Email Reply Detection
```
When: HubSpot email reply received
If: Contact has "Priming Campaign Touch" property
Then: 
  - Slack notification to Brett
  - Update "Priming Campaign Stage" to "Engaged"
  - Add to "Hot Prospects" list
```

### Trigger 2: LinkedIn Engagement
```
When: Manual trigger (daily at 9am)
Then:
  - Remind Brett to check LinkedIn notifications
  - Log engagement in daily tracker
```

### Trigger 3: GRI Day Blast
```
When: January 21, 2025 at 9:00 AM
Then:
  - Send Follow-Up 1 to all Priming contacts
  - Post LinkedIn #6
  - Slack alert: "GRI DAY - HARVEST TIME"
```

---

## Success Dashboard

Track these metrics weekly:

| Metric | Week 1 | Week 2 | Week 3 | Week 4 | Week 5 | Week 6 | Target |
|--------|--------|--------|--------|--------|--------|--------|--------|
| Brand Scouts | | | | | | | 25 |
| Email 1s Sent | | | | | | | 25 |
| Email 2s Sent | | | | | | | 20 |
| Email 3s Sent | | | | | | | 20 |
| LinkedIn Posts | | | | | | | 6 |
| Open Rate | | | | | | | 40% |
| Reply Rate | | | | | | | 10% |
| Calls Booked | | | | | | | 8 |
| Pipeline Value | | | | | | | $500K |

---

## Phase Transitions

### End of Phase 1 (Dec 31)
Checkpoint:
- [ ] 15+ Brand Scout reports complete
- [ ] 15+ Email 1s sent
- [ ] 10+ Email 2s sent
- [ ] 4 LinkedIn posts live
- [ ] Warm leads flagged for January

### End of Phase 2 (Jan 20)
Checkpoint:
- [ ] Email 3 sent to all contacts
- [ ] LinkedIn Post #5 live
- [ ] 3+ discovery calls completed
- [ ] GRI content prepped for Jan 21

### End of Phase 3 (Jan 31)
Checkpoint:
- [ ] All follow-ups complete
- [ ] 8+ discovery calls total
- [ ] 6+ deals in pipeline
- [ ] $500K+ pipeline value
- [ ] Campaign retrospective complete
