---
name: december-pipeline-priming
description: Strategic pipeline priming campaign for Q1 2026. Uses 38 Questions framework as thought leadership content and cold outreach hooks. Generates LinkedIn posts, Brand Scout-informed emails, and January follow-up sequences timed around GRI announcements. Triggers on "pipeline priming", "December outreach", "GRI campaign", "LinkedIn post", "cold email sequence", "January follow-up", "prime the pump", "discovery prep", or "GRI prep".
---

# December Pipeline Priming Campaign

Strategic campaign to warm pipeline before January GRI hits. Plant seeds in December, harvest in January.

## Campaign Philosophy

**December Reality:** Nobody switches carriers during peak. They're too busy.

**The Play:** Use 38 Questions as conversation starters that position you as the expert who asks the right questions BEFORE the rate increase panic.

**Goal:** When GRI hits January 21, your phone rings first.

## Campaign Timeline

```
Dec 16-31: Plant seeds (LinkedIn + first touches)
Jan 1-20: Nurture (follow-ups referencing December touchpoints)
Jan 21+: Harvest (GRI panic drives urgency to warm pipeline)
```

## Quick Commands

**Generate LinkedIn post:**
```
Generate a LinkedIn post using the December Pipeline Priming skill.
Topic: [Volume Reality / Contract Question / Peak Performance / Implementation Barriers / Zone Distribution]
```

**Generate Brand Scout email:**
```
Write a December priming email for [COMPANY] using their Brand Scout data:
[paste Brand Scout summary]
```

**Generate January follow-up:**
```
Write a January GRI follow-up for [COMPANY]. 
December touchpoint: [what you sent/posted]
```

## Content Assets

- **Discovery Call Prep (GRI 2026)** → `references/discovery-call-prep-gri-2026.md` ⭐ NEW
- **Performance Analytics** → `references/performance-analytics.md` ⭐ NEW (calibrated benchmarks)
- LinkedIn posts (6-post series) → `references/linkedin-posts.md`
- Email templates (3-email December sequence) → `references/email-templates.md`
- January follow-up sequence → `references/january-followup.md`
- Full campaign calendar → `references/campaign-calendar.md`
- Image prompts → `references/image-prompts-firstmile.md`

## LinkedIn Pre-Publish Workflow (MANDATORY)

**Before publishing ANY LinkedIn post:**

1. **Load rubric**: `nate-jones-deliberate-practice/references/11-linkedin-content-rubric.md`
2. **Load benchmarks**: `references/performance-analytics.md`
3. **Score all 6 dimensions** with quoted evidence:
   - Hook Strength
   - Insight Density
   - Visual Clarity
   - Brand Alignment
   - CTA Quality
   - 38Q Integration
4. **Verify score is 25+** (if 22-24, improve weakest dimension first)
5. **Check patterns**:
   - Hook uses "Your [X] should..." or question format (NOT number-led)
   - CTA offers value exchange ("Drop X, I'll tell you Y")
   - Visual passes 2-second comprehension test
6. **Generate image prompt** using `references/image-prompts-firstmile.md`
7. **Publish and track** in `campaign-assets/MASTER_CAMPAIGN_CHECKLIST.md`

**Post-publish (48-72 hours):**
1. Export LinkedIn PostAnalytics
2. Update `references/performance-analytics.md` with new data
3. Calculate rubric-to-performance correlation
4. Extract learnings for future posts

**DO NOT publish posts scoring <25 without revision.**

## 2026 GRI Key Dates

| Carrier | GRI Effective | Real Impact |
|---------|---------------|-------------|
| UPS | Dec 22, 2025 | Captures peak at higher rates |
| DHL | Jan 1, 2026 | 5-7% increase |
| FedEx | Jan 6, 2026 | Post-peak timing |

**Headline vs. Reality:** 5.9% announced → 7-12% effective increase (surcharge stacking)

## Integration Points

- **Brand Scout:** Use intel to personalize email templates
- **CVM 38 Questions:** Source framework for all content (full 38Q with GRI hooks in discovery prep)
- **Daily Sync:** Check campaign progress in morning ritual
- **HubSpot:** Track touches and responses
- **Practice Gym:** Score discovery calls against Rubric 3 (see discovery prep)
- **GRI Intelligence:** 60+ sources on 2026 rate increases in discovery prep

## Discovery Prep Quick Command

**Pre-call prep with GRI hooks:**
```
Load the GRI 2026 Discovery Prep Sheet for my call with [COMPANY].
```

**Post-call scoring:**
```
Score my discovery call against the GRI 2026 prep sheet. Here's what I captured:
[paste notes]
```
