# December Pipeline Priming Campaign - Master Checklist

## Campaign Overview
**Duration**: December 16, 2024 - January 21, 2025
**Posts**: 6 LinkedIn thought leadership posts
**Goal**: Prime pipeline for Q1 2025 with GRI-triggered discovery calls
**Framework**: 38 Questions integration for credibility

---

## Image Assets (All Complete)

| Post | Image File | Status |
|------|-----------|--------|
| Post 1 | Volume Reality - Addressable boxes infographic | READY |
| Post 2 | Contract Question - Locked contract + GRI calendar | READY |
| Post 3 | Peak Truth - Carrier Report Card BFCM 2024 | READY |
| Post 4 | Implementation Barriers - Crystal ball objections | READY |
| Post 5 | Zone Distribution - US map with zones | READY |
| Post 6 | GRI Reaction - Panic vs Calm response | READY |

**Image Location**: `C:\Users\BrettWalker\Downloads\` (Generated in Nano Banana Pro)

---

## Publishing Schedule

### Week 1: December 16-19
- [x] **Mon Dec 16, 8AM** - Post 1: Volume Reality Check ✅ POSTED Dec 15
  - Task file: `Post1_VolumeReality_Task.md`
  - CTA: "What % of your volume is truly addressable?"
  - Performance: 4 reactions (including Nate Skiver)

- [x] **Thu Dec 19, 8AM** - Post 2: Contract Question ✅ POSTED
  - Task file: `Post2_ContractQuestion_Task.md`
  - CTA: "Do you know your contract end date AND minimum commitment?"
  - Performance: 674 impressions, 11 reactions (Luc Jackman +10)

### Week 2: December 23
- [x] **Mon Dec 23, 8AM** - Post 3: Peak Season Truth ✅ POSTED Dec 17
  - Task file: `Post3_PeakTruth_Task.md`
  - CTA: "Grade your carrier: A, B, C, D, or F?"

### Week 3: December 30
- [x] **Mon Dec 30, 8AM** - Post 4: Implementation Barriers ✅ POSTED Dec 23
  - Task file: `Post4_ImplementationBarriers_Task.md`
  - CTA: "What's YOUR biggest barrier?" (revised empathetic version)
  - Note: Rewritten with collaborative framing - validates prospect responses instead of judging

### Week 4: January 6
- [ ] **Mon Jan 6, 8AM** - Post 5: Zone Distribution
  - Task file: `Post5_ZoneDistribution_Task.md`
  - CTA: "Drop your top 5 states - I'll analyze your zones"

### GRI Day: January 21
- [ ] **Tue Jan 21, ASAP after announcement** - Post 6: GRI Reaction
  - Task file: `Post6_GRIReaction_Task.md`
  - CTA: "DM me for help running the numbers"
  - **HARVEST TIME** - Block 2 hours for engagement

---

## Pre-Campaign Prep (Complete by Dec 15)

### Content Ready
- [x] All 6 LinkedIn posts written with improved CTAs
- [x] All 6 images generated in Nano Banana Pro
- [x] Task files created for each post
- [x] Rubric scores validated (all 26-30/30)

### Tools Setup
- [ ] LinkedIn: Draft posts saved (not scheduled)
- [ ] Calendar: Publish reminders set for each date
- [ ] HubSpot: "Pipeline Priming 2024" tag created
- [ ] Superhuman: DM templates ready for engaged prospects
- [ ] Calendly: Discovery call link tested

### Support Materials
- [ ] Zone analysis spreadsheet template ready
- [ ] Rate comparison examples prepared (for Post 6)
- [ ] Brand Scout workflow primed for engaged commenters

---

## Engagement Protocol

### Daily (During Campaign)
- [ ] Check LinkedIn notifications 3x daily (9am, 12pm, 5pm)
- [ ] Respond to all comments within 2 hours
- [ ] DM meaningful engagers same day

### Post-Engagement Workflow
1. **Comment received** → Like + thoughtful reply
2. **Detailed response** → DM with value offer
3. **DM conversation** → Offer zone analysis or rate review
4. **Interest confirmed** → Send Calendly link
5. **Meeting booked** → Create HubSpot contact + deal

### HubSpot Tagging
- Tag all engaged contacts: `Pipeline Priming Dec 2024`
- Note which post they engaged with
- Track: Comment → DM → Discovery → Deal

---

## Success Metrics

### Engagement Targets
| Metric | Target | Track In |
|--------|--------|----------|
| Total impressions | 10,000+ | LinkedIn Analytics |
| Comments | 50+ across all posts | LinkedIn |
| DMs received | 15+ | LinkedIn/Superhuman |
| Discovery calls booked | 5+ | Calendly/HubSpot |

### Conversion Funnel
```
Impressions → Comments → DMs → Discovery Calls → Proposals
   10K+    →   50+    → 15+ →     5+        →    2+
```

---

## Post-Campaign Analysis (Jan 22+)

- [ ] Export LinkedIn analytics for all 6 posts
- [ ] Document which posts drove most engagement
- [ ] Calculate comment → DM → discovery conversion rate
- [ ] Update rubric based on actual performance
- [ ] Plan Q1 follow-up content based on learnings

---

## Quick Reference

### Rubric Scores
| Post | Score | Weakest Dimension |
|------|-------|-------------------|
| Post 1 | 29/30 | CTA (improved) |
| Post 2 | 26/30 | CTA (improved) |
| Post 3 | 27/30 | CTA (improved) |
| Post 4 | 29/30 | CTA |
| Post 5 | 28/30 | Hook |
| Post 6 | 30/30 | Perfect |

### 38 Questions Integration
- Post 1: Q1, Q3, Q4, Q6 (Volume)
- Post 2: Q14, Q15 (Contracts)
- Post 3: Q19, Q20, Q21 (Peak Performance)
- Post 4: Q37, Q38 (Implementation)
- Post 5: Q17 (Geography)
- Post 6: Q11, Q36 (Cost/Value)

---

## Files in This Campaign

```
campaign-assets/
├── MASTER_CAMPAIGN_CHECKLIST.md (this file)
├── Post1_VolumeReality_Task.md
├── Post2_ContractQuestion_Task.md
├── Post3_PeakTruth_Task.md
├── Post4_ImplementationBarriers_Task.md
├── Post5_ZoneDistribution_Task.md
└── Post6_GRIReaction_Task.md
```

**Related Files**:
- `references/linkedin-posts.md` - Full post copy with scores
- `references/image-prompts-firstmile.md` - All Nano Banana Pro prompts
- `.claude/skills/nate-jones-deliberate-practice/references/11-linkedin-content-rubric.md` - Scoring rubric

---

*Campaign created: December 13, 2024*
*FirstMile OS - December Pipeline Priming Skill*
