# Discovery Call Prep Sheet: 2026 GRI Edition

**Generated:** December 15, 2025
**Source:** Perplexity Research API (60+ sources)
**Framework:** FirstMile CVM White Glove 38 Questions
**Purpose:** GRI-powered discovery ammunition for Q1 2026 prospecting

---

## Pre-Call Intelligence: 2026 GRI Landscape

### The Headlines vs. Reality

| What Carriers Announce | What Prospects Actually Face |
|------------------------|------------------------------|
| 5.9% average GRI | 7-12% effective increase |
| "Average rate increase" | Surgical pricing hitting specific profiles |
| Third year at 5.9% | Outpaces inflation 2x (inflation ~2.9%) |

### Key Dates to Reference

| Carrier | GRI Effective | Strategic Implication |
|---------|---------------|----------------------|
| UPS | December 22, 2025 | Captures peak season at higher rates |
| FedEx | January 6, 2026 | Post-peak timing |
| DHL | January 1, 2026 | 5-7% increase |

### Six "Gotchas" to Surface

1. **Dual Dimensional Triggers** (UPS Jan 26) - Cubic volume ON TOP of L+G
2. **Residential Surcharge** - +8.4% FedEx, +6.6% UPS
3. **Minimum Charge Floor** - $11.32 → $11.99
4. **Surcharge Stacking** - 10-15%+ real increase
5. **Off-Cycle Adjustments** - 7+ fuel table changes in 2024
6. **UPS Timing Trap** - Dec 22 captures peak

---

## Section 1: Volume Reality (Questions 1-9)

**Must Capture:** REAL addressable volume with ±10% confidence

### GRI-Powered Questions

**Q1: Total Volume**
> "What's your total annual parcel volume across all carriers?"

*GRI Hook:* "Most brands find the 5.9% headline understates their real exposure by 2-3x once you model it against actual shipment profile."

**Q2: Volume Commitments**
> "Do you have minimum volume commitments with current carriers?"

*GRI Hook:* "With the January increases, we're seeing brands re-evaluate whether hitting minimums at these rates makes sense vs. diversifying."

**Q3: Volume by Service Level**
> "How does your volume break down by service level - ground vs. expedited vs. priority?"

*GRI Hook:* "Ground residential is getting hit hardest - 8.4% surcharge increase on FedEx alone."

**Q4: Volume by Weight Profile**
> "What's your typical weight distribution? Under 1 lb, 1-5 lb, over 5 lb?"

*GRI Hook:* "The new $11.99 minimum charge floor is brutal for lightweight goods - negotiated discounts get nullified."

**Q5: Dimensional Profile**
> "Do you have any SKUs that are lightweight but bulky - like promotional kits or home goods?"

*GRI Hook:* "UPS is adding dual dimensional triggers in January - cubic volume criteria ON TOP of Length + Girth. Packages that passed before will now get hit."

**Q6: Realistic Addressable %**
> "Of that total volume, what percentage could realistically move to a new carrier?"

*Listen for:* Vague answers = red flag. Push for specific percentage.

**Q7: Volume Trajectory**
> "Is your volume growing, stable, or declining? What's the trend?"

*GRI Hook:* "Growing brands are getting squeezed - rates compound on top of volume growth."

**Q8: Seasonal Patterns**
> "What does your peak season look like? How much of annual volume is Q4?"

*GRI Hook:* "UPS went effective Dec 22 specifically to capture peak at higher rates."

**Q9: Volume Exclusions**
> "Any volume that's locked or can't move - international, hazmat, specific requirements?"

*Document all exclusions clearly.*

### Section 1 Scoring (Practice Gym)

| Score | Criteria |
|-------|----------|
| 1 | Vague "they ship a lot" |
| 3 | 5+ questions answered; ±20% variance |
| 5 | All 9 answered; ±10% variance; exclusions documented |

---

## Section 2: Carrier Setup (Questions 10-16)

**Must Capture:** Why they'd switch - specific pain points

### GRI-Powered Questions

**Q10: Current Carrier Mix**
> "Walk me through your current carrier setup - who are you using and for what?"

*GRI Hook:* "Single-carrier relationships are becoming risky - the Canada Post strike was a wake-up call for a lot of brands."

**Q11: Current Costs**
> "What are you spending annually on parcel shipping? Ballpark is fine."

*GRI Hook:* "After January, budget 8-12% real increase for planning - not the 5.9% headline."

**Q12: Cost Visibility**
> "How much visibility do you have into your actual costs - base rates vs. surcharges?"

*GRI Hook:* "Surcharge stacking is where the real damage happens - a single package can trigger residential + DAS + additional handling + fuel on ALL of them."

**Q13: Current Pain Points**
> "What's frustrating you most about your current shipping setup?"

*Listen for:* Cost unpredictability, service failures, lack of support, invoice surprises

**Q14: Contract Details**
> "When does your current contract expire? Any renewal clauses?"

*GRI Hook:* "If you're locked until after January, you're eating these increases for another year. Worth knowing your options."

**Q15: Contract Penalties**
> "Are there penalties for not hitting minimums or early termination?"

*Document specific penalty structure.*

**Q16: Previous Carrier Changes**
> "Have you switched carriers in the past? What drove that decision?"

*Listen for:* What mattered enough to make them move before.

### Section 2 Scoring (Practice Gym)

| Score | Criteria |
|-------|----------|
| 1 | Don't know current carriers |
| 3 | Primary carrier + 2-3 pain points |
| 5 | Full competitive landscape; contract penalties |

---

## Section 3: Service Requirements (Questions 17-24)

**Must Capture:** SLA expectations and what "good" looks like to them

### GRI-Powered Questions

**Q17: Top Destination States**
> "Where are your top 5 destination states? What percentage of volume?"

*FirstMile Hook:* "We can map that against our Select network - zone-skipping through our sort facilities in SLC, LAX, ATL, PA."

**Q18: Transit Time Expectations**
> "What transit times do your customers expect? What do you promise?"

*GRI Hook:* "Here's what's interesting - speed dropped from #1 customer priority in 2022 to #5 in 2024. 90% will wait 2-3 days if shipping is free."

**Q19: On-Time Performance Requirements**
> "What on-time percentage do you need? What are you getting today?"

*FirstMile Hook:* "Regional carriers are hitting 97-99% vs. FedEx's 91.8%. That gap matters."

**Q20: Peak Season Performance**
> "How did peak season go? Any service failures?"

*GRI Hook:* "Peak exposed a lot of single-carrier risk this year."

**Q21: Special Handling Requirements**
> "Any SKUs need special handling - fragile, oversized, temperature-sensitive?"

*Document all special requirements.*

**Q22: Returns Volume**
> "What's your returns volume? How are you handling reverse logistics?"

*FirstMile Hook:* "Returns are part of our single platform - one support thread for outbound, returns, claims."

**Q23: Customer Communication**
> "How important is proactive tracking communication to your customers?"

*GRI Hook:* "88% say real-time tracking is critical - it's #4 on the priority list now."

**Q24: Free Shipping Strategy**
> "What's your free shipping threshold? How did you set it?"

*GRI Hook:* "51% of shoppers add items to reach free shipping threshold. Shoppers spend 30% more on orders with free shipping. Worth optimizing that number based on your margins, not arbitrary."

### Section 3 Scoring (Practice Gym)

| Score | Criteria |
|-------|----------|
| 1 | No SLA requirements captured |
| 3 | Top destinations; basic transit expectations |
| 5 | Peak performance data; special handling documented |

---

## Section 4: Operational Fit (Questions 25-32)

**Must Capture:** Integration path and operational constraints

### GRI-Powered Questions

**Q25: Fulfillment Locations**
> "Where are you shipping from? Own warehouse, 3PL, multi-node?"

*FirstMile Hook:* "Multiple locations feed our dynamic routing - we auto-select best induction point nightly."

**Q26: Cutoff Times**
> "What's your current ship cutoff? Is that a constraint?"

*Document hard cutoffs.*

**Q27: WMS/OMS**
> "What warehouse management or order management system are you on?"

*FirstMile Hook:* "Single integration to our platform covers all services and carriers."

**Q28: Tech Stack**
> "What's your broader tech stack - Shopify, custom, ERP?"

*Document integration requirements.*

**Q29: API Requirements**
> "Do you need API integration or is a portal/plug-in sufficient?"

*FirstMile Hook:* "We support both - most brands start with Shopify/WooCommerce plug-in and add API for custom flows."

**Q30: Label Generation**
> "How are you generating labels today?"

*Document current workflow.*

**Q31: Team Structure**
> "Who on your team handles shipping operations day-to-day?"

*Identify operational stakeholder.*

**Q32: IT Involvement**
> "Will IT need to be involved in evaluating or implementing?"

*Red Flag:* IT not involved but integration required = deal risk.

### Section 4 Scoring (Practice Gym)

| Score | Criteria |
|-------|----------|
| 1 | No tech stack info |
| 3 | WMS known; basic integration path |
| 5 | Full tech stack; cutoffs, locations, team structure |

---

## Section 5: Decision & Commitment (Questions 33-38)

**Must Capture:** Lock the deal - who decides, when, what's in the way

### GRI-Powered Questions

**Q33: Decision Makers**
> "Who needs to be involved in this decision? Walk me through your buying process."

*Map the full committee:* Economic buyer, technical buyer, champion, blocker

**Q34: Timeline**
> "What's your timeline for making a decision?"

*GRI Hook:* "January 6 is FedEx, January 21 is UPS. If you want to model alternatives before you're locked in, the window is now."

**Q35: Evaluation Criteria**
> "What criteria matter most in your evaluation? How will you compare options?"

*Listen for:* Cost, service, integration ease, support, risk

**Q36: Budget Process**
> "Is there budget allocated for this, or does it need to be approved?"

*Document budget constraints and approval process.*

**Q37: Commitment Level**
> "If we can show clear savings and service improvement, what does a pilot look like?"

*Push for specific:* Volume, duration, success criteria

**Q38: Barriers**
> "What would prevent you from moving forward, even if everything else looks good?"

*Red Flags to surface:*
- "Let's start small and see" without defined ramp
- Vague answers on volume control
- Multiple decision-makers with unclear authority
- IT not involved but integration needed
- No clear pain point driving the change

### Section 5 Scoring (Practice Gym)

| Score | Criteria |
|-------|----------|
| 1 | Don't know who decides |
| 3 | Decision-maker + timeline captured |
| 5 | Full buying committee; commitment locked; barriers identified |

---

## FirstMile Solution Mapping

**Use after surfacing pain - don't pitch, solve:**

| Pain Point Surfaced | Xparcel Solution |
|---------------------|------------------|
| Surcharge stacking (10-15%+) | Dynamic routing avoids trigger thresholds |
| Residential surcharge (+8.4%) | Zone-skip through sort facilities (SLC/LAX/ATL/PA) |
| Dimensional gotchas | ML routing optimizes by package profile |
| Single carrier risk | 12 carrier integrations, one contract |
| Cost unpredictability | FirstMile absorbs rate volatility in model |
| Minimum charge floor ($11.99) | Ounce-based optimization for lightweights |
| Invoice surprises | Audit Queue blocks mis-rated labels before invoice |
| Support fragmentation | Single support thread - claims, returns, exceptions |

---

## Red Flags Checklist

Document if you hear any of these:

- [ ] Vague answers on actual volume control
- [ ] "Let's start small and see" with no defined ramp criteria
- [ ] Multiple decision-makers with unclear authority
- [ ] IT/integration team not involved but needed
- [ ] No clear pain point driving the change
- [ ] Contract penalties they're unaware of
- [ ] Unrealistic timeline expectations
- [ ] Looking for lowest price only (no value conversation)

---

## Post-Call Scoring

**Use Practice Gym Rubric 3 to self-evaluate:**

| Dimension | Your Score (1-5) | Notes |
|-----------|------------------|-------|
| Section 1: Volume Reality | | |
| Section 2: Carrier Setup | | |
| Section 3: Service Requirements | | |
| Section 4: Operational Fit | | |
| Section 5: Decision & Commitment | | |
| Red Flags Documented | | |

**Overall Discovery Score:** ___/30

**Key Gaps to Address on Follow-Up:**
1.
2.
3.

---

## Quick Reference: Customer Priority Hierarchy (2025)

| Priority | What Customers Want | Implication |
|----------|---------------------|-------------|
| #1 | Free Shipping | 90% say it's best incentive; build into price |
| #2 | Reliability | On-time > fast; don't overpromise |
| #3 | Flexibility | 76% want personalized options |
| #4 | Transparency | 88% find tracking critical |
| #5 | Speed | Dropped from #1; 2-3 days acceptable if free |

---

## Sources

Partnership.com, Sifted, Enveyo, LJM, Shipware, Parcel Industry, TransImpact, BSG Supply Chain, Reveel Group, Cass Info, GoBolt, McKinsey, DHL, FedEx, ShipStation, Extensiv + 40 additional sources via Perplexity Research API
