# Email Templates - December Pipeline Priming

3-email December sequence using Brand Scout intel + 38 Questions hooks. Goal: recognition, not conversion.

## Pomeli Visual Assets (Optional Attachments)

| Email | Recommended Image | Path |
|-------|-------------------|------|
| Email 1 | Stop Juggling Carriers | `marketing_assets/linkedin_ads/02_stop_juggling_carriers.png` |
| Email 2 | Post-Holiday Surge Solved | `marketing_assets/linkedin_ads/05_post_holiday_surge_solved.png` |
| Email 3 | Predictable Speed, Lower Costs | `marketing_assets/linkedin_ads/08_predictable_speed_lower_costs.png` |

*See full mapping: `marketing_assets/ASSET_MANIFEST.md`*

---

## Email 1: The Volume Reality Hook
**Send:** Immediately after Brand Scout research
**Purpose:** Plant the seed, show you've done homework
**38 Questions Source:** Q1, Q3, Q4, Q6

### Subject Lines (A/B test)
- Quick question about [COMPANY]'s shipping mix
- [FIRST NAME], curious about your carrier split
- Do you control all [COMPANY]'s volume?

### Body Template

```
Hi [FIRST NAME],

Doing some research on [COMPANY] - looks like you're shipping out of [LOCATION from Brand Scout] [using CARRIER if known from Brand Scout].

Quick question that's been on my mind:

Of your total parcel volume, how much do you actually control vs. what's locked to marketplaces or 3PL decisions?

I ask because January rate increases hit in 6 weeks, and the brands who know their REAL addressable volume are the ones who can actually do something about it.

Not trying to sell you anything in December - I know you're buried in peak. Just curious if this is something you've mapped out.

Brett Walker
Revenue Architect, FirstMile

P.S. - If you're seeing [SPECIFIC PAIN POINT from Brand Scout - e.g., "zone 8 pricing pressure to Northeast" or "DHL claims taking forever"], happy to share what similar brands are doing.
```

### Personalization Variables
- `[COMPANY]` - Company name
- `[FIRST NAME]` - Contact first name
- `[LOCATION]` - Fulfillment location from Brand Scout
- `[CARRIER]` - Current carrier if known
- `[SPECIFIC PAIN POINT]` - From Brand Scout research

---

## Email 2: Peak Season Check-In
**Send:** Dec 23-27 (post-BFCM timing)
**Purpose:** Capture frustration while it's fresh
**38 Questions Source:** Q19, Q20, Q21

### Subject Lines (A/B test)
- How'd [CARRIER] hold up?
- Peak's over - how'd it go?
- [COMPANY]'s BFCM shipping report card?

### Body Template

```
Hi [FIRST NAME],

Peak's winding down - hope [COMPANY] crushed it.

Genuine question: How did your carrier actually perform?

I'm tracking patterns across brands and curious:
- On-time delivery hold steady or slip?
- Any capacity surprises?
- Claims backlog building up?

Not looking to pitch you while you're still catching your breath. Just gathering intel on what's actually happening out there.

If [CARRIER] held up great - awesome, that's good data.
If not - worth a conversation in January before GRI hits.

Either way, hope you get some rest before the holidays.

Brett

P.S. - Saw [SOMETHING RELEVANT from recent news/LinkedIn about company]. [Brief relevant comment].
```

### Personalization Variables
- `[COMPANY]` - Company name
- `[FIRST NAME]` - Contact first name
- `[CARRIER]` - Current carrier
- `[SOMETHING RELEVANT]` - Recent company news, LinkedIn post, product launch

---

## Email 3: January GRI Primer
**Send:** Jan 6-10 (pre-GRI)
**Purpose:** Create urgency, offer value
**38 Questions Source:** Q11, Q14, Q36

### Subject Lines (A/B test)
- January 21 is coming
- [CARRIER] GRI drops in [X] days
- 3 questions before GRI hits

### Body Template

```
Hi [FIRST NAME],

[CARRIER] GRI announcement drops soon. Based on what I'm seeing, expect [X-Y%] increases.

Before the rate panic starts, three questions worth answering:

1. What's your current cost per package by service level?
2. When does your carrier contract actually expire?
3. What volume can you realistically move if you found a better option?

Brands who answer these NOW have leverage in January.
Brands who wait scramble.

Happy to run a quick analysis on your shipping profile if helpful - no commitment, just math.

Worth 15 minutes in early January?

Brett Walker
FirstMile | [CALENDLY LINK]

P.S. - I touched base [in December / after peak] about [REFERENCE PREVIOUS EMAIL]. This is the follow-through.
```

### Personalization Variables
- `[CARRIER]` - Their primary carrier
- `[X-Y%]` - Expected GRI percentage for that carrier
- `[CALENDLY LINK]` - Your booking link
- `[REFERENCE PREVIOUS EMAIL]` - What you discussed in Email 1 or 2

---

## GRI Data for Personalization

Use these estimates for Email 3 (update when official announcements drop):

| Carrier | Expected GRI | Effective Date |
|---------|--------------|----------------|
| UPS | 5.9% | Jan 21, 2025 |
| FedEx | 5.9% | Jan 6, 2025 |
| USPS | 3.2% (pending) | TBD |
| DHL | 5-7% | Jan 1, 2025 |

---

## Sequence Timing

| Email | Timing | Trigger |
|-------|--------|---------|
| Email 1 | Immediately | After Brand Scout complete |
| Email 2 | Dec 23-27 | Post-BFCM, batch send |
| Email 3 | Jan 6-10 | Pre-GRI, batch send |
| Follow-up | Jan 21+ | GRI drops, warm outreach |

---

## Response Handling

**If they reply to Email 1 or 2:**
- Engage conversationally
- Ask one follow-up question from 38 Questions
- Don't pitch - build relationship
- Flag for January priority follow-up

**If they don't reply:**
- Continue sequence
- They're busy, not uninterested
- December silence ≠ January silence

**If they ask for analysis:**
- Run quick shipping profile
- Use as discovery conversation
- Book January call
