# FirstMile LinkedIn Image Prompts

Nano Banana Pro prompts for the 6-post December Pipeline Priming series. All styled with FirstMile brand (#366092 navy blue).

---

## Post 1: Volume Reality Check (Dec 16)
**Status**: COMPLETE - Scored 29/30

### Image Prompt
```
Professional LinkedIn infographic, clean business style. Left side shows large chaotic pile of cardboard shipping boxes labeled "TOTAL VOLUME 500K/yr" with subtitle "Aspirational Numbers" and red question mark. Three sections of boxes have icons: padlock icon labeled "FBA (Locked)", chain link icon labeled "3PL-Managed (Locked Carrier)", cloud icon labeled "Marketplace-Fulfilled (Out of Hands)". Large arrow pointing right to smaller neat organized stack of boxes labeled "ADDRESSABLE VOLUME 200K/yr" with subtitle "REAL Numbers" and green checkmark. Hand cursor pointing at addressable stack. Bottom banner reads "The best partnerships start with REAL numbers. What percentage do you actually control?" Color scheme: primary accent color #366092 navy blue, white backgrounds, clean minimalist design, subtle blue gradient background, professional corporate infographic style, no people, 16:9 aspect ratio
```

---

## Post 2: The Contract Question Nobody Asks (Dec 19)

### Original Post Copy
```
January rate increases are coming.

Before you panic-switch carriers, answer this:

"What minimum volume commitments do you have with your current carrier, and what penalties apply if you don't meet them?"

I've seen brands locked into contracts with $25K+ penalties they forgot about.

Switching isn't always the answer. Sometimes it's renegotiating.

But you can't strategize what you don't know.

When does your carrier contract actually expire?

#GRI2025 #shipping #ecommerce #logistics
```

### Image Prompt
```
Professional LinkedIn infographic about carrier contracts. Split design: Left side shows a document/contract with a large padlock and chain wrapped around it, labeled "CURRENT CONTRACT" with warning elements showing "Minimum Volume: 50K/mo", "Penalty: $25,000", "Expires: ???". Right side shows a calendar with January 2025 highlighted in red with "GRI" and upward arrow, showing rate increase warning. Center shows a person silhouette with question mark above head, caught between contract lock and rate increase. Bottom banner in navy blue #366092 reads "You can't strategize what you don't know. When does your contract expire?" Clean corporate infographic style, white background with subtle blue gradient, professional business aesthetic, no real people faces, 16:9 aspect ratio
```

### Evaluation

| Dimension | Score | Evidence |
|-----------|-------|----------|
| Hook Strength | **4** | "January rate increases are coming" - timely but not unexpected |
| Insight Density | **4** | $25K penalty example is specific; contract vs renegotiation insight |
| Visual Clarity | **5** | Contract lock + calendar GRI = clear visual story |
| Brand Alignment | **5** | #366092, professional, data-driven |
| CTA Quality | **3** | "When does your carrier contract actually expire?" - decent but generic |
| 38Q Integration | **5** | Directly Q14 (commitments) and Q15 (penalties) |

**Total: 26/30** - Good, but CTA could be stronger

### Improved CTA
**Current**: "When does your carrier contract actually expire?"
**Stronger**: "Pop quiz: Do you know your contract end date AND your minimum commitment? Reply with both - I'll tell you if you have room to move."

---

## Post 3: Peak Season Truth Serum (Dec 23)

### Original Post Copy
```
Peak season reveals everything.

One question I ask every brand in January:

"How did your carrier perform during BFCM?"

Not what they promised. What actually happened.

- On-time delivery rate?
- Claims processed in how many days?
- Did they have capacity when you needed it?

If you can't answer these questions, you're flying blind into 2025.

How did your carrier actually perform this peak?

#BFCM #peakseason #ecommerce #shipping
```

### Image Prompt
```
Professional LinkedIn infographic about peak season carrier performance. Visual concept: Large magnifying glass examining a report card or scorecard. The scorecard shows three metrics with check/X marks: "On-Time Delivery: ?" with empty checkbox, "Claims Processing: ? days" with empty checkbox, "Capacity Available: ?" with empty checkbox. Behind the magnifying glass, faded images of holiday shopping (gift boxes, shopping bags) representing BFCM peak. Title at top: "PEAK SEASON REPORT CARD" with subtitle "What actually happened vs what they promised". Bottom banner in navy blue #366092 reads "If you can't answer these questions, you're flying blind into 2025." Clean corporate style, white background, professional business aesthetic, #366092 navy blue accents throughout, no real people, 16:9 aspect ratio
```

### Evaluation

| Dimension | Score | Evidence |
|-----------|-------|----------|
| Hook Strength | **5** | "Peak season reveals everything" - provocative truth |
| Insight Density | **4** | Three specific metrics to track; "promised vs actual" framing |
| Visual Clarity | **5** | Report card metaphor is instantly understood |
| Brand Alignment | **5** | Professional, data-driven, FirstMile blue |
| CTA Quality | **3** | "How did your carrier actually perform this peak?" - open but vague |
| 38Q Integration | **5** | Maps to Q19 (on-time), Q20 (claims), Q21 (capacity) |

**Total: 27/30** - Strong, CTA needs specificity

### Improved CTA
**Current**: "How did your carrier actually perform this peak?"
**Stronger**: "Grade your carrier's peak performance: A, B, C, D, or F? Drop your grade and one word why."

---

## Post 4: The Question That Predicts Implementation Failure (Dec 30)

### Original Post Copy
```
This question predicts whether a carrier switch will succeed or fail:

"What would prevent you from ramping to full volume after a successful test?"

Sounds simple. But the answers reveal everything:

- "We'll start small and see" = No commitment
- "Need to check with IT" = Decision-maker not in the room
- "Let's wait until after peak" = Indefinite delay

"Nothing - if you hit 95% on-time, we're moving 100%" = Real partner

The best carrier relationships start with honest conversations about barriers.

What would prevent YOU from switching?

#shipping #logistics #ecommerce #carrierswitching
```

### Image Prompt
```
Professional LinkedIn infographic about carrier switching barriers. Visual layout: Center shows a crystal ball or fortune-telling orb with "IMPLEMENTATION SUCCESS?" inside. Around the crystal ball, four speech bubbles with different responses: RED bubble "We'll start small and see" with X mark, RED bubble "Need to check with IT" with X mark, RED bubble "Let's wait until after peak" with X mark, GREEN bubble "Nothing - if you hit 95%, we're moving 100%" with checkmark. Each red bubble has small text underneath: "No commitment", "Wrong room", "Indefinite delay". The green bubble has "Real partner" underneath. Bottom banner in navy blue #366092 reads "The best partnerships start with honest conversations about barriers." Clean corporate infographic, white background, #366092 navy accents, professional business style, no real people faces, 16:9 aspect ratio
```

### Evaluation

| Dimension | Score | Evidence |
|-----------|-------|----------|
| Hook Strength | **5** | "This question predicts whether a carrier switch will succeed or fail" - high stakes, specific |
| Insight Density | **5** | Red flag decoder (3 bad answers + translations); green flag example |
| Visual Clarity | **5** | Crystal ball + speech bubbles = prediction metaphor clear |
| Brand Alignment | **5** | Professional, insightful, FirstMile blue |
| CTA Quality | **4** | "What would prevent YOU from switching?" - personal but could be more engaging |
| 38Q Integration | **5** | Directly Q37 (barriers) and Q38 (ramp commitment) |

**Total: 29/30** - Excellent

### Minor CTA Enhancement
**Current**: "What would prevent YOU from switching?"
**Stronger**: "Honest moment: Which of these responses sounds like something you'd say? No judgment - awareness is step one."

---

## Post 5: The 5 States That Matter (Jan 6)

### Original Post Copy
```
Simple question that changes everything:

"What are your top 5 destination states by volume?"

Why it matters:

Zone distribution determines your shipping costs more than anything.

Ship mostly to CA from a TX warehouse? Zone 4-5.
Ship mostly to NY from that same TX warehouse? Zone 7-8.

Different zones = different carrier strengths = different strategies.

Most brands don't know their zone distribution. The ones who do save 20-30%.

Do you know your top 5 destination states?

#shipping #logistics #ecommerce #zoneoptimization
```

### Image Prompt
```
Professional LinkedIn infographic about shipping zone distribution. Visual: Simplified US map with Texas highlighted as origin point (warehouse icon). Two destination scenarios shown with colored paths: Path 1 to California showing "Zone 4-5" in green/yellow, Path 2 to New York showing "Zone 7-8" in orange/red. The five top destination states are highlighted with ranking numbers (1-5). Side panel shows "ZONE IMPACT" with cost comparison: "Zone 4-5: $X" vs "Zone 7-8: $XX" showing significant difference. Bottom text: "Different zones = Different strategies". Bottom banner in navy blue #366092 reads "Most brands don't know their zone distribution. The ones who do save 20-30%." Clean corporate infographic style, white background, #366092 navy blue accents, professional map visualization, no people, 16:9 aspect ratio
```

### Evaluation

| Dimension | Score | Evidence |
|-----------|-------|----------|
| Hook Strength | **4** | "Simple question that changes everything" - good but slightly generic |
| Insight Density | **5** | TX→CA vs TX→NY zone example; 20-30% savings stat; zone=strategy insight |
| Visual Clarity | **5** | Map with zone paths is immediately understandable |
| Brand Alignment | **5** | Data-driven, professional, FirstMile blue |
| CTA Quality | **4** | "Do you know your top 5 destination states?" - clear but could offer more |
| 38Q Integration | **5** | Directly Q17 (destination geography) |

**Total: 28/30** - Very strong

### CTA Enhancement
**Current**: "Do you know your top 5 destination states?"
**Stronger**: "Drop your top 5 destination states below. I'll tell you which zones are likely eating your margins."

---

## Post 6: GRI Reaction (Jan 21 - Day Of)

### Original Post Copy
```
GRI 2025 just dropped.

[CARRIER] rates going up [X]% effective [DATE].

Before you panic:

1. What's your ACTUAL cost per package today? (Not what you think - what the data shows)

2. What improvement would justify the pain of switching? (Be specific - 10%? 20%? 30%?)

3. Do you know your zone distribution well enough to compare apples to apples?

The brands who answer these questions calmly will save money.

The brands who panic-switch without data will regret it.

DM me if you want help running the numbers. No pitch - just math.

#GRI2025 #shipping #ecommerce #logistics #rateincreases
```

### Image Prompt
```
Professional LinkedIn infographic about GRI rate increase response. Visual concept: Split screen showing two paths. LEFT PATH (red/chaotic): Figure running with hair on fire, surrounded by spinning percentage symbols and "PANIC!" text, arrow pointing to cliff edge labeled "Bad Decision". RIGHT PATH (blue/calm): Figure at desk with calculator and charts, surrounded by organized data showing "Cost/Package: $X", "Target Savings: 20%", "Zone Mix: Known", arrow pointing to money/savings icon. Center divider shows "GRI 2025" with large percentage arrow pointing up. Top text: "Two responses to rate increases". Bottom banner in navy blue #366092 reads "The brands who answer calmly will save money. The brands who panic will regret it." Clean corporate infographic, white background, #366092 navy blue accents, professional business style, simple iconographic figures (not real people), 16:9 aspect ratio
```

### Evaluation

| Dimension | Score | Evidence |
|-----------|-------|----------|
| Hook Strength | **5** | "GRI 2025 just dropped" - immediate relevance, timely |
| Insight Density | **5** | Three specific questions to answer; panic vs calm framing; "apples to apples" zone insight |
| Visual Clarity | **5** | Two-path visual (panic vs calm) is universal metaphor |
| Brand Alignment | **5** | Professional, helpful positioning, FirstMile blue |
| CTA Quality | **5** | "DM me if you want help running the numbers. No pitch - just math." - low friction, high value |
| 38Q Integration | **5** | Q11 (actual cost), Q36 (switching threshold), Q17 (zone distribution) |

**Total: 30/30** - Perfect. This is harvest time - the whole campaign builds to this.

---

## Summary Scorecard

| Post | Date | Score | Needs Work? |
|------|------|-------|-------------|
| 1. Volume Reality | Dec 16 | 29/30 | CTA minor tweak |
| 2. Contract Question | Dec 19 | 26/30 | CTA improvement |
| 3. Peak Truth | Dec 23 | 27/30 | CTA improvement |
| 4. Implementation Barriers | Dec 30 | 29/30 | CTA minor tweak |
| 5. Zone Distribution | Jan 6 | 28/30 | CTA minor tweak |
| 6. GRI Reaction | Jan 21 | 30/30 | Ready to publish |

**Pattern**: CTAs are the consistent weak dimension. The posts have strong hooks and insights but the closing asks don't always offer value in exchange for engagement.

---

## Quick Reference: Image Prompt Elements

**Always include**:
- "Professional LinkedIn infographic"
- "#366092 navy blue" for brand color
- "Clean corporate infographic style"
- "White background with subtle blue gradient"
- "Bottom banner in navy blue #366092"
- "No real people faces" or "iconographic figures"
- "16:9 aspect ratio"

**Visual metaphors that work**:
- Before→After transformations (Post 1)
- Locked vs unlocked (Post 2)
- Report cards/scorecards (Post 3)
- Crystal ball/prediction (Post 4)
- Maps with paths (Post 5)
- Two-path choices (Post 6)
